#pragma once

#include "NasEmu_Common4G5G.hh"

#include "layer.hh"
#include "params.hh"

namespace NasEmu__Common4G5G {
  class NASEmu__CoOrd__REQ;
  class NASEmu__CoOrd__CNF;
}

namespace NasEmu__Common4G5G {

  //class HttpPort : public HttpPort_BASE {
  class NASEMU5G__CO__ORD__PORT : public NASEMU5G__CO__ORD__PORT_BASE {
    params _cfg_params;
    params _layer_params;
    layer* _layer;
    std::string _time_key;
  public:
    NASEMU5G__CO__ORD__PORT(const char *par_port_name);
    ~NASEMU5G__CO__ORD__PORT();

    void set_parameter(const char *parameter_name, const char *parameter_value);
    void receiveMsg (const NasEmu__Common4G5G::NASEmu__CoOrd__REQ& p_ind, const params& p_params);

  private:
    /* void Handle_Fd_Event(int fd, boolean is_readable,
       boolean is_writable, boolean is_error); */
    void Handle_Fd_Event_Error(int fd);
    void Handle_Fd_Event_Writable(int fd);
    void Handle_Fd_Event_Readable(int fd);
    /* void Handle_Timeout(double time_since_last_call); */

  protected:
    void user_map(const char *system_port);
    void user_unmap(const char *system_port);

    void user_start();
    void user_stop();

  protected:
    void outgoing_send(const NasEmu__Common4G5G::NASEmu__CoOrd__CNF& send_par);
  }; // End of class NASEMU5G__CO__ORD__PORT

} // End of namespace NasEmu__Common4G5G

