%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_Discriminator).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case ndto_validation:'andalso'([{fun '$.required'/1,
                                     [Val]},
                                    {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.required'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      not maps:is_key(Property, Val)
                              end,
                              [<<"propertyName">>])
        of
        {false, none} -> true;
        {true, MissingProperty} ->
            {false,
             {'$.',
              erlang:list_to_binary(io_lib:format("$. is missing required property ~p",
                                                  [MissingProperty]))}}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.propertyName'/1,
                                    [maps:get(<<"propertyName">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.mapping'/1,
                                    [maps:get(<<"mapping">>, Val, undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties.propertyName'(undefined) -> true;
'$.properties.propertyName'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.propertyName'(_Val) ->
    {false,
     {'$.properties.propertyName.type',
      <<"Value is not a string">>}}.

'$.properties.mapping'(undefined) -> true;
'$.properties.mapping'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.mapping.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.mapping'(_Val) ->
    {false,
     {'$.properties.mapping.type',
      <<"Value is not an object">>}}.

'$.properties.mapping.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.properties.mapping.additional_properties'(maps:get(Property,
                                                                                                Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.properties.mapping.additional_properties'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.mapping.additional_properties'(_Val) ->
    {false,
     {'$.properties.mapping.additional_properties.type',
      <<"Value is not a string">>}}.