%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties'/1,
                                    [Val]},
                                   {fun '$.pattern_properties'/1, [Val]},
                                   {fun '$.required'/1, [Val]},
                                   {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties'(Val) ->
    case
        sets:to_list(sets:subtract(sets:from_list(maps:keys(Val)),
                                   sets:from_list(lists:append([<<"components">>,
                                                                <<"externalDocs">>,
                                                                <<"info">>,
                                                                <<"openapi">>,
                                                                <<"paths">>,
                                                                <<"security">>,
                                                                <<"servers">>,
                                                                <<"tags">>],
                                                               lists:filter(fun
                                                                                (PropertyName) ->
                                                                                    lists:any(fun
                                                                                                  (Pattern) ->
                                                                                                      case
                                                                                                          re:run(PropertyName,
                                                                                                                 Pattern)
                                                                                                          of
                                                                                                          {match,
                                                                                                           _Captured} ->
                                                                                                              true;
                                                                                                          _nomatch ->
                                                                                                              false
                                                                                                      end
                                                                                              end,
                                                                                              [<<"^x-">>])
                                                                            end,
                                                                            maps:keys(Val))))))
        of
        [] -> true;
        UnsupportedKeys ->
            {false,
             {'$.additional_properties',
              erlang:list_to_binary(io_lib:format("Object has unsupported keys: ~ts",
                                                  [ndto_validation:format_properties(UnsupportedKeys)]))}}
    end.

'$.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.pattern_properties.^x-.any_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^x-">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.required'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      not maps:is_key(Property, Val)
                              end,
                              [<<"openapi">>, <<"info">>, <<"paths">>])
        of
        {false, none} -> true;
        {true, MissingProperty} ->
            {false,
             {'$.',
              erlang:list_to_binary(io_lib:format("$. is missing required property ~p",
                                                  [MissingProperty]))}}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.tags'/1,
                                    [maps:get(<<"tags">>, Val, undefined)]},
                                   {fun '$.properties.servers'/1,
                                    [maps:get(<<"servers">>, Val, undefined)]},
                                   {fun '$.properties.security'/1,
                                    [maps:get(<<"security">>, Val, undefined)]},
                                   {fun '$.properties.paths.ref'/1,
                                    [maps:get(<<"paths">>, Val, undefined)]},
                                   {fun '$.properties.openapi'/1,
                                    [maps:get(<<"openapi">>, Val, undefined)]},
                                   {fun '$.properties.info.ref'/1,
                                    [maps:get(<<"info">>, Val, undefined)]},
                                   {fun '$.properties.externalDocs.ref'/1,
                                    [maps:get(<<"externalDocs">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.components.ref'/1,
                                    [maps:get(<<"components">>,
                                              Val,
                                              undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.pattern_properties.^x-.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.pattern_properties.^x-.any_of[4]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.pattern_properties.^x-.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[2]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[2].type',
      <<"Value is not a string">>}}.

'$.pattern_properties.^x-.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[1].type',
      <<"Value is not an array">>}}.

'$.pattern_properties.^x-.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[0].type',
      <<"Value is not an object">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.tags'(undefined) -> true;
'$.properties.tags'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.tags.unique_items'/1,
                                    [Val]},
                                   {fun '$.properties.tags.items'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.tags'(_Val) ->
    {false,
     {'$.properties.tags.type',
      <<"Value is not an array">>}}.

'$.properties.servers'(undefined) -> true;
'$.properties.servers'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.servers.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.servers'(_Val) ->
    {false,
     {'$.properties.servers.type',
      <<"Value is not an array">>}}.

'$.properties.security'(undefined) -> true;
'$.properties.security'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.security.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.security'(_Val) ->
    {false,
     {'$.properties.security.type',
      <<"Value is not an array">>}}.

'$.properties.paths.ref'(undefined) -> true;
'$.properties.paths.ref'(Val) ->
    oas_3_0_Paths:is_valid(Val).

'$.properties.openapi'(undefined) -> true;
'$.properties.openapi'(Val) when is_binary(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.openapi.pattern'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.openapi'(_Val) ->
    {false,
     {'$.properties.openapi.type',
      <<"Value is not a string">>}}.

'$.properties.info.ref'(undefined) -> true;
'$.properties.info.ref'(Val) ->
    oas_3_0_Info:is_valid(Val).

'$.properties.externalDocs.ref'(undefined) -> true;
'$.properties.externalDocs.ref'(Val) ->
    oas_3_0_ExternalDocumentation:is_valid(Val).

'$.properties.components.ref'(undefined) -> true;
'$.properties.components.ref'(Val) ->
    oas_3_0_Components:is_valid(Val).

'$.properties.openapi.pattern'(Val) ->
    case re:run(Val, <<"^3\\.0\\.\\d(-.+)?$">>) of
        {match, _Captured} -> true;
        _nomatch ->
            {false,
             {'$.properties.openapi.pattern',
              <<"Value does not match pattern.">>}}
    end.

'$.properties.security.items'(undefined) -> true;
'$.properties.security.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.security.items[*].ref'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.security",
                                                   Reason]))}}
    end.

'$.properties.security.items[*].ref'(Val) ->
    oas_3_0_SecurityRequirement:is_valid(Val).

'$.properties.servers.items'(undefined) -> true;
'$.properties.servers.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.servers.items[*].ref'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.servers",
                                                   Reason]))}}
    end.

'$.properties.servers.items[*].ref'(Val) ->
    oas_3_0_Server:is_valid(Val).

'$.properties.tags.unique_items'(Val) ->
    ArraySize = length(Val),
    case sets:size(sets:from_list(Val)) of
        ArraySize -> true;
        _ ->
            {false,
             {'$.properties.tags.unique_items',
              <<"Array has non unique items">>}}
    end.

'$.properties.tags.items'(undefined) -> true;
'$.properties.tags.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.properties.tags.items[*].ref'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.properties.tags",
                                                   Reason]))}}
    end.

'$.properties.tags.items[*].ref'(Val) ->
    oas_3_0_Tag:is_valid(Val).