%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_Link).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties'/1,
                                    [Val]},
                                   {fun '$.pattern_properties'/1, [Val]},
                                   {fun '$.properties'/1, [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties'(Val) ->
    case
        sets:to_list(sets:subtract(sets:from_list(maps:keys(Val)),
                                   sets:from_list(lists:append([<<"description">>,
                                                                <<"operationId">>,
                                                                <<"operationRef">>,
                                                                <<"parameters">>,
                                                                <<"requestBody">>,
                                                                <<"server">>],
                                                               lists:filter(fun
                                                                                (PropertyName) ->
                                                                                    lists:any(fun
                                                                                                  (Pattern) ->
                                                                                                      case
                                                                                                          re:run(PropertyName,
                                                                                                                 Pattern)
                                                                                                          of
                                                                                                          {match,
                                                                                                           _Captured} ->
                                                                                                              true;
                                                                                                          _nomatch ->
                                                                                                              false
                                                                                                      end
                                                                                              end,
                                                                                              [<<"^x-">>])
                                                                            end,
                                                                            maps:keys(Val))))))
        of
        [] -> true;
        UnsupportedKeys ->
            {false,
             {'$.additional_properties',
              erlang:list_to_binary(io_lib:format("Object has unsupported keys: ~ts",
                                                  [ndto_validation:format_properties(UnsupportedKeys)]))}}
    end.

'$.pattern_properties'(Val) ->
    case ndto_validation:'andalso'([{fun () ->
                                             case ndto_validation:find(fun
                                                                           ({PropertyName,
                                                                             PropertyValue}) ->
                                                                               Result =
                                                                                   '$.pattern_properties.^x-.any_of'(PropertyValue),
                                                                               case
                                                                                   Result
                                                                                   of
                                                                                   true ->
                                                                                       false;
                                                                                   {false,
                                                                                    {Prefix,
                                                                                     Reason}} ->
                                                                                       {true,
                                                                                        {{PropertyName,
                                                                                          PropertyValue},
                                                                                         {Prefix,
                                                                                          Reason}}}
                                                                               end
                                                                       end,
                                                                       lists:filter(fun
                                                                                        ({PropertyName,
                                                                                          _PropertyValue}) ->
                                                                                            case
                                                                                                re:run(PropertyName,
                                                                                                       <<"^x-">>)
                                                                                                of
                                                                                                {match,
                                                                                                 _Captured} ->
                                                                                                    true;
                                                                                                _nomatch ->
                                                                                                    false
                                                                                            end
                                                                                    end,
                                                                                    maps:to_list(Val)))
                                                 of
                                                 {false, none} -> true;
                                                 {true,
                                                  {{PropertyName,
                                                    _PropertyValue},
                                                   {Prefix, Reason}}} ->
                                                     {false,
                                                      {Prefix,
                                                       erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                                                           "~ts",
                                                                                           [PropertyName,
                                                                                            Reason]))}}
                                             end
                                     end,
                                     []}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.properties'(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.server.ref'/1,
                                    [maps:get(<<"server">>, Val, undefined)]},
                                   {fun '$.properties.requestBody.any_of'/1,
                                    [maps:get(<<"requestBody">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.parameters'/1,
                                    [maps:get(<<"parameters">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.operationRef'/1,
                                    [maps:get(<<"operationRef">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.operationId'/1,
                                    [maps:get(<<"operationId">>,
                                              Val,
                                              undefined)]},
                                   {fun '$.properties.description'/1,
                                    [maps:get(<<"description">>,
                                              Val,
                                              undefined)]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end.

'$.pattern_properties.^x-.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.pattern_properties.^x-.any_of[4]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.pattern_properties.^x-.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.pattern_properties.^x-.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.pattern_properties.^x-.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.pattern_properties.^x-.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.pattern_properties.^x-.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[2]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[2].type',
      <<"Value is not a string">>}}.

'$.pattern_properties.^x-.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[1].type',
      <<"Value is not an array">>}}.

'$.pattern_properties.^x-.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[0].type',
      <<"Value is not an object">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.pattern_properties.^x-.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.pattern_properties.^x-.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.pattern_properties.^x-.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.server.ref'(undefined) -> true;
'$.properties.server.ref'(Val) ->
    oas_3_0_Server:is_valid(Val).

'$.properties.requestBody.any_of'(undefined) -> true;
'$.properties.requestBody.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.requestBody.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.properties.requestBody.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.properties.requestBody.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.properties.requestBody.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.requestBody.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.requestBody.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.parameters'(undefined) -> true;
'$.properties.parameters'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.properties.parameters.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters'(_Val) ->
    {false,
     {'$.properties.parameters.type',
      <<"Value is not an object">>}}.

'$.properties.operationRef'(undefined) -> true;
'$.properties.operationRef'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.operationRef'(_Val) ->
    {false,
     {'$.properties.operationRef.type',
      <<"Value is not a string">>}}.

'$.properties.operationId'(undefined) -> true;
'$.properties.operationId'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.operationId'(_Val) ->
    {false,
     {'$.properties.operationId.type',
      <<"Value is not a string">>}}.

'$.properties.description'(undefined) -> true;
'$.properties.description'(Val) when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.description'(_Val) ->
    {false,
     {'$.properties.description.type',
      <<"Value is not a string">>}}.

'$.properties.parameters.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.properties.parameters.additional_properties.any_of'(maps:get(Property,
                                                                                                          Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.properties.parameters.additional_properties.any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.parameters.additional_properties.any_of[4]'/1,
                                   [Val]},
                                  {fun '$.properties.parameters.additional_properties.any_of[3].any_of'/1,
                                   [Val]},
                                  {fun '$.properties.parameters.additional_properties.any_of[2]'/1,
                                   [Val]},
                                  {fun '$.properties.parameters.additional_properties.any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.parameters.additional_properties.any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.parameters.additional_properties.any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.parameters.additional_properties.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.parameters.additional_properties.any_of[4]'(_Val) ->
    {false,
     {'$.properties.parameters.additional_properties.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.properties.parameters.additional_properties.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.parameters.additional_properties.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.parameters.additional_properties.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.parameters.additional_properties.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.parameters.additional_properties.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters.additional_properties.any_of[2]'(_Val) ->
    {false,
     {'$.properties.parameters.additional_properties.any_of[2].type',
      <<"Value is not a string">>}}.

'$.properties.parameters.additional_properties.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters.additional_properties.any_of[1]'(_Val) ->
    {false,
     {'$.properties.parameters.additional_properties.any_of[1].type',
      <<"Value is not an array">>}}.

'$.properties.parameters.additional_properties.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters.additional_properties.any_of[0]'(_Val) ->
    {false,
     {'$.properties.parameters.additional_properties.any_of[0].type',
      <<"Value is not an object">>}}.

'$.properties.parameters.additional_properties.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters.additional_properties.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.properties.parameters.additional_properties.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.parameters.additional_properties.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.parameters.additional_properties.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.properties.parameters.additional_properties.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.

'$.properties.requestBody.any_of[4]'(Val)
    when is_boolean(Val) ->
    true;
'$.properties.requestBody.any_of[4]'(_Val) ->
    {false,
     {'$.properties.requestBody.any_of[4].type',
      <<"Value is not a boolean">>}}.

'$.properties.requestBody.any_of[3].any_of'(Val) ->
    case
        ndto_validation:'orelse'([{fun '$.properties.requestBody.any_of[3].any_of[1]'/1,
                                   [Val]},
                                  {fun '$.properties.requestBody.any_of[3].any_of[0]'/1,
                                   [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.properties.requestBody.any_of[3].any_of',
              <<"Value is not matching at least one condition. "
                "None matched.">>}}
    end.

'$.properties.requestBody.any_of[2]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.requestBody.any_of[2]'(_Val) ->
    {false,
     {'$.properties.requestBody.any_of[2].type',
      <<"Value is not a string">>}}.

'$.properties.requestBody.any_of[1]'(Val)
    when is_list(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.requestBody.any_of[1]'(_Val) ->
    {false,
     {'$.properties.requestBody.any_of[1].type',
      <<"Value is not an array">>}}.

'$.properties.requestBody.any_of[0]'(Val)
    when is_map(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.requestBody.any_of[0]'(_Val) ->
    {false,
     {'$.properties.requestBody.any_of[0].type',
      <<"Value is not an object">>}}.

'$.properties.requestBody.any_of[3].any_of[1]'(Val)
    when is_float(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.requestBody.any_of[3].any_of[1]'(_Val) ->
    {false,
     {'$.properties.requestBody.any_of[3].any_of[1].type',
      <<"Value is not a float">>}}.

'$.properties.requestBody.any_of[3].any_of[0]'(Val)
    when is_integer(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.properties.requestBody.any_of[3].any_of[0]'(_Val) ->
    {false,
     {'$.properties.requestBody.any_of[3].any_of[0].type',
      <<"Value is not an integer">>}}.