%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_SecurityRequirement).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$'(Val) when is_map(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties.*'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$'(_Val) ->
    {false, {'$.type', <<"Value is not an object">>}}.

'$.additional_properties.*'(Val) ->
    case ndto_validation:find(fun (Property) ->
                                      Result =
                                          '$.additional_properties'(maps:get(Property,
                                                                             Val)),
                                      case Result of
                                          true -> false;
                                          {false, {Prefix, Reason}} ->
                                              {true,
                                               {Property, {Prefix, Reason}}}
                                      end
                              end,
                              lists:subtract(maps:keys(Val),
                                             lists:append([],
                                                          lists:filter(fun
                                                                           (PropertyName) ->
                                                                               lists:any(fun
                                                                                             (Pattern) ->
                                                                                                 case
                                                                                                     re:run(PropertyName,
                                                                                                            Pattern)
                                                                                                     of
                                                                                                     {match,
                                                                                                      _Captured} ->
                                                                                                         true;
                                                                                                     _nomatch ->
                                                                                                         false
                                                                                                 end
                                                                                         end,
                                                                                         [])
                                                                       end,
                                                                       maps:keys(Val)))))
        of
        {false, none} -> true;
        {true, {PropertyName, {Prefix, Reason}}} ->
            {false,
             {Prefix,
              erlang:list_to_binary(io_lib:format("Property \"~ts\" failed validation: "
                                                  "~ts",
                                                  [PropertyName, Reason]))}}
    end.

'$.additional_properties'(Val) when is_list(Val) ->
    case
        ndto_validation:'andalso'([{fun '$.additional_properties.items'/1,
                                    [Val]}])
        of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.additional_properties'(_Val) ->
    {false,
     {'$.additional_properties.type',
      <<"Value is not an array">>}}.

'$.additional_properties.items'(Val) ->
    case ndto_validation:mfoldl(fun (Item, Acc) ->
                                        {'$.additional_properties.items[*]'(Item),
                                         Acc + 1}
                                end,
                                0,
                                Val)
        of
        {true, _Acc} -> true;
        {false, Acc, {Function, Reason}} ->
            {false,
             {Function,
              erlang:list_to_binary(io_lib:format("Item ~p in ~ts is invalid. ~s",
                                                  [Acc,
                                                   "$.additional_properties",
                                                   Reason]))}}
    end.

'$.additional_properties.items[*]'(Val)
    when is_binary(Val) ->
    case ndto_validation:'andalso'([]) of
        true -> true;
        {false, {Reason, _N}} -> {false, Reason}
    end;
'$.additional_properties.items[*]'(_Val) ->
    {false,
     {'$.additional_properties.items[*].type',
      <<"Value is not a string">>}}.