%%% Copyright 2025 Nomasystems, S.L. http://www.nomasystems.com
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%%  Unless required by applicable law or agreed to in writing, software
%%  distributed under the License is distributed on an "AS IS" BASIS,
%%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License
%%% NOTE: Module generated by ndto, do not modify this file.
-module(oas_3_0_SecurityScheme).

%%% EXTERNAL EXPORTS
-export([is_valid/1]).

%%%-----------------------------------------------------------------------------
%%% EXTERNAL EXPORTS
%%%-----------------------------------------------------------------------------
is_valid(Val) -> '$.one_of'(Val).

%%%-----------------------------------------------------------------------------
%%% INTERNAL FUNCTIONS
%%%-----------------------------------------------------------------------------
'$.one_of'(Val) ->
    case ndto_validation:'xor'([{fun '$.one_of[3].ref'/1,
                                 [Val]},
                                {fun '$.one_of[2].ref'/1, [Val]},
                                {fun '$.one_of[1].ref'/1, [Val]},
                                {fun '$.one_of[0].ref'/1, [Val]}])
        of
        true -> true;
        {false, none_matched} ->
            {false,
             {'$.one_of',
              <<"Value is not matching exactly one condition. "
                "None matched.">>}};
        {false, {many_matched, {First, Second}}} ->
            {false,
             {'$.one_of',
              unicode:characters_to_binary(io_lib:format("Value is not matching exactly one condition. "
                                                         "More than one (conditions ~p and ~p) "
                                                         "matched.",
                                                         [Second, First]))}}
    end.

'$.one_of[3].ref'(Val) ->
    oas_3_0_APIKeySecurityScheme:is_valid(Val).

'$.one_of[2].ref'(Val) ->
    oas_3_0_HTTPSecurityScheme:is_valid(Val).

'$.one_of[1].ref'(Val) ->
    oas_3_0_OAuth2SecurityScheme:is_valid(Val).

'$.one_of[0].ref'(Val) ->
    oas_3_0_OpenIdConnectSecurityScheme:is_valid(Val).