%% Generated by the Erlang ASN.1 PER (aligned) compiler. Version: 5.3.4.1
%% Purpose: Encoding and decoding of the types in S1AP-CommonDataTypes.

-module('S1AP-CommonDataTypes').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-asn1_info([{vsn,'5.3.4.1'},
            {module,'S1AP-CommonDataTypes'},
            {options,[{i,"/obs/_temp/binpkgs/osmo-s1gw/asngen"},
 noobj,per,
 {outdir,"/obs/_temp/binpkgs/osmo-s1gw/asngen"},
 {i,"."},
 {i,"/obs/_temp/binpkgs/osmo-s1gw/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_Criticality/1,
enc_Presence/1,
'enc_PrivateIE-ID'/1,
enc_ProcedureCode/1,
enc_ProtocolExtensionID/1,
'enc_ProtocolIE-ID'/1,
enc_TriggeringMessage/1
]).

-export([
dec_Criticality/1,
dec_Presence/1,
'dec_PrivateIE-ID'/1,
dec_ProcedureCode/1,
dec_ProtocolExtensionID/1,
'dec_ProtocolIE-ID'/1,
dec_TriggeringMessage/1
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> per.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try complete(encode_disp(Type, Data)) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   {Result,_Rest} = decode_disp(Type, Data),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('Criticality', Data) -> enc_Criticality(Data);
encode_disp('Presence', Data) -> enc_Presence(Data);
encode_disp('PrivateIE-ID', Data) -> 'enc_PrivateIE-ID'(Data);
encode_disp('ProcedureCode', Data) -> enc_ProcedureCode(Data);
encode_disp('ProtocolExtensionID', Data) -> enc_ProtocolExtensionID(Data);
encode_disp('ProtocolIE-ID', Data) -> 'enc_ProtocolIE-ID'(Data);
encode_disp('TriggeringMessage', Data) -> enc_TriggeringMessage(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('Criticality', Data) -> dec_Criticality(Data);
decode_disp('Presence', Data) -> dec_Presence(Data);
decode_disp('PrivateIE-ID', Data) -> 'dec_PrivateIE-ID'(Data);
decode_disp('ProcedureCode', Data) -> dec_ProcedureCode(Data);
decode_disp('ProtocolExtensionID', Data) -> dec_ProtocolExtensionID(Data);
decode_disp('ProtocolIE-ID', Data) -> 'dec_ProtocolIE-ID'(Data);
decode_disp('TriggeringMessage', Data) -> dec_TriggeringMessage(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.
enc_Criticality(Val) ->
if Val =:= reject ->
<<0:2>>;
Val =:= ignore ->
<<1:2>>;
Val =:= notify ->
<<2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_Criticality(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Int2 = case V1@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V1@V0}}})
end,
{V1@Int2,V1@Buf1}
end.

enc_Presence(Val) ->
if Val =:= optional ->
<<0:2>>;
Val =:= conditional ->
<<1:2>>;
Val =:= mandatory ->
<<2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_Presence(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Int2 = case V1@V0 of
0 -> optional;
1 -> conditional;
2 -> mandatory;
_ -> exit({error,{asn1,{decode_enumerated,V1@V0}}})
end,
{V1@Int2,V1@Buf1}
end.

'enc_PrivateIE-ID'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= local ->
if ChoiceVal bsr 16 =:= 0 ->
[<<0:1>>,
align|<<ChoiceVal:16>>];
true ->
exit({error,{asn1,{illegal_integer,ChoiceVal}}})
end;
ChoiceTag =:= global ->
begin
Enc4@bin = encode_oid(ChoiceVal),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len < 128 ->
[<<1:1>>,
align,
Enc4@len|Enc4@bin];
Enc4@len < 16384 ->
[<<1:1>>,
align,
<<2:2,Enc4@len:14>>|Enc4@bin];
true ->
[<<1:1>>,
align|encode_fragmented(Enc4@bin, 8)]
end
end
end.


'dec_PrivateIE-ID'(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:2/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end
end,
{{local,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
V3@Pad3 = bit_size(Bytes1) band 7,
{V3@V0,V3@Buf1} = case Bytes1 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@Buf6/bitstring>> ->
{V3@V5,V3@Buf6};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
V3@Mul8 = V3@V6 * 16384,
{V3@Mul8,V3@Buf7}
end,
<<V3@V9:V3@V0/binary-unit:8,V3@Buf10/bitstring>> = V3@Buf1,
V3@Conv11 = binary_to_list(V3@V9),
{V3@V12,V3@Buf13}  = {decode_oid(V3@Conv11),V3@Buf10},
{V3@V12,V3@Buf13}
end
end,
{{global,Val},NewBytes}
end.
enc_ProcedureCode(Val) ->
if Val bsr 8 =:= 0 ->
[align,
Val];
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_ProcedureCode(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

enc_ProtocolExtensionID(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


dec_ProtocolExtensionID(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

'enc_ProtocolIE-ID'(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_integer,Val}}})
end.


'dec_ProtocolIE-ID'(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

enc_TriggeringMessage(Val) ->
if Val =:= 'initiating-message' ->
<<0:2>>;
Val =:= 'successful-outcome' ->
<<1:2>>;
Val =:= 'unsuccessfull-outcome' ->
<<2:2>>;
true ->
exit({error,{asn1,{illegal_enumerated,Val}}})
end.


dec_TriggeringMessage(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Int2 = case V1@V0 of
0 -> 'initiating-message';
1 -> 'successful-outcome';
2 -> 'unsuccessfull-outcome';
_ -> exit({error,{asn1,{decode_enumerated,V1@V0}}})
end,
{V1@Int2,V1@Buf1}
end.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    _ = complete(element(1, Arg)),
    ok.

complete(L0) ->
    L = complete(L0, []),
    case list_to_bitstring(L) of
        <<>> ->
            <<0>>;
        Bin ->
            Bin
    end.

complete([], Bits, []) ->
    case Bits band 7 of
        0 ->
            [];
        N ->
            [<<0:(8 - N)>>]
    end;
complete([], Bits, [H | More]) ->
    complete(H, Bits, More);
complete([align | T], Bits, More) ->
    case Bits band 7 of
        0 ->
            complete(T, More);
        1 ->
            [<<0:7>> | complete(T, More)];
        2 ->
            [<<0:6>> | complete(T, More)];
        3 ->
            [<<0:5>> | complete(T, More)];
        4 ->
            [<<0:4>> | complete(T, More)];
        5 ->
            [<<0:3>> | complete(T, More)];
        6 ->
            [<<0:2>> | complete(T, More)];
        7 ->
            [<<0:1>> | complete(T, More)]
    end;
complete([[] | T], Bits, More) ->
    complete(T, Bits, More);
complete([[_ | _] = H], Bits, More) ->
    complete(H, Bits, More);
complete([[_ | _] = H | T], Bits, More) ->
    complete(H, Bits, [T | More]);
complete([H | T], Bits, More) when is_integer(H); is_binary(H) ->
    [H | complete(T, Bits, More)];
complete([H | T], Bits, More) ->
    [H | complete(T, Bits + bit_size(H), More)];
complete(Bin, Bits, More) when is_binary(Bin) ->
    [Bin | complete([], Bits, More)];
complete(Bin, Bits, More) ->
    [Bin | complete([], Bits + bit_size(Bin), More)].

complete([], []) ->
    [];
complete([], [H | More]) ->
    complete(H, More);
complete([align | T], More) ->
    complete(T, More);
complete([[] | T], More) ->
    complete(T, More);
complete([[_ | _] = H], More) ->
    complete(H, More);
complete([[_ | _] = H | T], More) ->
    complete(H, [T | More]);
complete([H | T], More) when is_integer(H); is_binary(H) ->
    [H | complete(T, More)];
complete([H | T], More) ->
    [H | complete(T, bit_size(H), More)];
complete(Bin, More) when is_binary(Bin) ->
    [Bin | complete([], More)];
complete(Bin, More) ->
    [Bin | complete([], bit_size(Bin), More)].

dec_subidentifiers([H | T], Av, Al) when H >= 128 ->
    dec_subidentifiers(T, Av bsl 7 bor H band 127, Al);
dec_subidentifiers([H | T], Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 bor H | Al]);
dec_subidentifiers([], _Av, Al) ->
    lists:reverse(Al).

decode_oid(Octets) ->
    [First | Rest] = dec_subidentifiers(Octets, 0, []),
    Idlist =
        if
            First < 40 ->
                [0, First | Rest];
            First < 80 ->
                [1, First - 40 | Rest];
            true ->
                [2, First - 80 | Rest]
        end,
    list_to_tuple(Idlist).

e_o_e(Num) when Num < 128 ->
    Num bor 128;
e_o_e(Num) ->
    [e_o_e(Num bsr 7), Num band 127 bor 128].

e_object_element(Num) when Num < 128 ->
    [Num];
e_object_element(Num) ->
    [e_o_e(Num bsr 7), Num band 127].

e_object_elements([], Acc) ->
    lists:reverse(Acc);
e_object_elements([H | T], Acc) ->
    e_object_elements(T, [e_object_element(H) | Acc]).

e_object_identifier([E1, E2 | Tail])
    when E1 >= 0, E1 < 2, E2 < 40; E1 =:= 2 ->
    Head = 40 * E1 + E2,
    e_object_elements([Head | Tail], []);
e_object_identifier([_, _ | _Tail] = Oid) ->
    exit({error, {asn1, {illegal_value, Oid}}}).

encode_fragmented(Bin, Unit) ->
    encode_fragmented_1(Bin, Unit, 4).

encode_fragmented_1(Bin, Unit, N) ->
    SegSz = Unit * N * 16384,
    case Bin of
        <<B:SegSz/bitstring,T/bitstring>> ->
            [<<3:2,N:6>>, B | encode_fragmented_1(T, Unit, N)];
        _ when N > 1 ->
            encode_fragmented_1(Bin, Unit, N - 1);
        _ ->
            case bit_size(Bin) div Unit of
                Len when Len < 128 ->
                    [Len, Bin];
                Len when Len < 16384 ->
                    [<<2:2,Len:14>>, Bin]
            end
    end.

encode_oid(Val) when is_tuple(Val) ->
    encode_oid(tuple_to_list(Val));
encode_oid(Val) ->
    iolist_to_binary(e_object_identifier(Val)).
