%% Generated by the Erlang ASN.1 PER (aligned) compiler. Version: 5.3.4.1
%% Purpose: Encoding and decoding of the types in S1AP-PDU-Descriptions.

-module('S1AP-PDU-Descriptions').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("S1AP-PDU-Descriptions.hrl").
-asn1_info([{vsn,'5.3.4.1'},
            {module,'S1AP-PDU-Descriptions'},
            {options,[{i,"/obs/_temp/binpkgs/osmo-s1gw/asngen"},
 noobj,per,
 {outdir,"/obs/_temp/binpkgs/osmo-s1gw/asngen"},
 {i,"."},
 {i,"/obs/_temp/binpkgs/osmo-s1gw/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
'enc_S1AP-PDU'/1,
enc_InitiatingMessage/1,
enc_SuccessfulOutcome/1,
enc_UnsuccessfulOutcome/1
]).

-export([
'dec_S1AP-PDU'/1,
dec_InitiatingMessage/1,
dec_SuccessfulOutcome/1,
dec_UnsuccessfulOutcome/1
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> per.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try complete(encode_disp(Type, Data)) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   {Result,_Rest} = decode_disp(Type, Data),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('S1AP-PDU', Data) -> 'enc_S1AP-PDU'(Data);
encode_disp('InitiatingMessage', Data) -> enc_InitiatingMessage(Data);
encode_disp('SuccessfulOutcome', Data) -> enc_SuccessfulOutcome(Data);
encode_disp('UnsuccessfulOutcome', Data) -> enc_UnsuccessfulOutcome(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('S1AP-PDU', Data) -> 'dec_S1AP-PDU'(Data);
decode_disp('InitiatingMessage', Data) -> dec_InitiatingMessage(Data);
decode_disp('SuccessfulOutcome', Data) -> dec_SuccessfulOutcome(Data);
decode_disp('UnsuccessfulOutcome', Data) -> dec_UnsuccessfulOutcome(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.
'enc_S1AP-PDU'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= initiatingMessage ->
[<<0:1,0:2>>|enc_InitiatingMessage(ChoiceVal)];
ChoiceTag =:= successfulOutcome ->
[<<0:1,1:2>>|enc_SuccessfulOutcome(ChoiceVal)];
ChoiceTag =:= unsuccessfulOutcome ->
[<<0:1,2:2>>|enc_UnsuccessfulOutcome(ChoiceVal)]
end.


'dec_S1AP-PDU'(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_InitiatingMessage(Bytes2)
end,
{{initiatingMessage,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_SuccessfulOutcome(Bytes2)
end,
{{successfulOutcome,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_UnsuccessfulOutcome(Bytes2)
end,
{{unsuccessfulOutcome,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10};
<<_:V1@Pad6,1:1,1:1,V1@V9:6,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
V1@Mul11 = V1@V9 * 16384,
{V1@Mul11,V1@Buf10}
end,
<<V1@V12:V1@V3/unit:8,V1@Buf13/bitstring>> = V1@Buf4,
{V1@V12,V1@Buf13}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
enc_InitiatingMessage(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute procedureCode(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 8 =:= 0 ->
Enc2@element;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type InitiatingMessage
Enc6@element = element(4, Val),
Enc7@output = enc_os_InitiatingMessage1(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_InitiatingMessage(Bytes) ->

%% attribute procedureCode(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type InitiatingMessage
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_InitiatingMessage2(Tmpterm1, Term1),
Res1 = {'InitiatingMessage',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_SuccessfulOutcome(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute procedureCode(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 8 =:= 0 ->
Enc2@element;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type SuccessfulOutcome
Enc6@element = element(4, Val),
Enc7@output = enc_os_SuccessfulOutcome3(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_SuccessfulOutcome(Bytes) ->

%% attribute procedureCode(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type SuccessfulOutcome
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_SuccessfulOutcome4(Tmpterm1, Term1),
Res1 = {'SuccessfulOutcome',Term1,Term2,Term3},
{Res1,Bytes3}.

enc_UnsuccessfulOutcome(Val) ->
Enc1@element = element(2, Val),
[align,
begin
%% attribute procedureCode(1) with type INTEGER
Enc2@element = Enc1@element,
if Enc2@element bsr 8 =:= 0 ->
Enc2@element;
true ->
exit({error,{asn1,{illegal_integer,Enc2@element}}})
end
end,
begin
%% attribute criticality(2) with type ENUMERATED
Enc4@element = element(3, Val),
if Enc4@element =:= reject ->
<<0:2,0:6>>;
Enc4@element =:= ignore ->
<<1:2,0:6>>;
Enc4@element =:= notify ->
<<2:2,0:6>>;
true ->
exit({error,{asn1,{illegal_enumerated,Enc4@element}}})
end
end|begin
%% attribute value(3) with type UnsuccessfulOutcome
Enc6@element = element(4, Val),
Enc7@output = enc_os_UnsuccessfulOutcome5(Enc6@element, Enc1@element),
Enc7@bin = complete(Enc7@output),
Enc7@len = byte_size(Enc7@bin),
if Enc7@len < 128 ->
[Enc7@len|Enc7@bin];
Enc7@len < 16384 ->
[<<2:2,Enc7@len:14>>|Enc7@bin];
true ->
encode_fragmented(Enc7@bin, 8)
end
end].


dec_UnsuccessfulOutcome(Bytes) ->

%% attribute procedureCode(1) with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:1/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute criticality(2) with type ENUMERATED
{Term2,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Int2 = case V2@V0 of
0 -> reject;
1 -> ignore;
2 -> notify;
_ -> exit({error,{asn1,{decode_enumerated,V2@V0}}})
end,
{V2@Int2,V2@Buf1}
end,

%% attribute value(3) with type UnsuccessfulOutcome
{Tmpterm1, Bytes3} = begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
{V3@V0,V3@Buf1}
end,
Term3 = dec_os_UnsuccessfulOutcome6(Tmpterm1, Term1),
Res1 = {'UnsuccessfulOutcome',Term1,Term2,Term3},
{Res1,Bytes3}.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    _ = complete(element(1, Arg)),
    ok.

dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverRequired(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 1 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 2 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverNotify(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 3 ->
{Term,_} = 'S1AP-PDU-Contents':dec_PathSwitchRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 4 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverCancel(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 5 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABSetupRequest'(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 6 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABModifyRequest'(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 7 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABReleaseCommand'(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 8 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABReleaseIndication'(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 9 ->
{Term,_} = 'S1AP-PDU-Contents':dec_InitialContextSetupRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 10 ->
{Term,_} = 'S1AP-PDU-Contents':dec_Paging(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 11 ->
{Term,_} = 'S1AP-PDU-Contents':dec_DownlinkNASTransport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 12 ->
{Term,_} = 'S1AP-PDU-Contents':dec_InitialUEMessage(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 13 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UplinkNASTransport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 14 ->
{Term,_} = 'S1AP-PDU-Contents':dec_Reset(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 15 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ErrorIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 16 ->
{Term,_} = 'S1AP-PDU-Contents':dec_NASNonDeliveryIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 17 ->
{Term,_} = 'S1AP-PDU-Contents':dec_S1SetupRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 18 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextReleaseRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 19 ->
{Term,_} = 'S1AP-PDU-Contents':dec_DownlinkS1cdma2000tunnelling(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 20 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UplinkS1cdma2000tunnelling(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 21 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextModificationRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 22 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UECapabilityInfoIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 23 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextReleaseCommand(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 24 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBStatusTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 25 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEStatusTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 26 ->
{Term,_} = 'S1AP-PDU-Contents':dec_DeactivateTrace(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 27 ->
{Term,_} = 'S1AP-PDU-Contents':dec_TraceStart(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 28 ->
{Term,_} = 'S1AP-PDU-Contents':dec_TraceFailureIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 29 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBConfigurationUpdate(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 30 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEConfigurationUpdate(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 31 ->
{Term,_} = 'S1AP-PDU-Contents':dec_LocationReportingControl(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 32 ->
{Term,_} = 'S1AP-PDU-Contents':dec_LocationReportingFailureIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 33 ->
{Term,_} = 'S1AP-PDU-Contents':dec_LocationReport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 34 ->
{Term,_} = 'S1AP-PDU-Contents':dec_OverloadStart(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 35 ->
{Term,_} = 'S1AP-PDU-Contents':dec_OverloadStop(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 36 ->
{Term,_} = 'S1AP-PDU-Contents':dec_WriteReplaceWarningRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 37 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBDirectInformationTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 38 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEDirectInformationTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 39 ->
{Term,_} = 'S1AP-PDU-Contents':dec_PrivateMessage(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 40 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBConfigurationTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 41 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEConfigurationTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 42 ->
{Term,_} = 'S1AP-PDU-Contents':dec_CellTrafficTrace(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 43 ->
{Term,_} = 'S1AP-PDU-Contents':dec_KillRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 44 ->
{Term,_} = 'S1AP-PDU-Contents':dec_DownlinkUEAssociatedLPPaTransport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 45 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UplinkUEAssociatedLPPaTransport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 46 ->
{Term,_} = 'S1AP-PDU-Contents':dec_DownlinkNonUEAssociatedLPPaTransport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 47 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UplinkNonUEAssociatedLPPaTransport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 48 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UERadioCapabilityMatchRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 49 ->
{Term,_} = 'S1AP-PDU-Contents':dec_PWSRestartIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 50 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABModificationIndication'(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 51 ->
{Term,_} = 'S1AP-PDU-Contents':dec_PWSFailureIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 52 ->
{Term,_} = 'S1AP-PDU-Contents':dec_RerouteNASRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 53 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextModificationIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 54 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ConnectionEstablishmentIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 55 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextSuspendRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 56 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextResumeRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 57 ->
{Term,_} = 'S1AP-PDU-Contents':dec_NASDeliveryIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 58 ->
{Term,_} = 'S1AP-PDU-Contents':dec_RetrieveUEInformation(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 59 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEInformationTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 60 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBCPRelocationIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 61 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMECPRelocationIndication(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 62 ->
{Term,_} = 'S1AP-PDU-Contents':dec_SecondaryRATDataUsageReport(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 63 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UERadioCapabilityIDMappingRequest(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 64 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverSuccess(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 65 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBEarlyStatusTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) when Id =:= 66 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEEarlyStatusTransfer(Bytes),
Term;
dec_os_InitiatingMessage2(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverCommand(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 1 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverRequestAcknowledge(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 3 ->
{Term,_} = 'S1AP-PDU-Contents':dec_PathSwitchRequestAcknowledge(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 4 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverCancelAcknowledge(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 5 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABSetupResponse'(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 6 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABModifyResponse'(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 7 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABReleaseResponse'(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 9 ->
{Term,_} = 'S1AP-PDU-Contents':dec_InitialContextSetupResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 14 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ResetAcknowledge(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 17 ->
{Term,_} = 'S1AP-PDU-Contents':dec_S1SetupResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 21 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextModificationResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 23 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextReleaseComplete(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 29 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBConfigurationUpdateAcknowledge(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 30 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEConfigurationUpdateAcknowledge(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 36 ->
{Term,_} = 'S1AP-PDU-Contents':dec_WriteReplaceWarningResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 43 ->
{Term,_} = 'S1AP-PDU-Contents':dec_KillResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 48 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UERadioCapabilityMatchResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 50 ->
{Term,_} = 'S1AP-PDU-Contents':'dec_E-RABModificationConfirm'(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 53 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextModificationConfirm(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 55 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextSuspendResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 56 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextResumeResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) when Id =:= 63 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UERadioCapabilityIDMappingResponse(Bytes),
Term;
dec_os_SuccessfulOutcome4(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 0 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverPreparationFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 1 ->
{Term,_} = 'S1AP-PDU-Contents':dec_HandoverFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 3 ->
{Term,_} = 'S1AP-PDU-Contents':dec_PathSwitchRequestFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 9 ->
{Term,_} = 'S1AP-PDU-Contents':dec_InitialContextSetupFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 17 ->
{Term,_} = 'S1AP-PDU-Contents':dec_S1SetupFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 21 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextModificationFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 29 ->
{Term,_} = 'S1AP-PDU-Contents':dec_ENBConfigurationUpdateFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 30 ->
{Term,_} = 'S1AP-PDU-Contents':dec_MMEConfigurationUpdateFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) when Id =:= 56 ->
{Term,_} = 'S1AP-PDU-Contents':dec_UEContextResumeFailure(Bytes),
Term;
dec_os_UnsuccessfulOutcome6(Bytes, Id) ->
{asn1_OPENTYPE,Bytes}.


enc_os_InitiatingMessage1(Val, Id) ->
if Id =:= 0 ->
'S1AP-PDU-Contents':enc_HandoverRequired(Val);
Id =:= 1 ->
'S1AP-PDU-Contents':enc_HandoverRequest(Val);
Id =:= 2 ->
'S1AP-PDU-Contents':enc_HandoverNotify(Val);
Id =:= 3 ->
'S1AP-PDU-Contents':enc_PathSwitchRequest(Val);
Id =:= 4 ->
'S1AP-PDU-Contents':enc_HandoverCancel(Val);
Id =:= 5 ->
'S1AP-PDU-Contents':'enc_E-RABSetupRequest'(Val);
Id =:= 6 ->
'S1AP-PDU-Contents':'enc_E-RABModifyRequest'(Val);
Id =:= 7 ->
'S1AP-PDU-Contents':'enc_E-RABReleaseCommand'(Val);
Id =:= 8 ->
'S1AP-PDU-Contents':'enc_E-RABReleaseIndication'(Val);
Id =:= 9 ->
'S1AP-PDU-Contents':enc_InitialContextSetupRequest(Val);
Id =:= 10 ->
'S1AP-PDU-Contents':enc_Paging(Val);
Id =:= 11 ->
'S1AP-PDU-Contents':enc_DownlinkNASTransport(Val);
Id =:= 12 ->
'S1AP-PDU-Contents':enc_InitialUEMessage(Val);
Id =:= 13 ->
'S1AP-PDU-Contents':enc_UplinkNASTransport(Val);
Id =:= 14 ->
'S1AP-PDU-Contents':enc_Reset(Val);
Id =:= 15 ->
'S1AP-PDU-Contents':enc_ErrorIndication(Val);
Id =:= 16 ->
'S1AP-PDU-Contents':enc_NASNonDeliveryIndication(Val);
Id =:= 17 ->
'S1AP-PDU-Contents':enc_S1SetupRequest(Val);
Id =:= 18 ->
'S1AP-PDU-Contents':enc_UEContextReleaseRequest(Val);
Id =:= 19 ->
'S1AP-PDU-Contents':enc_DownlinkS1cdma2000tunnelling(Val);
Id =:= 20 ->
'S1AP-PDU-Contents':enc_UplinkS1cdma2000tunnelling(Val);
Id =:= 21 ->
'S1AP-PDU-Contents':enc_UEContextModificationRequest(Val);
Id =:= 22 ->
'S1AP-PDU-Contents':enc_UECapabilityInfoIndication(Val);
Id =:= 23 ->
'S1AP-PDU-Contents':enc_UEContextReleaseCommand(Val);
Id =:= 24 ->
'S1AP-PDU-Contents':enc_ENBStatusTransfer(Val);
Id =:= 25 ->
'S1AP-PDU-Contents':enc_MMEStatusTransfer(Val);
Id =:= 26 ->
'S1AP-PDU-Contents':enc_DeactivateTrace(Val);
Id =:= 27 ->
'S1AP-PDU-Contents':enc_TraceStart(Val);
Id =:= 28 ->
'S1AP-PDU-Contents':enc_TraceFailureIndication(Val);
Id =:= 29 ->
'S1AP-PDU-Contents':enc_ENBConfigurationUpdate(Val);
Id =:= 30 ->
'S1AP-PDU-Contents':enc_MMEConfigurationUpdate(Val);
Id =:= 31 ->
'S1AP-PDU-Contents':enc_LocationReportingControl(Val);
Id =:= 32 ->
'S1AP-PDU-Contents':enc_LocationReportingFailureIndication(Val);
Id =:= 33 ->
'S1AP-PDU-Contents':enc_LocationReport(Val);
Id =:= 34 ->
'S1AP-PDU-Contents':enc_OverloadStart(Val);
Id =:= 35 ->
'S1AP-PDU-Contents':enc_OverloadStop(Val);
Id =:= 36 ->
'S1AP-PDU-Contents':enc_WriteReplaceWarningRequest(Val);
Id =:= 37 ->
'S1AP-PDU-Contents':enc_ENBDirectInformationTransfer(Val);
Id =:= 38 ->
'S1AP-PDU-Contents':enc_MMEDirectInformationTransfer(Val);
Id =:= 39 ->
'S1AP-PDU-Contents':enc_PrivateMessage(Val);
Id =:= 40 ->
'S1AP-PDU-Contents':enc_ENBConfigurationTransfer(Val);
Id =:= 41 ->
'S1AP-PDU-Contents':enc_MMEConfigurationTransfer(Val);
Id =:= 42 ->
'S1AP-PDU-Contents':enc_CellTrafficTrace(Val);
Id =:= 43 ->
'S1AP-PDU-Contents':enc_KillRequest(Val);
Id =:= 44 ->
'S1AP-PDU-Contents':enc_DownlinkUEAssociatedLPPaTransport(Val);
Id =:= 45 ->
'S1AP-PDU-Contents':enc_UplinkUEAssociatedLPPaTransport(Val);
Id =:= 46 ->
'S1AP-PDU-Contents':enc_DownlinkNonUEAssociatedLPPaTransport(Val);
Id =:= 47 ->
'S1AP-PDU-Contents':enc_UplinkNonUEAssociatedLPPaTransport(Val);
Id =:= 48 ->
'S1AP-PDU-Contents':enc_UERadioCapabilityMatchRequest(Val);
Id =:= 49 ->
'S1AP-PDU-Contents':enc_PWSRestartIndication(Val);
Id =:= 50 ->
'S1AP-PDU-Contents':'enc_E-RABModificationIndication'(Val);
Id =:= 51 ->
'S1AP-PDU-Contents':enc_PWSFailureIndication(Val);
Id =:= 52 ->
'S1AP-PDU-Contents':enc_RerouteNASRequest(Val);
Id =:= 53 ->
'S1AP-PDU-Contents':enc_UEContextModificationIndication(Val);
Id =:= 54 ->
'S1AP-PDU-Contents':enc_ConnectionEstablishmentIndication(Val);
Id =:= 55 ->
'S1AP-PDU-Contents':enc_UEContextSuspendRequest(Val);
Id =:= 56 ->
'S1AP-PDU-Contents':enc_UEContextResumeRequest(Val);
Id =:= 57 ->
'S1AP-PDU-Contents':enc_NASDeliveryIndication(Val);
Id =:= 58 ->
'S1AP-PDU-Contents':enc_RetrieveUEInformation(Val);
Id =:= 59 ->
'S1AP-PDU-Contents':enc_UEInformationTransfer(Val);
Id =:= 60 ->
'S1AP-PDU-Contents':enc_ENBCPRelocationIndication(Val);
Id =:= 61 ->
'S1AP-PDU-Contents':enc_MMECPRelocationIndication(Val);
Id =:= 62 ->
'S1AP-PDU-Contents':enc_SecondaryRATDataUsageReport(Val);
Id =:= 63 ->
'S1AP-PDU-Contents':enc_UERadioCapabilityIDMappingRequest(Val);
Id =:= 64 ->
'S1AP-PDU-Contents':enc_HandoverSuccess(Val);
Id =:= 65 ->
'S1AP-PDU-Contents':enc_ENBEarlyStatusTransfer(Val);
Id =:= 66 ->
'S1AP-PDU-Contents':enc_MMEEarlyStatusTransfer(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_SuccessfulOutcome3(Val, Id) ->
if Id =:= 0 ->
'S1AP-PDU-Contents':enc_HandoverCommand(Val);
Id =:= 1 ->
'S1AP-PDU-Contents':enc_HandoverRequestAcknowledge(Val);
Id =:= 3 ->
'S1AP-PDU-Contents':enc_PathSwitchRequestAcknowledge(Val);
Id =:= 4 ->
'S1AP-PDU-Contents':enc_HandoverCancelAcknowledge(Val);
Id =:= 5 ->
'S1AP-PDU-Contents':'enc_E-RABSetupResponse'(Val);
Id =:= 6 ->
'S1AP-PDU-Contents':'enc_E-RABModifyResponse'(Val);
Id =:= 7 ->
'S1AP-PDU-Contents':'enc_E-RABReleaseResponse'(Val);
Id =:= 9 ->
'S1AP-PDU-Contents':enc_InitialContextSetupResponse(Val);
Id =:= 14 ->
'S1AP-PDU-Contents':enc_ResetAcknowledge(Val);
Id =:= 17 ->
'S1AP-PDU-Contents':enc_S1SetupResponse(Val);
Id =:= 21 ->
'S1AP-PDU-Contents':enc_UEContextModificationResponse(Val);
Id =:= 23 ->
'S1AP-PDU-Contents':enc_UEContextReleaseComplete(Val);
Id =:= 29 ->
'S1AP-PDU-Contents':enc_ENBConfigurationUpdateAcknowledge(Val);
Id =:= 30 ->
'S1AP-PDU-Contents':enc_MMEConfigurationUpdateAcknowledge(Val);
Id =:= 36 ->
'S1AP-PDU-Contents':enc_WriteReplaceWarningResponse(Val);
Id =:= 43 ->
'S1AP-PDU-Contents':enc_KillResponse(Val);
Id =:= 48 ->
'S1AP-PDU-Contents':enc_UERadioCapabilityMatchResponse(Val);
Id =:= 50 ->
'S1AP-PDU-Contents':'enc_E-RABModificationConfirm'(Val);
Id =:= 53 ->
'S1AP-PDU-Contents':enc_UEContextModificationConfirm(Val);
Id =:= 55 ->
'S1AP-PDU-Contents':enc_UEContextSuspendResponse(Val);
Id =:= 56 ->
'S1AP-PDU-Contents':enc_UEContextResumeResponse(Val);
Id =:= 63 ->
'S1AP-PDU-Contents':enc_UERadioCapabilityIDMappingResponse(Val);
true ->
open_type_to_binary(Val)
end.

enc_os_UnsuccessfulOutcome5(Val, Id) ->
if Id =:= 0 ->
'S1AP-PDU-Contents':enc_HandoverPreparationFailure(Val);
Id =:= 1 ->
'S1AP-PDU-Contents':enc_HandoverFailure(Val);
Id =:= 3 ->
'S1AP-PDU-Contents':enc_PathSwitchRequestFailure(Val);
Id =:= 9 ->
'S1AP-PDU-Contents':enc_InitialContextSetupFailure(Val);
Id =:= 17 ->
'S1AP-PDU-Contents':enc_S1SetupFailure(Val);
Id =:= 21 ->
'S1AP-PDU-Contents':enc_UEContextModificationFailure(Val);
Id =:= 29 ->
'S1AP-PDU-Contents':enc_ENBConfigurationUpdateFailure(Val);
Id =:= 30 ->
'S1AP-PDU-Contents':enc_MMEConfigurationUpdateFailure(Val);
Id =:= 56 ->
'S1AP-PDU-Contents':enc_UEContextResumeFailure(Val);
true ->
open_type_to_binary(Val)
end.

complete(L0) ->
    L = complete(L0, []),
    case list_to_bitstring(L) of
        <<>> ->
            <<0>>;
        Bin ->
            Bin
    end.

complete([], Bits, []) ->
    case Bits band 7 of
        0 ->
            [];
        N ->
            [<<0:(8 - N)>>]
    end;
complete([], Bits, [H | More]) ->
    complete(H, Bits, More);
complete([align | T], Bits, More) ->
    case Bits band 7 of
        0 ->
            complete(T, More);
        1 ->
            [<<0:7>> | complete(T, More)];
        2 ->
            [<<0:6>> | complete(T, More)];
        3 ->
            [<<0:5>> | complete(T, More)];
        4 ->
            [<<0:4>> | complete(T, More)];
        5 ->
            [<<0:3>> | complete(T, More)];
        6 ->
            [<<0:2>> | complete(T, More)];
        7 ->
            [<<0:1>> | complete(T, More)]
    end;
complete([[] | T], Bits, More) ->
    complete(T, Bits, More);
complete([[_ | _] = H], Bits, More) ->
    complete(H, Bits, More);
complete([[_ | _] = H | T], Bits, More) ->
    complete(H, Bits, [T | More]);
complete([H | T], Bits, More) when is_integer(H); is_binary(H) ->
    [H | complete(T, Bits, More)];
complete([H | T], Bits, More) ->
    [H | complete(T, Bits + bit_size(H), More)];
complete(Bin, Bits, More) when is_binary(Bin) ->
    [Bin | complete([], Bits, More)];
complete(Bin, Bits, More) ->
    [Bin | complete([], Bits + bit_size(Bin), More)].

complete([], []) ->
    [];
complete([], [H | More]) ->
    complete(H, More);
complete([align | T], More) ->
    complete(T, More);
complete([[] | T], More) ->
    complete(T, More);
complete([[_ | _] = H], More) ->
    complete(H, More);
complete([[_ | _] = H | T], More) ->
    complete(H, [T | More]);
complete([H | T], More) when is_integer(H); is_binary(H) ->
    [H | complete(T, More)];
complete([H | T], More) ->
    [H | complete(T, bit_size(H), More)];
complete(Bin, More) when is_binary(Bin) ->
    [Bin | complete([], More)];
complete(Bin, More) ->
    [Bin | complete([], bit_size(Bin), More)].

decode_fragmented(SegSz0, Buf0, Unit) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Res:SegSz/bitstring,Buf/bitstring>> = Buf0,
    decode_fragmented_1(Buf, Unit, Res).

decode_fragmented_1(<<0:1,N:7,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>, Buf};
decode_fragmented_1(<<1:1,0:1,N:14,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>, Buf};
decode_fragmented_1(<<1:1,1:1,SegSz0:6,Buf0/bitstring>>, Unit, Res0) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Frag:SegSz/bitstring,Buf/bitstring>> = Buf0,
    Res = <<Res0/bitstring,Frag/bitstring>>,
    decode_fragmented_1(Buf, Unit, Res).

encode_fragmented(Bin, Unit) ->
    encode_fragmented_1(Bin, Unit, 4).

encode_fragmented_1(Bin, Unit, N) ->
    SegSz = Unit * N * 16384,
    case Bin of
        <<B:SegSz/bitstring,T/bitstring>> ->
            [<<3:2,N:6>>, B | encode_fragmented_1(T, Unit, N)];
        _ when N > 1 ->
            encode_fragmented_1(Bin, Unit, N - 1);
        _ ->
            case bit_size(Bin) div Unit of
                Len when Len < 128 ->
                    [Len, Bin];
                Len when Len < 16384 ->
                    [<<2:2,Len:14>>, Bin]
            end
    end.

open_type_to_binary({asn1_OPENTYPE, Bin}) when is_binary(Bin) ->
    Bin.
