% From libosmocore gsm_08_08.h

% this is from GSM 03.03 CGI but is copied in GSM 08.08
% in § 3.2.2.27 for Cell Identifier List
-define(CELL_ID_WHOLE_GLOBAL, 0).
-define(CELL_ID_LAC_AND_CI, 1).
-define(CELL_ID_CI, 2).
-define(CELL_ID_NO_CELL, 3).
-define(CELL_ID_LAI_AND_LAC, 4).
-define(CELL_ID_LAC, 5).
-define(CELL_ID_BSS, 6).
-define(CELL_ID_UTRAN_PLMN_LAC_RNC, 8).
-define(CELL_ID_UTRAN_RNC, 9).
-define(CELL_ID_UTRAN_LAC_RNC, 10).

% GSM 08.06 § 6.3 
-define(BSSAP_MSG_BSS_MANAGEMENT, 16#0).
-define(BSSAP_MSG_DTAP, 16#1).

% enum BSSMAP_MSG_TYPE {
-define(BSSMAP_MSG_RESERVED_0, 0).
% ASSIGNMENT MESSAGES
-define(BSSMAP_MSG_ASS_RQST, 1).
-define(BSSMAP_MSG_ASS_COMPL, 2).
-define(BSSMAP_MSG_ASS_FAILURE, 3).
% HANDOVER MESSAGES
-define(BSSMAP_MSG_HO_REQ, 16).
-define(BSSMAP_MSG_HO_REQUIRED, 17).
-define(BSSMAP_MSG_HO_REQ_ACK, 18).
-define(BSSMAP_MSG_HO_CMD, 19).
-define(BSSMAP_MSG_HO_COMPL, 20).
-define(BSSMAP_MSG_HO_SUCCEEDED, 21).
-define(BSSMAP_MSG_HO_FAILURE, 22).
-define(BSSMAP_MSG_HO_PERFORMED, 23).
-define(BSSMAP_MSG_HO_CAND_ENQ, 24).
-define(BSSMAP_MSG_HO_CAND_RESP, 25).
-define(BSSMAP_MSG_HO_REQUIRED_REJ, 26).
-define(BSSMAP_MSG_HO_DETECT, 27).
% RELEASE MESSAGES 
-define(BSSMAP_MSG_CLEAR_CMD, 32).
-define(BSSMAP_MSG_CLEAR_COMPL, 33).
-define(BSSMAP_MSG_CLEAR_RQST, 34).
-define(BSSMAP_MSG_RESERVED_1, 35).
-define(BSSMAP_MSG_RESERVED_2, 36).
-define(BSSMAP_MSG_SAPI_N_REJ, 37).
-define(BSSMAP_MSG_CONFUSION, 38).
% OTHER CONNECTION RELATED MESSAGES
-define(BSSMAP_MSG_SUSPEND, 40).
-define(BSSMAP_MSG_RESUME, 41).
-define(BSSMAP_MSG_CONN_ORIENT_INFO, 42).
-define(BSSMAP_MSG_PERFORM_LOC_RQST, 43).
-define(BSSMAP_MSG_LSA_INFORMATION, 44).
-define(BSSMAP_MSG_PERFORM_LOC_RESPONSE, 45).
-define(BSSMAP_MSG_PERFORM_LOC_ABORT, 46).
-define(BSSMAP_MSG_COMMON_ID, 47).
% GENERAL MESSAGES
-define(BSSMAP_MSG_RESET, 48).
-define(BSSMAP_MSG_RESET_ACK, 49).
-define(BSSMAP_MSG_OVERLOAD, 50).
-define(BSSMAP_MSG_RESERVED_3, 51).
-define(BSSMAP_MSG_RESET_CIRC, 52).
-define(BSSMAP_MSG_RESET_CIRC_ACK, 53).
-define(BSSMAP_MSG_MSC_INVOKE_TRACE, 54).
-define(BSSMAP_MSG_BSS_INVOKE_TRACE, 55).
-define(BSSMAP_MSG_CONN_LESS_INFO, 58).
% TERRESTRIAL RESOURCE MESSAGES
-define(BSSMAP_MSG_BLOCK, 64).
-define(BSSMAP_MSG_BLOCKING_ACK, 65).
-define(BSSMAP_MSG_UNBLOCK, 66).
-define(BSSMAP_MSG_UNBLOCKING_ACK, 67).
-define(BSSMAP_MSG_CIRC_GROUP_BLOCK, 68).
-define(BSSMAP_MSG_CIRC_GROUP_BLOCKING_ACK, 69).
-define(BSSMAP_MSG_CIRC_GROUP_UNBLOCK, 70).
-define(BSSMAP_MSG_CIRC_GROUP_UNBLOCKING_ACK, 71).
-define(BSSMAP_MSG_UNEQUIPPED_CIRCUIT, 72).
-define(BSSMAP_MSG_CHANGE_CIRCUIT, 78).
-define(BSSMAP_MSG_CHANGE_CIRCUIT_ACK, 79).
% RADIO RESOURCE MESSAGES
-define(BSSMAP_MSG_RESOURCE_RQST, 80).
-define(BSSMAP_MSG_RESOURCE_INDICATION, 81).
-define(BSSMAP_MSG_PAGING, 82).
-define(BSSMAP_MSG_CIPHER_MODE_CMD, 83).
-define(BSSMAP_MSG_CLASSMARK_UPDATE, 84).
-define(BSSMAP_MSG_CIPHER_MODE_COMPL, 85).
-define(BSSMAP_MSG_QUEUING_INDICATION, 86).
-define(BSSMAP_MSG_COMPL_LAYER_3, 87).
-define(BSSMAP_MSG_CLASSMARK_RQST, 88).
-define(BSSMAP_MSG_CIPHER_MODE_REJ, 89).
-define(BSSMAP_MSG_LOAD_INDICATION, 90).
% VGCS/VBS
-define(BSSMAP_MSG_VGCS_VBS_SETUP, 4).
-define(BSSMAP_MSG_VGCS_VBS_SETUP_ACK, 5).
-define(BSSMAP_MSG_VGCS_VBS_SETUP_REFUSE, 6).
-define(BSSMAP_MSG_VGCS_VBS_ASS_RQST, 7).
-define(BSSMAP_MSG_VGCS_VBS_ASS_RESULT, 28).
-define(BSSMAP_MSG_VGCS_VBS_ASS_FAILURE, 29).
-define(BSSMAP_MSG_VGCS_VBS_QUEUING_INDICATION, 30).
-define(BSSMAP_MSG_UPLINK_RQST, 31).
-define(BSSMAP_MSG_UPLINK_RQST_ACK, 39).
-define(BSSMAP_MSG_UPLINK_RQST_CONFIRMATION, 73).
-define(BSSMAP_MSG_UPLINK_RELEASE_INDICATION, 74).
-define(BSSMAP_MSG_UPLINK_REJ_CMD, 75).
-define(BSSMAP_MSG_UPLINK_RELEASE_CMD, 76).
-define(BSSMAP_MSG_UPLINK_SEIZED_CMD, 77).

% enum BSSMAP_IE_CODING {
-define(BSSMAP_IE_CIRC_ID_CODE, 1).		% TV16
%-define(BSSMAP_IE_RESERVED_0, 2).
-define(BSSMAP_IE_RES_AVAIL, 3).		% TVf
-define(BSSMAP_IE_CAUSE, 4).			% TLV
-define(BSSMAP_IE_CELL_ID, 5).			% TLV
-define(BSSMAP_IE_PRIORITY, 6).			% TLV
-define(BSSMAP_IE_L3_HDR_INFO, 7).		% TLV
-define(BSSMAP_IE_IMSI, 8).			% TLV
-define(BSSMAP_IE_TMSI, 9).			% TLV
-define(BSSMAP_IE_ENCR_INFO, 10).		% TLV
-define(BSSMAP_IE_CHANNEL_TYPE, 11).		% TLV
-define(BSSMAP_IE_PERIODICITY, 12).		% TV
-define(BSSMAP_IE_EXTD_RES_IND, 13).		% TV
-define(BSSMAP_IE_NUMBER_OF_MSS, 14).		% TV
%-define(BSSMAP_IE_RESERVED_1, 15).
%-define(BSSMAP_IE_RESERVED_2, 16).
%-define(BSSMAP_IE_RESERVED_3, 17).
-define(BSSMAP_IE_CM_INFO_T2, 18).		% TLV
-define(BSSMAP_IE_CM_INFO_T3, 19).		% TLV
-define(BSSMAP_IE_INTERF_BAND_TO_USE, 20).	% TV
-define(BSSMAP_IE_RR_CAUSE, 21).		% TV
%-define(BSSMAP_IE_RESERVED_4, 22).
-define(BSSMAP_IE_L3_INFO, 23).			% TLV
-define(BSSMAP_IE_DLCI, 24).			% TV
-define(BSSMAP_IE_DOWNLINK_DTX_FLAG, 25).	% TV
-define(BSSMAP_IE_CELL_ID_LIST, 	26).	% TLV
-define(BSSMAP_IE_RESPONSE_RQST, 27).		% TV
-define(BSSMAP_IE_RES_IND_METHOD, 28).		% TV
-define(BSSMAP_IE_CM_INFO_T1, 29).		% TV
-define(BSSMAP_IE_CIRC_ID_CODE_LIST, 30).	% TLV
-define(BSSMAP_IE_DIAGNOSTIC, 31).		% TLV
-define(BSSMAP_IE_L3_MSG_CONTENTS, 32).		% TLV
-define(BSSMAP_IE_CHOSEN_CHANNEL, 33).		% TV
-define(BSSMAP_IE_TOT_RES_ACCESS, 34).		% TVf
-define(BSSMAP_IE_CIPH_RESP_MODE, 35).		% TV
-define(BSSMAP_IE_CHANNEL_NEEDED, 36).		% TV
-define(BSSMAP_IE_TRACE_TYPE, 37).		% TV
-define(BSSMAP_IE_TRIGGERID, 38).		% TLV
-define(BSSMAP_IE_TRACE_REFERENCE, 39).		% TV
-define(BSSMAP_IE_TRANSACTIONID, 40).		% TLV
-define(BSSMAP_IE_MOBILE_IDENTITY, 41).		% TLV
-define(BSSMAP_IE_OMCID, 42).			% TLV
-define(BSSMAP_IE_FORWARD_INDICATOR, 43).	% TV
-define(BSSMAP_IE_CHOSEN_ENCR_ALG, 44).		% TV
-define(BSSMAP_IE_CIRCUIT_POOL, 45).		% TV
-define(BSSMAP_IE_CIRCUIT_POOL_LIST, 46).	% TLV
-define(BSSMAP_IE_TIME_INDICATION, 47).		% TV
-define(BSSMAP_IE_RESOURCE_SITUATION, 48).	% TLV
-define(BSSMAP_IE_CUR_CHAN_TYPE_1, 49).		% TV
-define(BSSMAP_IE_QUEUEING_IND, 50).		% TV
-define(BSSMAP_IE_SPEECH_VERSION, 64).		% TV
-define(BSSMAP_IE_ASS_REQUIREMENT, 51).		% TV
-define(BSSMAP_IE_TALKER_FLAG, 53).		% T
-define(BSSMAP_IE_CONN_REL_RQSTED, 54).		% T
-define(BSSMAP_IE_GROUP_CALL_REFERENCE, 55).	% TLV
-define(BSSMAP_IE_EMLPP_PRIORITY, 56).		% TV
-define(BSSMAP_IE_CONFIG_EVO_INDI, 57).		% TV
-define(BSSMAP_IE_OLD_TO_NEW_BSS_INFO, 58).	% TLV
-define(BSSMAP_IE_LSA_IDENTIFIER, 59).		% TLV
-define(BSSMAP_IE_LSA_IDENTIFIER_LIST, 60).	% TLV
-define(BSSMAP_IE_LSA_INFORMATION, 61).		% TLV
-define(BSSMAP_IE_LCS_QOS, 62).			% TLV
-define(BSSMAP_IE_LSA_ACCESS_CTRL_SUPPR, 63).	% TV
-define(BSSMAP_IE_LCS_PRIORITY, 67).		% TLV
-define(BSSMAP_IE_LOCATION_TYPE, 68).		% TLV
-define(BSSMAP_IE_LOCATION_ESTIMATE, 69).	% TLV
-define(BSSMAP_IE_POSITIONING_DATA, 70).	% TLV
-define(BSSMAP_IE_LCS_CAUSE, 71).		% TLV
-define(BSSMAP_IE_LCS_CLIENT_TYPE, 72).		% TLV
-define(BSSMAP_IE_APDU, 73).			% TLV
-define(BSSMAP_IE_NETWORK_ELEMENT_ID, 74).	% TLV
-define(BSSMAP_IE_GPS_ASSISTANCE_DATA, 75).	% TLV
-define(BSSMAP_IE_DECIPHERING_KEYS, 76).	% TLV
-define(BSSMAP_IE_RETURN_ERROR_RQST, 77).	% TLV
-define(BSSMAP_IE_RETURN_ERROR_CAUSE, 78).	% TLV
-define(BSSMAP_IE_SEGMENTATION, 79).		% TLV
-define(BSSMAP_IE_SERVICE_HANDOVER, 80).	% TLV
-define(BSSMAP_IE_SRC_TGT_RNC_TRANSP_UMTS, 81).	% TLV
-define(BSSMAP_IE_SRC_TGT_RNC_TRANSP_CDMA2K, 82). % TLV
%-define(BSSMAP_IE_RESERVED_5, 65).
%-define(BSSMAP_IE_RESERVED_6, 66).

% enum gsm0808_cause {
-define(BSSMAP_CAUSE_RIF_MSG_FAILURE, 0).
-define(BSSMAP_CAUSE_RIF_FAILURE, 1).
-define(BSSMAP_CAUSE_UPLINK_QUALITY, 2).
-define(BSSMAP_CAUSE_UPLINK_STRENGTH, 3).
-define(BSSMAP_CAUSE_DOWNLINK_QUALITY, 4).
-define(BSSMAP_CAUSE_DOWNLINK_STRENGTH, 5).
-define(BSSMAP_CAUSE_DISTANCE, 6).
-define(BSSMAP_CAUSE_O_AND_M_INTERVENTION, 7).
-define(BSSMAP_CAUSE_RESPONSE_TO_MSC_INVOCATION, 8).
-define(BSSMAP_CAUSE_CALL_CONTROL, 9).
-define(BSSMAP_CAUSE_RIF_FAILURE_REVERSION, 10).
-define(BSSMAP_CAUSE_HO_SUCCESSFUL, 11).
-define(BSSMAP_CAUSE_BETTER_CELL, 12).
-define(BSSMAP_CAUSE_DIRECTED_RETRY, 13).
-define(BSSMAP_CAUSE_JOINED_GROUP_CALL_CHANNEL, 14).
-define(BSSMAP_CAUSE_TRAFFIC, 15).
-define(BSSMAP_CAUSE_EQUIPMENT_FAILURE, 32).
-define(BSSMAP_CAUSE_NO_RR_AVAILABLE, 33).
-define(BSSMAP_CAUSE_RQSTED_TERR_RES_UNAVAIL, 34).
-define(BSSMAP_CAUSE_CCCH_OVERLOAD, 35).
-define(BSSMAP_CAUSE_PROCESSOR_OVERLOAD, 36).
-define(BSSMAP_CAUSE_BSS_NOT_EQUIPPED, 37).
-define(BSSMAP_CAUSE_MS_NOT_EQUIPPED, 38).
-define(BSSMAP_CAUSE_INVALID_CELL, 39).
-define(BSSMAP_CAUSE_TRAFFIC_LOAD, 40).
-define(BSSMAP_CAUSE_PREEMPTION, 41).
-define(BSSMAP_CAUSE_RQSTED_TRANSC_RA_UNAVAIL, 48).
-define(BSSMAP_CAUSE_CIRCUIT_POOL_MISMATCH, 49).
-define(BSSMAP_CAUSE_SWITCH_CIRCUIT_POOL, 50).
-define(BSSMAP_CAUSE_RQSTED_SPEECH_V_UNAVAIL, 51).
-define(BSSMAP_CAUSE_LSA_NOT_ALLOWED, 52).
-define(BSSMAP_CAUSE_CIPH_ALG_NOT_SUPPORTED, 64).
-define(BSSMAP_CAUSE_TERR_CIRC_ALLOCATED, 80).
-define(BSSMAP_CAUSE_INV_MSG_CONTENTS, 81).
-define(BSSMAP_CAUSE_IE_OR_FIELD_MISSING, 82).
-define(BSSMAP_CAUSE_INCORRECT_VALUE, 83).
-define(BSSMAP_CAUSE_UNKNOWN_MSG_TYPE, 84).
-define(BSSMAP_CAUSE_UNKNOWN_IE, 85).
-define(BSSMAP_CAUSE_PROT_ERR_BSS_AND_MSC, 96).

% GSM 08.08 3.2.2.11 Channel Type
% enum gsm0808_chan_indicator {
-define(BSSMAP_CHAN_SPEECH, 1).
-define(BSSMAP_CHAN_DATA, 2).
-define(BSSMAP_CHAN_SIGN, 3).

% enum gsm0808_chan_rate_type_data {
-define(BSSMAP_DATA_FULL_BM, 16#8).
-define(BSSMAP_DATA_HALF_LM, 16#9).
-define(BSSMAP_DATA_FULL_RPREF, 16#a).
-define(BSSMAP_DATA_HALF_PREF, 16#b).
-define(BSSMAP_DATA_FULL_PREF_NO_CHANGE, 16#1a).
-define(BSSMAP_DATA_HALF_PREF_NO_CHANGE, 16#1b).
-define(BSSMAP_DATA_MULTI_MASK, 16#20).
-define(BSSMAP_DATA_MULTI_MASK_NO_CHANGE, 16#30).

% enum gsm0808_chan_rate_type_speech {
-define(BSSMAP_SPEECH_FULL_BM, 16#8).
-define(BSSMAP_SPEECH_HALF_LM, 16#9).
-define(BSSMAP_SPEECH_FULL_PREF, 16#a).
-define(BSSMAP_SPEECH_HALF_PREF, 16#b).
-define(BSSMAP_SPEECH_FULL_PREF_NO_CHANGE, 16#1a).
-define(BSSMAP_SPEECH_HALF_PREF_NO_CHANGE, 16#1b).
-define(BSSMAP_SPEECH_PERM, 16#f).
-define(BSSMAP_SPEECH_PERM_NO_CHANGE, 16#1f).

% enum gsm0808_permitted_speech {
-define(BSSMAP_PERM_FR1, 16#01).
-define(BSSMAP_PERM_FR2, 16#11).
-define(BSSMAP_PERM_FR3, 16#21).
%	BSSMAP_PERM_HR1	= BSSMAP_PERM_FR1 | 16#4,
%	BSSMAP_PERM_HR2	= BSSMAP_PERM_FR2 | 16#4,
%	BSSMAP_PERM_HR3	= BSSMAP_PERM_FR3 | 16#4,
%};
