#ifndef TETRA_SNDCP_PDU_H
#define TETRA_SNDCP_PDU_H

#include <stdint.h>

/* 28.115 */
enum sndcp_pdu_type {
	SNDCP_PDU_T_ACT_PDP_ACCEPT	= 0x0,
	SNDCP_PDU_T_DEACT_PDP_ACC	= 0x1,
	SNDCP_PDU_T_DEACT_PDP_DEMAND	= 0x2,
	SNDCP_PDU_T_ACT_PDP_REJECT	= 0x3,
	SNDCP_PDU_T_UNITDATA		= 0x4,
	SNDCP_PDU_T_DATA		= 0x5,
	SNDCP_PDU_T_DATA_TX_REQ		= 0x6,
	SNDCP_PDU_T_DATA_TX_RESP	= 0x7,
	SNDCP_PDU_T_END_OF_DATA		= 0x8,
	SNDCP_PDU_T_RECONNECT		= 0x9,
	SNDCP_PDU_T_PAGE_REQUEST	= 0xa,
	SNDCP_PDU_T_NOT_SUPPORTED	= 0xb,
	SNDCP_PDU_T_DATA_PRIORITY	= 0xc,
	SNDCP_PDU_T_MODIFY		= 0xd,
};

#define SNDCP_PDU_T_ACT_PDP_DEMAND	SNDCP_PDU_T_ACT_PDP_ACCEPT
#define	SNDCP_PDU_T_PAGE_RESPONSE	SNDCP_PDU_T_PAGE_REQUEST

#endif /* TETRA_SNDCP_PDU_H */

const char *tetra_get_sndcp_pdut_name(uint8_t pdut, int uplink);
