#!/usr/bin/env python3

import os
import unittest
from pySim.javacard import *

class TestJavacard(unittest.TestCase):

    def test_CapFile(self):
        loadfile="01000fdecaffed010204000105d07002ca4402001f000f001f000c002800420018006d00320017000000a900040002002203010004002803020107a0000000620101060210a0000000090003ffffffff8910710002000107a000000062000103000c0108d07002ca44900101002006001843800301ff0007020000002f00398002008101010881000007006d000911188c00048d00012c18197b0002037b00029210240303038b000388007a02318f00053d8c00062e1b8b00077a0120188b000860037a7a02228d00092d1d10076b101a8b000a321fae006b06188c000b7a06118d000c2c1903077b000d037b000d928b000e198b000f3b7a08003200040002000203001857656c636f6d6520746f20546f6f7243616d70203230313203000a48656c6c6f2c2053544b0000000005004200100200000006810900050000020381090b0680030001000000060000010380030103800303068108000381080c0600005306810a000500000003810a1303810a1609001700021e2d0011050306040908040507090a0a06070404040b00a901000100000300030005800281018100ff080000000028ff08000002002800020000008003ff820001002f001d0000000000090020003f000d000000000701002f0042000800000000080100390046001800000000ff020053002f0018000000000010002200240028002a002fffff002f002f003100330022002f00370028003b002201300568109001b008b44323430110012005681080056810a00633b44104b431066800a10231"
        cap = CapFile(os.path.dirname(os.path.abspath(__file__)) + "/test_javacard.cap")
        self.assertTrue(b2h(cap.get_loadfile()) == loadfile)
        self.assertTrue(cap.get_loadfile_aid() == "d07002ca44")
        self.assertTrue(cap.get_applet_aid() == "d07002ca44900101")


if __name__ == "__main__":
	unittest.main()
