/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MaskedApplets {
    private static final int MAX_APPS = 16;
    private static final int MAX_AID_LENGTH = 16;
    private static final int MAX_PARM_LENGTH = 32;
    private static int appIndex = 0;
    private static String[] romAppClass = new String[16];
    private static Method[] romAppInstallMethod = new Method[16];
    private static byte[][] romAppAID = new byte[16][];
    private static int maxAppNum = 15;

    public static int addApplet(String name) {
        if (appIndex >= 16) {
            System.err.println(Globals._messages.getString("MaxApp"));
            throw new RuntimeException();
        }
        MaskedApplets.romAppClass[MaskedApplets.appIndex] = name;
        return appIndex++;
    }

    private static byte[] convertStringToBytes(String aidString, int maxLength) {
        byte[] bArray = new byte[maxLength];
        int digitNumber = 0;
        aidString = aidString.trim();
        int beginOffset = 0;
        int endOffset = 0;
        Integer num = null;
        while (beginOffset < aidString.length()) {
            endOffset = aidString.indexOf(":", beginOffset);
            num = endOffset == -1 ? Integer.decode(aidString.substring(beginOffset)) : Integer.decode(aidString.substring(beginOffset, endOffset));
            if (digitNumber >= maxLength) {
                System.err.println(String.valueOf(Globals._messages.getString("BadAID")) + aidString);
                throw new SimulationException();
            }
            bArray[digitNumber++] = num.byteValue();
            if (endOffset == -1) break;
            beginOffset = ++endOffset;
        }
        byte[] returnArray = new byte[digitNumber];
        System.arraycopy(bArray, 0, returnArray, 0, returnArray.length);
        return returnArray;
    }

    public static byte[] getAID(byte index) {
        return romAppAID[index];
    }

    public static short getInstallInstance(byte index) {
        Method appInstall = null;
        try {
            Class<?> myAppletClass = Class.forName(romAppClass[index]);
            Object[] installParms = new Object[]{null, new Short(0), new Byte(0)};
            Class[] installParmsClass = new Class[]{Class.forName("[B"), Short.TYPE, Byte.TYPE};
            appInstall = myAppletClass.getMethod("install", installParmsClass);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e);
            throw new SimulationException();
        }
        if (appInstall == null) {
            return -1;
        }
        MaskedApplets.romAppInstallMethod[index] = appInstall;
        return index;
    }

    public static int getNumberOfROMApplets() {
        return appIndex;
    }

    public static void install(byte index, byte[] bArray, short bOffset, byte bLength) {
        Object[] installParms = new Object[]{bArray, new Short(bOffset), new Byte(bLength)};
        try {
            romAppInstallMethod[index].invoke(null, installParms);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(String.valueOf(Globals._messages.getString("SickChd")) + romAppInstallMethod[index]);
            throw new SimulationException();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e);
            throw new SimulationException();
        }
    }

    public static void readConfigFile(String configFile) {
        try {
            String aString;
            BufferedReader in = new BufferedReader(new FileReader(configFile));
            while ((aString = in.readLine()) != null) {
                if ((aString = aString.trim().replace('\t', ' ')).startsWith("//") || aString.length() == 0) continue;
                int spIndex = aString.indexOf(" ");
                int lastSpIndex = aString.lastIndexOf(" ");
                if (spIndex == -1 || aString.substring(spIndex, lastSpIndex).trim().length() != 0) {
                    System.err.println(String.valueOf(Globals._messages.getString("BadCFG")) + aString);
                    throw new SimulationException();
                }
                String classStr = aString.substring(0, spIndex);
                String aidStr = aString.substring(lastSpIndex).trim();
                if (aidStr.indexOf(" ") != -1) {
                    System.err.println(String.valueOf(Globals._messages.getString("BadCFG")) + aString);
                    throw new SimulationException();
                }
                int appIndex = MaskedApplets.addApplet(classStr);
                MaskedApplets.setAppletAID(appIndex, aidStr);
            }
        }
        catch (IOException e) {
            System.err.println(e);
            throw new SimulationException();
        }
        if (MaskedApplets.getNumberOfROMApplets() == 0) {
            System.err.println(String.valueOf(Globals._messages.getString("CFGError")) + configFile);
            throw new SimulationException();
        }
    }

    public static void setAppletAID(int appIndex, String aidString) {
        byte[] aidArray;
        if ((aidString = aidString.trim()).startsWith("\"") && aidString.endsWith("\"")) {
            aidString = aidString.substring(1, aidString.length() - 1);
            aidArray = aidString.getBytes();
        } else {
            aidArray = MaskedApplets.convertStringToBytes(aidString, 16);
        }
        if (aidArray == null || aidArray.length < 5) {
            System.err.println(String.valueOf(Globals._messages.getString("ShortAID")) + aidString);
            throw new RuntimeException();
        }
        MaskedApplets.romAppAID[appIndex] = aidArray;
    }
}

