/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils.instructions;

import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import java.util.Vector;

public class JCControlInstr
extends Instruction {
    private byte[] args;

    public JCControlInstr(Instr jcInstruction, Vector<Instruction> bcVector) {
        super(jcInstruction);
        int javaOpCode = 0;
        switch (jcInstruction.opcode) {
            case 147: {
                this.javaInstructions.add(new JavaInstruction(191));
                return;
            }
            case 95: {
                return;
            }
            case 96: 
            case 152: {
                javaOpCode = 153;
                break;
            }
            case 97: 
            case 153: {
                javaOpCode = 154;
                break;
            }
            case 98: 
            case 154: {
                javaOpCode = 155;
                break;
            }
            case 99: 
            case 155: {
                javaOpCode = 156;
                break;
            }
            case 100: 
            case 156: {
                javaOpCode = 157;
                break;
            }
            case 101: 
            case 157: {
                javaOpCode = 158;
                break;
            }
            case 102: 
            case 158: {
                javaOpCode = 198;
                break;
            }
            case 103: 
            case 159: {
                javaOpCode = 199;
                break;
            }
            case 104: 
            case 160: {
                javaOpCode = 165;
                break;
            }
            case 105: 
            case 161: {
                javaOpCode = 166;
                break;
            }
            case 106: 
            case 162: {
                javaOpCode = 159;
                break;
            }
            case 107: 
            case 163: {
                javaOpCode = 160;
                break;
            }
            case 108: 
            case 164: {
                javaOpCode = 161;
                break;
            }
            case 109: 
            case 165: {
                javaOpCode = 162;
                break;
            }
            case 110: 
            case 166: {
                javaOpCode = 163;
                break;
            }
            case 111: 
            case 167: {
                javaOpCode = 164;
                break;
            }
            case 112: 
            case 168: {
                javaOpCode = 167;
                break;
            }
            case 113: {
                javaOpCode = 168;
                break;
            }
            case 114: {
                this.javaInstructions.add(new JavaInstruction(169));
                return;
            }
            case 115: 
            case 116: {
                this.setTableSwitchInstr((InstrTableSwitch)jcInstruction, bcVector);
                return;
            }
            case 117: 
            case 118: {
                this.setLookUpSwitchInstr((InstrLookupSwitch)jcInstruction, bcVector);
                return;
            }
            case 119: {
                this.javaInstructions.add(new JavaInstruction(176));
                return;
            }
            case 120: 
            case 121: {
                this.javaInstructions.add(new JavaInstruction(172));
                return;
            }
            case 122: {
                this.javaInstructions.add(new JavaInstruction(177));
                return;
            }
        }
        Vector<Integer> argVector = new Vector<Integer>();
        argVector.add(new Integer(0));
        argVector.add(new Integer(0));
        this.javaInstructions.add(new JavaInstruction(javaOpCode, argVector));
    }

    public JCControlInstr(int javaOpCode, Vector<Integer> argVector) {
        super(null);
        if (argVector != null) {
            this.javaInstructions.add(new JavaInstruction(javaOpCode, argVector));
        } else {
            this.javaInstructions.add(new JavaInstruction(javaOpCode));
        }
    }

    public JCControlInstr(Instr ICMPInstr, Instr nextInstruction) {
        super(nextInstruction);
        int javaOpCode = 0;
        switch (nextInstruction.opcode) {
            case 96: 
            case 152: {
                javaOpCode = 159;
                break;
            }
            case 97: 
            case 153: {
                javaOpCode = 160;
                break;
            }
            case 98: 
            case 154: {
                javaOpCode = 161;
                break;
            }
            case 99: 
            case 155: {
                javaOpCode = 162;
                break;
            }
            case 100: 
            case 156: {
                javaOpCode = 163;
                break;
            }
            case 101: 
            case 157: {
                javaOpCode = 164;
                break;
            }
            default: {
                System.out.println("Unexpected instruction following ICMP");
                System.exit(1);
            }
        }
        Vector<Integer> argVector = new Vector<Integer>();
        argVector.add(new Integer(0));
        argVector.add(new Integer(0));
        this.javaInstructions.add(new JavaInstruction(javaOpCode, argVector));
    }

    private void setLookUpSwitchInstr(InstrLookupSwitch jcInstruction, Vector<Instruction> bcVector) {
        Vector<Integer> argVector = new Vector<Integer>();
        int argumentArraySize = JCControlInstr.getNumPadBytes(bcVector, bcVector.size()) + 4 + 4 + 8 * jcInstruction.ncases;
        for (int i = 0; i < argumentArraySize; ++i) {
            argVector.add(new Integer(0));
        }
        this.javaInstructions.add(new JavaInstruction(171, argVector));
    }

    private void setTableSwitchInstr(InstrTableSwitch jcInstruction, Vector<Instruction> bcVector) {
        Vector<Integer> argVector = new Vector<Integer>();
        int argumentArraySize = JCControlInstr.getNumPadBytes(bcVector, bcVector.size()) + 4 + 4 + 4 + 4 * jcInstruction.offsets.length;
        for (int i = 0; i < argumentArraySize; ++i) {
            argVector.add(new Integer(0));
        }
        this.javaInstructions.add(new JavaInstruction(170, argVector));
    }

    public static int getNumPadBytes(Vector<Instruction> bcVector, int instrIndex) {
        int bcOffset = 0;
        for (int i = 0; i < instrIndex; ++i) {
            Instruction instr = bcVector.elementAt(i);
            Vector<JavaInstruction> javaInstrs = instr.getJavaInstructions();
            for (int j = 0; j < javaInstrs.size(); ++j) {
                bcOffset += javaInstrs.elementAt(j).getSize();
            }
        }
        int numPadBytes = 4 - (bcOffset + 1) % 4;
        return numPadBytes == 4 ? 0 : numPadBytes;
    }
}

