/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.util.ClassFileNameFilter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionParser {
    String[] argv;
    ConversionProfile cp;
    public static String[] keys = new String[]{"-classdir", "-i", "-exportpath", "-exportmap", "-applet", "-d", "-out", "-V", "-version", "-v", "-verbose", "-help", "-nowarn", "-mask", "-debug", "-nobanner", "-noverify", "-config"};
    public static String[] keysWithFileNameArgs = new String[]{"-classdir", "-exportpath", "-d", "-config"};
    public static String[] keysWithNoArgs = new String[]{"-exportmap", "-i", "-V", "-version", "-v", "-verbose", "-help", "-nowarn", "-mask", "-debug", "-nobanner", "-noverify"};
    public static Vector<String> keysV = new Vector();
    public static Vector<String> keysWithFileNameArgsV = new Vector();
    public static Vector<String> keysWithNoArgsV = new Vector();

    public OptionParser(String[] argv, ConversionProfile cp) {
        this.argv = argv;
        this.cp = cp;
        for (String element : keys) {
            keysV.addElement(element);
        }
        for (String element : keysWithFileNameArgs) {
            keysWithFileNameArgsV.addElement(element);
        }
        for (String element : keysWithNoArgs) {
            keysWithNoArgsV.addElement(element);
        }
    }

    public void parse() {
        try {
            if (this.argv == null || this.argv.length == 0) {
                OptionParser.usage();
                System.exit(1);
            }
            if (this.argv[0].equals("-config")) {
                this.parseOptionsFromFile(this.argv);
            } else {
                this.parseOptionsFromCommandLine(this.argv);
            }
        }
        catch (Exception anyException) {
            OptionParser.usage();
            System.exit(1);
        }
        this.checkOptions();
    }

    private Vector<String> putQuotedTogether(Vector<String> v) {
        int i;
        boolean qOn = false;
        Vector<String> pV = new Vector<String>();
        for (i = 0; i < v.size(); ++i) {
            String str = v.elementAt(i);
            if (str.indexOf("\"") == -1) {
                if (qOn) {
                    pV.setElementAt(pV.lastElement() + " " + str, pV.indexOf(pV.lastElement()));
                    continue;
                }
                pV.addElement(str);
                continue;
            }
            if (!str.startsWith("\"") && !str.endsWith("\"")) {
                Notifier.error("profile.14", str);
                System.exit(1);
            }
            if (!qOn) {
                qOn = true;
                pV.addElement(str);
                continue;
            }
            qOn = false;
            pV.setElementAt(pV.lastElement() + " " + str, pV.indexOf(pV.lastElement()));
        }
        for (i = 0; i < pV.size(); ++i) {
            if (pV.elementAt(i).indexOf("\"") == -1) continue;
            StringTokenizer st = new StringTokenizer(pV.elementAt(i), "\"");
            String str = "";
            while (st.hasMoreElements()) {
                str = str + st.nextToken();
            }
            pV.setElementAt(str, i);
        }
        return pV;
    }

    private void parseOptionsFromFile(String[] argv) {
        String file_name = argv[1];
        Vector<String> arrays = new Vector<String>();
        try {
            int TOKENS_LENGTH = 1;
            BufferedReader bfT = new BufferedReader(new FileReader(file_name));
            String strT = bfT.readLine();
            while (strT != null) {
                TOKENS_LENGTH += strT.length();
                strT = bfT.readLine();
            }
            bfT.close();
            BufferedReader bf = new BufferedReader(new FileReader(file_name));
            boolean qOn = false;
            char[] arr = new char[TOKENS_LENGTH];
            char[] charArr = null;
            int arrCount = 0;
            String str = bf.readLine();
            while (str != null) {
                block10: for (char element : charArr = str.toCharArray()) {
                    switch (element) {
                        case ' ': {
                            if (qOn) {
                                arr[arrCount++] = element;
                                continue block10;
                            }
                            if (arrCount <= 0) continue block10;
                            arrays.addElement(new String(arr, 0, arrCount));
                            arr = new char[TOKENS_LENGTH];
                            arrCount = 0;
                            continue block10;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': {
                            if (qOn || arrCount <= 0) continue block10;
                            arrays.addElement(new String(arr, 0, arrCount));
                            arr = new char[TOKENS_LENGTH];
                            arrCount = 0;
                            continue block10;
                        }
                        case '\"': {
                            qOn = !qOn;
                            continue block10;
                        }
                        default: {
                            arr[arrCount++] = element;
                        }
                    }
                }
                str = bf.readLine();
                if (qOn || arrCount <= 0) continue;
                arrays.addElement(new String(arr, 0, arrCount));
                arr = new char[TOKENS_LENGTH];
                arrCount = 0;
            }
            if (arrCount > 0) {
                arrays.addElement(new String(arr, 0, arrCount));
            }
        }
        catch (FileNotFoundException fnfe) {
            Notifier.error("converter.0", file_name);
            OptionParser.usage();
            System.exit(1);
        }
        catch (IOException io) {
            Notifier.error("converter.1", file_name);
            OptionParser.usage();
            System.exit(1);
        }
        Object[] arguments = new String[arrays.size()];
        arrays.copyInto(arguments);
        this.parseOptionsFromCommandLine((String[])arguments);
    }

    private void parseOptionsFromCommandLine(String[] argv) {
        Vector<AppletProfile> applet_vector = new Vector<AppletProfile>();
        block6: for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-i")) {
                this.cp.int_supported = true;
                continue;
            }
            if (argv[i].equals("-classdir")) {
                this.cp.class_root = argv[++i];
                continue;
            }
            if (argv[i].equals("-exportpath")) {
                this.cp.export_path = Strings.toStrings(argv[++i], File.pathSeparator);
                continue;
            }
            if (argv[i].equals("-exportmap")) {
                this.cp.this_exp_provided = true;
                continue;
            }
            if (argv[i].equals("-applet")) {
                AppletProfile applet_profile = new AppletProfile();
                byte[] aid = null;
                try {
                    aid = Strings.toByteArray(argv[++i], ":");
                }
                catch (Exception e) {
                    Notifier.error("profile.4", argv[i]);
                    OptionParser.usage();
                    System.exit(1);
                }
                if (aid.length > 16 || aid.length < 5) {
                    Notifier.error("profile.1", argv[i]);
                    OptionParser.usage();
                    System.exit(1);
                }
                applet_profile.aid = aid;
                applet_profile.install_class = argv[++i].replace('.', '/');
                applet_vector.addElement(applet_profile);
                continue;
            }
            if (argv[i].equals("-out")) {
                while (true) {
                    if (argv[i + 1].equals("JCA")) {
                        this.cp.output |= 4;
                        this.cp.deleteJCA = false;
                        ++i;
                        continue;
                    }
                    if (argv[i + 1].equals("CAP")) {
                        this.cp.output |= 1;
                        this.cp.output |= 4;
                        ++i;
                        continue;
                    }
                    if (argv[i + 1].equals("EXP")) {
                        this.cp.output |= 2;
                        ++i;
                        continue;
                    }
                    if (!argv[i + 1].equals("NORMALIZED_CAP")) continue block6;
                    this.cp.output = 8;
                    this.cp.output |= 1;
                    this.cp.output |= 4;
                    ++i;
                }
            }
            if (argv[i].equals("-d")) {
                this.cp.output_dir = argv[++i];
                continue;
            }
            if (argv[i].equals("-keepproxysource")) {
                this.cp.keepDir = argv[++i];
                continue;
            }
            if (argv[i].equals("-verbose")) {
                Notifier.setVerboseFlag(true);
                continue;
            }
            if (argv[i].equals("-v")) {
                Notifier.setVerboseFlag(true);
                continue;
            }
            if (argv[i].equals("-noverify")) {
                this.cp.noVerify = true;
                continue;
            }
            if (argv[i].equals("-version")) {
                Notifier.outPrintLn(ToolsVersion.getToolName(1) + ToolsVersion.getVersion(1));
                Notifier.outPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-V")) {
                Notifier.outPrintLn(ToolsVersion.getToolName(1) + ToolsVersion.getVersion(1));
                Notifier.outPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-help")) {
                OptionParser.usage();
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-debug")) {
                this.cp.debug = true;
                continue;
            }
            if (argv[i].equals("-mask")) {
                this.cp.mask = true;
                continue;
            }
            if (argv[i].equals("-nowarn")) {
                Notifier.setNoWarningFlag(true);
                continue;
            }
            if (argv[i].equals("-nobanner")) {
                Notifier.setNoBannerFlag(true);
                continue;
            }
            if (argv[i].equals("-sign")) {
                this.cp.sign = true;
                continue;
            }
            if (argv[i].equals("-keystore")) {
                this.cp.keystore = argv[++i];
                continue;
            }
            if (argv[i].equals("-storepass")) {
                this.cp.storepass = argv[++i];
                continue;
            }
            if (argv[i].equals("-alias")) {
                this.cp.alias = argv[++i];
                continue;
            }
            if (argv[i].equals("-passkey")) {
                this.cp.passkey = argv[++i];
                continue;
            }
            if (argv[i].equals("-inputcap")) {
                this.cp.inputCapName = argv[++i];
                continue;
            }
            if (argv[i].equals("-useproxyclass")) {
                this.cp.useProxyClass = true;
                continue;
            }
            if (argv[i].equals("-usecapcomponents")) {
                this.cp.useCapComponents = true;
                continue;
            }
            if (argv[i].startsWith("-")) {
                Notifier.error("profile.0", argv[i]);
                OptionParser.usage();
                System.exit(1);
            }
            this.cp.package_profile = new PackageProfile();
            this.cp.package_profile.package_name = argv[i].replace('.', '/');
            byte[] aid = null;
            try {
                aid = Strings.toByteArray(argv[++i], ":");
            }
            catch (Exception ee) {
                Notifier.error("profile.4", argv[i]);
                OptionParser.usage();
                System.exit(1);
            }
            if (aid.length < 5 || aid.length > 16) {
                Notifier.error("profile.1", argv[i]);
                OptionParser.usage();
                System.exit(1);
            }
            this.cp.package_profile.aid = aid;
            byte[] versions = null;
            try {
                versions = Strings.toByteArray(argv[++i], ".");
            }
            catch (Exception e) {
                Notifier.error("profile.2", argv[i]);
                OptionParser.usage();
                System.exit(1);
            }
            if (versions.length != 2) {
                Notifier.error("profile.2", argv[i]);
                OptionParser.usage();
                System.exit(1);
            }
            this.cp.package_profile.major_version = versions[0];
            this.cp.package_profile.minor_version = versions[1];
        }
        this.cp.applets_profile = new AppletProfile[applet_vector.size()];
        applet_vector.copyInto(this.cp.applets_profile);
    }

    public static void usage() {
        for (int i = 0; i < 46; ++i) {
            Notifier.out("allusage." + i);
        }
    }

    private void checkOptions() {
        try {
            File f;
            if (this.cp.package_profile == null) {
                OptionParser.usage();
                System.exit(1);
            }
            if (this.cp.class_root == null) {
                this.cp.class_root = new String(System.getProperty("user.dir"));
            }
            this.enumerateClasses();
            if (this.cp.output == 0) {
                this.cp.output |= 1;
                this.cp.output |= 2;
                this.cp.output |= 4;
            }
            if (this.cp.output_dir == null) {
                this.cp.output_dir = this.cp.class_root;
            }
            if (this.cp.export_path == null) {
                String path = System.getProperty("java.class.path");
                this.cp.export_path = Strings.toStrings(path, File.pathSeparator);
            }
            if (this.cp.applets_profile == null) {
                this.cp.applets_profile = new AppletProfile[0];
            }
            if (this.cp.mask && (this.cp.output & 1) != 0) {
                Notifier.error("profile.7");
                System.exit(1);
            }
            if (this.cp.keepDir != null && (f = new File(this.cp.keepDir)).exists() && f.isFile()) {
                Notifier.error("converter.14", this.cp.keepDir);
                throw new ConverterException();
            }
        }
        catch (Exception anyException) {
            OptionParser.usage();
            System.exit(1);
        }
    }

    private void enumerateClasses() {
        File class_dir;
        String package_name = this.cp.package_profile.package_name.replace('/', File.separatorChar);
        File class_root_dir = new File(this.cp.class_root);
        if (!class_root_dir.exists()) {
            Notifier.error("profile.3", this.cp.class_root);
            OptionParser.usage();
            System.exit(1);
        }
        if (!(class_dir = new File(class_root_dir, package_name)).exists()) {
            if (File.separatorChar == '\\' && this.cp.class_root.endsWith("\\")) {
                Notifier.error("profile.5", this.cp.class_root + package_name);
            } else {
                Notifier.error("profile.5", this.cp.class_root + File.separatorChar + package_name);
            }
            OptionParser.usage();
            System.exit(1);
        }
        Object[] class_names = class_dir.list(new ClassFileNameFilter());
        Arrays.sort(class_names);
        if (class_names == null) {
            Notifier.error("profile.6");
            OptionParser.usage();
            System.exit(1);
        }
        this.cp.classes = new File[class_names.length];
        for (int i = 0; i < class_names.length; ++i) {
            this.cp.classes[i] = new File(class_dir, (String)class_names[i]);
        }
    }
}

