/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfAttribute;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfConstantValueAttribute;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

abstract class BaseClassInterfaceConverter {
    JClassFile java_class;
    JcClass jc_class;
    PackageConverter p_converter;

    BaseClassInterfaceConverter(JClassFile java_class, PackageConverter p_converter) {
        this.java_class = java_class;
        this.p_converter = p_converter;
        this.jc_class = new JcClass(java_class);
        if (p_converter.getJcPackage().getEfExportFile() != null) {
            this.jc_class.setEfClass(p_converter.getJcPackage().getEfExportFile().getClass(java_class.getClassName()));
        }
    }

    public JcClass getJcClass() {
        return this.jc_class;
    }

    public JClassFile getJavaClass() {
        return this.java_class;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    protected String[] determinePublicSuperInterfaces() throws Exception {
        String[] all_interfaces = this.jc_class.getSuperInterfaces();
        Vector<String> public_interfaces = new Vector<String>(15);
        String this_package_name = Names.getPackageName(this.java_class.getClassName());
        for (String an_interface : all_interfaces) {
            if (Names.getPackageName(an_interface).equals(this_package_name)) {
                JcClass jc_interface = this.p_converter.getJcClass(an_interface);
                if (jc_interface == null) {
                    throw new ConversionException();
                }
                int access_flags = jc_interface.getAccessFlags();
                if (!Modifier.isPublic(access_flags)) continue;
                public_interfaces.addElement(an_interface);
                continue;
            }
            EfClass ef_interface = this.getExportClass(an_interface);
            if (ef_interface == null) {
                throw new ConversionException();
            }
            public_interfaces.addElement(an_interface);
        }
        Object[] public_interface_names = new String[public_interfaces.size()];
        public_interfaces.copyInto(public_interface_names);
        return public_interface_names;
    }

    protected boolean determineShareableType() {
        String[] public_interfaces;
        for (String element : public_interfaces = this.jc_class.getPublicSuperInterfaces()) {
            if (!element.equals("javacard/framework/Shareable")) continue;
            return true;
        }
        return this.java_class.getClassName().equals("javacard/framework/Shareable");
    }

    protected void addInterfaces(Vector<String> vector, String[] interface_names) {
        for (String element : interface_names) {
            this.addInterface(vector, element);
        }
    }

    protected void addInterface(Vector<String> vector, String interface_name) {
        for (int i = 0; i < vector.size(); ++i) {
            String an_interface = vector.elementAt(i);
            if (!an_interface.equals(interface_name)) continue;
            return;
        }
        vector.addElement(interface_name);
    }

    protected void intTypeCheck() throws Exception {
        JMethod[] java_methods;
        JField[] java_fields;
        for (JField element : java_fields = this.java_class.getFields()) {
            Object[] args;
            String descriptor = element.getFieldDescriptor();
            if (!descriptor.equals("I") && !descriptor.equals("[I")) continue;
            if (this.p_converter.isIntSupported()) {
                args = new Object[]{this.java_class.getClassName().replace('/', '.'), element.getFieldName()};
                Notifier.progress("warning.1", args);
                this.p_converter.setIntFlag(true);
                continue;
            }
            args = new Object[]{this.java_class.getClassName().replace('/', '.'), element.getFieldName()};
            Notifier.error("int.1", args);
            throw new ConversionException();
        }
        for (JMethod java_method : java_methods = this.java_class.getMethods()) {
            String[] param_descs;
            String descriptor = java_method.getMethodDescriptor();
            for (String element : param_descs = MethodDescriptor.getParamDescriptors(descriptor)) {
                Object[] args;
                if (!element.equals("I") && !element.equals("[I")) continue;
                if (this.p_converter.isIntSupported()) {
                    args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                    Notifier.progress("warning.2", args);
                    this.p_converter.setIntFlag(true);
                    continue;
                }
                args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                Notifier.error("int.2", args);
                throw new ConversionException();
            }
            String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
            if (!return_desc.equals("I") && !return_desc.equals("[I")) continue;
            if (this.p_converter.isIntSupported()) {
                Object[] args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
                Notifier.progress("warning.3", args);
                this.p_converter.setIntFlag(true);
                continue;
            }
            Object[] args = new Object[]{this.java_class.getClassName().replace('/', '.'), java_method.getMethodName()};
            Notifier.error("int.3", args);
            throw new ConversionException();
        }
    }

    protected EfClass getExportClass(String class_name) throws Exception {
        ExportFileManager ex_manager = this.p_converter.getExportFileManager();
        EfClass ef_class = ex_manager.getClass(class_name);
        return ef_class;
    }

    protected EfClass getExportClassIfAvailable(String class_name) {
        ExportFileManager ex_manager = this.p_converter.getExportFileManager();
        EfClass ef_class = ex_manager.getClassIfAvailable(class_name);
        return ef_class;
    }

    protected JcClass getJcClass(String class_name) {
        JcClass jc_class = this.p_converter.getJcClass(class_name);
        return jc_class;
    }

    protected void detectRemovedAPIFields() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfField[] efField = this.getJcClass().getEfClass().getFields();
        for (int i = 0; i < efField.length; ++i) {
            EfField eff = efField[i];
            JcField jcf = this.getJcClass().getField(eff.getFieldName(), eff.getFieldDescriptor());
            if (jcf != null && jcf.isAPIElement(this.getJcClass(), this.getPackageConverter().getJcPackage())) continue;
            Object[] args = new Object[]{eff.getFieldName()};
            Notifier.error("binary.3", args);
            throw new ConversionException();
        }
    }

    protected void checkFieldFlags() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        for (int i = 0; i < this.getJcClass().getFields().length; ++i) {
            JcField jcF = this.getJcClass().getFields()[i];
            if (jcF.getEfField() == null) continue;
            EfField efF = jcF.getEfField();
            if (efF.isStatic() && !jcF.isStatic()) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.4", args);
                throw new ConversionException();
            }
            if (!efF.isStatic() && jcF.isStatic()) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.5", args);
                throw new ConversionException();
            }
            if (efF.isPublic() && jcF.isProtected()) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.6", args);
                throw new ConversionException();
            }
            if (!efF.isFinal() && jcF.isFinal()) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.7", args);
                throw new ConversionException();
            }
            if (!efF.isFinal() || jcF.isFinal() || !jcF.isStatic()) continue;
            Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.8", args);
            throw new ConversionException();
        }
    }

    protected void checkMethodFlags() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        for (int i = 0; i < this.getJcClass().getMethods().length; ++i) {
            Object[] args;
            JcMethod jcM = this.getJcClass().getMethods()[i];
            if (jcM.getEfMethod() == null) continue;
            EfMethod efM = jcM.getEfMethod();
            if (efM.isStatic() && !jcM.isStatic()) {
                args = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.9", args);
                throw new ConversionException();
            }
            if (!efM.isStatic() && jcM.isStatic()) {
                args = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.10", args);
                throw new ConversionException();
            }
            if (efM.isPublic() && jcM.isProtected()) {
                args = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.11", args);
                throw new ConversionException();
            }
            EfClass efClass = this.getJcClass().getEfClass();
            if (!efM.isFinal() && jcM.isFinal() && !efClass.isFinal()) {
                Object[] args2 = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.12", args2);
                throw new ConversionException();
            }
            if (efM.isAbstract() || !jcM.isAbstract()) continue;
            Object[] args3 = new Object[]{jcM.getMethodName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.13", args3);
            throw new ConversionException();
        }
    }

    protected void detectAddedAPIFields() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        boolean hadReferenceAPIField = this.getJcClass().getEfClass().hasReferenceAPIField();
        for (int i = 0; i < this.getJcClass().getFields().length; ++i) {
            JcField jcF = this.getJcClass().getFields()[i];
            if (!jcF.isAPIElement(this.getJcClass(), this.getPackageConverter().getJcPackage())) continue;
            if (jcF.getEfField() == null) {
                if (!this.getPackageConverter().getConversionProfile().packageUpgrade) {
                    Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                    Notifier.error("binary.14", args);
                    throw new ConversionException();
                }
                if (!hadReferenceAPIField || jcF.isReferenceType()) continue;
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.15", args);
                throw new ConversionException();
            }
            if (this.getPackageConverter().getConversionProfile().packageUpgrade) continue;
            if (jcF.getEfField().isProtected() && jcF.isPublic()) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.16", args);
                throw new ConversionException();
            }
            if (!jcF.getEfField().isFinal() || jcF.isFinal()) continue;
            Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
            Notifier.error("binary.17", args);
            throw new ConversionException();
        }
    }

    protected void assignKnownFieldTokens() {
        JcField[] jc_fields = this.getJcClass().getFields();
        for (int i = 0; i < jc_fields.length; ++i) {
            if (jc_fields[i].getEfField() != null) {
                jc_fields[i].setFieldToken(jc_fields[i].getEfField().getFieldToken());
                continue;
            }
            jc_fields[i].setFieldToken(255);
        }
    }

    protected void presortFieldsByTokens() {
        JcField[] jc_fields = this.getJcClass().getFields();
        boolean again = true;
        while (again) {
            again = false;
            for (int i = 0; i < jc_fields.length - 1; ++i) {
                if (!jc_fields[i].isStatic() && jc_fields[i + 1].isStatic() || (jc_fields[i].getFieldToken() <= jc_fields[i + 1].getFieldToken() || jc_fields[i].getFieldToken() == 255 || jc_fields[i + 1].getFieldToken() == 255) && (jc_fields[i].getFieldToken() != 255 || jc_fields[i + 1].getFieldToken() == 255)) continue;
                JcField jcf = jc_fields[i];
                jc_fields[i] = jc_fields[i + 1];
                jc_fields[i + 1] = jcf;
                again = true;
            }
        }
    }

    protected void checkFieldValues() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        JcField[] jcf = this.getJcClass().getFields();
        for (int i = 0; i < jcf.length; ++i) {
            if (!jcf[i].isPublic() || !jcf[i].isStatic() || !jcf[i].isFinal() || jcf[i].getEfField() == null) continue;
            JcField jcF = jcf[i];
            EfAttribute efa = jcf[i].getEfField().getAttribute();
            int[] ar2 = jcf[i].getValue();
            if (ar2.length == 0 || !(efa instanceof EfConstantValueAttribute)) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.18", args);
                throw new ConversionException();
            }
            if (efa == null) {
                Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.')};
                Notifier.error("binary.19", args);
                throw new ConversionException();
            }
            if (ar2[0] == ((EfConstantValueAttribute)efa).getValue()) continue;
            Object[] args = new Object[]{jcF.getFieldName(), this.getJcClass().getClassName().replace('/', '.'), "" + ((EfConstantValueAttribute)efa).getValue(), "" + ar2[0]};
            Notifier.error("binary.20", args);
            throw new ConversionException();
        }
    }

    protected void detectRemovedPublicSuperinterfaces() throws Exception {
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> ev = new Vector<String>(Arrays.asList(efClass.getInterfaceNames()));
        Vector<String> jv = new Vector<String>(Arrays.asList(jcClass.getPublicSuperInterfaces()));
        if (jv.containsAll(ev)) {
            return;
        }
        ev.removeAll(jv);
        if (!ev.isEmpty()) {
            Object[] args = new Object[]{ev.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.21", args);
            throw new ConversionException();
        }
    }

    protected void detectAddedPublicSuperinterfaces() throws Exception {
        Vector<String> jv;
        if (this.getJcClass().getEfClass() == null) {
            return;
        }
        if (!this.getJcClass().isAPIElement(this.getPackageConverter().getJcPackage())) {
            return;
        }
        EfClass efClass = this.getJcClass().getEfClass();
        JcClass jcClass = this.getJcClass();
        Vector<String> ev = new Vector<String>(Arrays.asList(efClass.getInterfaceNames()));
        if (ev.containsAll(jv = new Vector<String>(Arrays.asList(jcClass.getPublicSuperInterfaces())))) {
            return;
        }
        jv.removeAll(ev);
        if (!jv.isEmpty()) {
            Object[] args = new Object[]{jv.toString().replace('/', '.'), jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.37", args);
            throw new ConversionException();
        }
    }
}

