/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.exportfile.EfConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfMethod
extends MethodDefinition {
    private int name_index;
    private int descriptor_index;
    EfConstantPool constant_pool;

    public EfMethod(EfConstantPool cp) {
        this.constant_pool = cp;
    }

    public EfMethod(MethodDefinition a_method, EfConstantPool cp) {
        super(a_method);
        this.access_flags &= 0xFFFFFEFF;
        this.access_flags &= 0xFFFFF7FF;
        this.constant_pool = cp;
        this.name_index = this.constant_pool.addConstantUtf8(this.method_name);
        this.descriptor_index = this.constant_pool.addConstantUtf8(this.descriptor);
    }

    public void parse(DataInputStream dis) throws IOException {
        this.token = dis.readUnsignedByte();
        this.access_flags = dis.readShort();
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
    }

    public void resolve() {
        this.method_name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getUtf8String();
    }

    public void toText(PrintWriter pw, int tab_level) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tab_level; ++i) {
            sb.append("\t");
        }
        String indent = sb.toString();
        pw.println(indent + "method_info {");
        pw.println(indent + "\ttoken\t" + Integer.toString(this.token));
        pw.println(indent + "\taccess_flags\t" + Modifier.toString(this.access_flags));
        pw.println(indent + "\tname_index\t" + this.name_index + "\t\t// " + this.method_name);
        pw.println(indent + "\tDescriptor_Index\t" + this.descriptor_index + "\t\t// " + this.descriptor);
        pw.println(indent + "}");
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.writeByte(this.token);
        dos.writeShort(this.access_flags);
        dos.writeShort(this.name_index);
        dos.writeShort(this.descriptor_index);
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }
}

