/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ReferenceSIChecker {
    private JcPackage jc_package;
    private String package_name;
    private ExportFileManager ex_manager;
    private boolean check_export_only;
    private Hashtable<String, MethodDefinition[]> si_methods;

    public ReferenceSIChecker(JcPackage jcPackage, ExportFileManager exManager, boolean checkExportOnly) {
        this.jc_package = jcPackage;
        this.package_name = jcPackage.getPackageName();
        this.ex_manager = exManager;
        this.check_export_only = checkExportOnly;
        this.si_methods = new Hashtable();
    }

    public void check() throws Exception {
        JcClass[] jc_classes;
        JcConstant[] constants = this.jc_package.getConstantPool().getConstants();
        this.getFromConstantPool(constants);
        for (JcClass jc_class : jc_classes = this.jc_package.getClasses()) {
            this.checkClass(jc_class);
        }
    }

    public Vector<Hashtable<String, MethodDefinition[]>> getExactProxies() {
        JcClass[] jc_classes;
        Vector<Hashtable<String, MethodDefinition[]>> v = new Vector<Hashtable<String, MethodDefinition[]>>();
        for (JcClass j : jc_classes = this.jc_package.getClasses()) {
            Hashtable<String, MethodDefinition[]> t = new Hashtable<String, MethodDefinition[]>();
            if (j.isShareableType() && !j.isInterfaceType()) {
                JcImplementedInterfaceInfo[] infos;
                for (JcImplementedInterfaceInfo info : infos = j.getImplementedInterfaceInfos()) {
                    String interfaceName = info.getInterfaceName();
                    if (!this.isShareableInterface(interfaceName)) continue;
                    MethodDefinition[] m = info.getInterfaceMethods();
                    t.put(interfaceName, m);
                }
            }
            if (t.size() <= 0) continue;
            v.addElement(t);
        }
        return v;
    }

    private boolean isShareableInterface(String name) {
        JcClass[] jc_classes;
        for (JcClass j : jc_classes = this.jc_package.getClasses()) {
            if (!name.equals(j.getClassName())) continue;
            return j.isShareableType();
        }
        return false;
    }

    public Hashtable<String, MethodDefinition[]> getSIMethodsTable() {
        return this.si_methods;
    }

    public String getPackageName() {
        return this.package_name;
    }

    private void getFromConstantPool(JcConstant[] constants) throws Exception {
        if (constants.length == 0) {
            return;
        }
        for (int i = 0; i < constants.length; ++i) {
            JcConstant constant = constants[i];
            if (constant instanceof JcConstantClassRef) {
                JcConstantClassRef class_ref = (JcConstantClassRef)constant;
                String class_name = class_ref.getClassName();
                this.getFromClassRef(class_name);
                continue;
            }
            if (constant instanceof JcConstantMethodRef) {
                JcConstantMethodRef method_ref = (JcConstantMethodRef)constant;
                String method_desc = method_ref.getDescriptor();
                this.getFromMethodRef(method_desc);
                continue;
            }
            if (!(constant instanceof JcConstantFieldRef)) continue;
            JcConstantFieldRef field_ref = (JcConstantFieldRef)constant;
            String field_desc = field_ref.getDescriptor();
            String field_referenced_class = Names.getClassNameFromDescriptor(field_desc);
            this.getFromClassRef(field_referenced_class);
        }
    }

    private void getFromMethodRef(String descriptor) throws Exception {
        String[] param_descs;
        for (String element : param_descs = MethodDescriptor.getParamDescriptors(descriptor)) {
            String param_referenced_class = Names.getClassNameFromDescriptor(element);
            this.getFromClassRef(param_referenced_class);
        }
        String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
        String return_referenced_class = Names.getClassNameFromDescriptor(return_desc);
        this.getFromClassRef(return_referenced_class);
    }

    private void getFromClassRef(String class_name) throws Exception {
        if (class_name == null) {
            return;
        }
        if (this.thisPackage(class_name)) {
            String[] super_interfaces;
            Vector<String> v;
            JcClass jc_class = this.jc_package.getClass(class_name);
            if (jc_class.isPublic() && jc_class.isInterfaceType() && !this.si_methods.containsKey(class_name) && (v = new Vector<String>(Arrays.asList(super_interfaces = this.check_export_only ? jc_class.getPublicSuperInterfaces() : jc_class.getSuperInterfaces()))).contains("javacard/framework/Shareable")) {
                this.si_methods.put(class_name, jc_class.getMethods());
            }
        } else {
            String[] super_interfaces;
            Vector<String> v;
            EfClass ef_class = this.ex_manager.getClass(class_name);
            if (ef_class.isInterfaceType() && !this.si_methods.containsKey(class_name) && (v = new Vector<String>(Arrays.asList(super_interfaces = ef_class.getInterfaceNames()))).contains("javacard/framework/Shareable")) {
                this.si_methods.put(class_name, ef_class.getMethods());
            }
        }
    }

    private boolean thisPackage(String class_name) {
        String package_name = Names.getPackageName(class_name);
        return this.package_name.equals(package_name);
    }

    private void checkSuperInterfaces(JcClass jc_class) throws Exception {
        String[] super_interfaces = this.check_export_only ? jc_class.getPublicSuperInterfaces() : jc_class.getSuperInterfaces();
        for (String super_interface : super_interfaces) {
            this.getFromClassRef(super_interface);
        }
    }

    private void checkClass(JcClass jc_class) throws Exception {
        int class_access_flags = jc_class.getAccessFlags();
        if (!this.check_export_only || Modifier.isPublic(class_access_flags)) {
            MethodDefinition[] methods;
            JcMethod[] jc_methods;
            JcField[] jc_fields;
            String super_class_name = jc_class.getSuperClassName();
            this.getFromClassRef(super_class_name);
            this.checkSuperInterfaces(jc_class);
            for (JcField jc_field : jc_fields = jc_class.getFields()) {
                int field_access_flags = jc_field.getAccessFlags();
                if (this.check_export_only && !Modifier.isPublic(field_access_flags) && !Modifier.isProtected(field_access_flags)) continue;
                String referenced_class = Names.getClassNameFromDescriptor(jc_field.getFieldDescriptor());
                this.getFromClassRef(referenced_class);
            }
            for (JcMethod jc_method : jc_methods = jc_class.getMethods()) {
                int method_access_flags = jc_method.getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(method_access_flags) || Modifier.isProtected(method_access_flags)) {
                    this.getFromMethodRef(jc_method.getMethodDescriptor());
                }
                if (this.check_export_only) continue;
                this.checkBytecode(jc_class, jc_method);
                this.checkExceptionTable(jc_class, jc_method);
            }
            for (MethodDefinition method : methods = jc_class.getPublicMethodTable().getMethods()) {
                this.getFromMethodRef(method.getMethodDescriptor());
            }
            for (MethodDefinition method : methods = jc_class.getPackageMethodTable().getMethods()) {
                this.getFromMethodRef(method.getMethodDescriptor());
            }
        }
    }

    private void checkExceptionTable(JcClass jc_class, JcMethod jc_method) throws Exception {
        JcException[] exceptions;
        for (JcException element : exceptions = jc_method.getExceptions()) {
            String catch_type = element.getCatchTypeClassRef().getClassName();
            if (catch_type.equals("finally")) continue;
            this.getFromClassRef(catch_type);
        }
    }

    private void checkBytecode(JcClass jc_class, JcMethod jc_method) throws Exception {
        for (JcInstruction code = jc_method.getCode(); code != null; code = code.getNextInstr()) {
            String descriptor;
            String class_name;
            JcConstantClassRef class_ref;
            int line_number = code.getSourceLineNumber();
            if (code instanceof JcInstrClassRef && (class_ref = ((JcInstrClassRef)code).getClassRef()) != null) {
                class_name = class_ref.getClassName();
                this.getFromClassRef(class_name);
            }
            if (code instanceof JcInstrFieldRef) {
                String field_name;
                JcConstantFieldRef field_ref = ((JcInstrFieldRef)code).getFieldRef();
                class_name = field_ref.getClassName();
                String newClassName = this.checkField(jc_class, class_name, field_name = field_ref.getFieldName(), descriptor = field_ref.getDescriptor(), line_number);
                if (newClassName != null) {
                    class_name = newClassName;
                    field_ref.setClassName(class_name);
                }
                String field_referenced_class = Names.getClassNameFromDescriptor(descriptor);
                this.getFromClassRef(field_referenced_class);
            }
            if (!(code instanceof JcInstrMethodRef)) continue;
            JcConstantMethodRef method_ref = ((JcInstrMethodRef)code).getMethodRef();
            class_name = method_ref.getClassName();
            String method_name = method_ref.getMethodName();
            descriptor = method_ref.getDescriptor();
            if (method_ref instanceof JcConstantSuperMethodRef) continue;
            String new_class_name = this.checkMethod(jc_class, class_name, method_name, descriptor, line_number);
            if (new_class_name != null) {
                class_name = new_class_name;
                method_ref.setClassName(new_class_name);
            }
            this.getFromMethodRef(descriptor);
        }
    }

    private boolean checkMethodTable(JcClass jc_method_class, String method_name, String descriptor) {
        MethodDefinition[] pac_methods;
        MethodDefinition[] pub_methods;
        for (MethodDefinition element : pub_methods = jc_method_class.getPublicMethodTable().getMethods()) {
            if (!element.getMethodName().equals(method_name) || !element.getMethodDescriptor().equals(descriptor)) continue;
            return true;
        }
        for (MethodDefinition element : pac_methods = jc_method_class.getPackageMethodTable().getMethods()) {
            if (!element.getMethodName().equals(method_name) || !element.getMethodDescriptor().equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkMethod(JcClass jc_class, String class_name, String method_name, String descriptor, int line_number) throws Exception {
        String result = null;
        if (this.thisPackage(class_name)) {
            JcClass jc_method_class = this.jc_package.getClass(class_name);
            if (jc_method_class == null) return result;
            if (this.jc_package.getMethod(class_name, method_name, descriptor) != null) return result;
            if (!this.checkMethodTable(jc_method_class, method_name, descriptor)) {
                EfMethod ef_method;
                int access_flags = jc_method_class.getAccessFlags();
                if (Modifier.isInterface(access_flags)) return result;
                String current_class_name = jc_method_class.getClassName();
                while (true) {
                    ClassDefinition current_class;
                    if (this.thisPackage(current_class_name)) {
                        current_class = this.jc_package.getClass(current_class_name);
                        current_class_name = current_class.getSuperClassName();
                    } else {
                        current_class = this.ex_manager.getClass(current_class_name);
                        current_class_name = ((EfClass)current_class).getSuperClassName(this.ex_manager);
                    }
                    if (current_class_name == null) return result;
                    if (this.thisPackage(current_class_name)) {
                        JcClass jc_class_to_check = this.jc_package.getClass(current_class_name);
                        JcMethod jc_method_found = jc_class_to_check.getMethod(method_name, descriptor);
                        if (jc_method_found == null) continue;
                        this.getFromMethodRef(jc_method_found.getMethodDescriptor());
                        return current_class_name;
                    }
                    EfClass ef_class_to_check = this.ex_manager.getClass(current_class_name);
                    ef_method = ef_class_to_check.getMethod(method_name, descriptor);
                    if (ef_method != null) break;
                }
                this.getFromMethodRef(ef_method.getMethodDescriptor());
                return current_class_name;
            }
            String current_class_name = jc_method_class.getClassName();
            ClassDefinition current_class = null;
            while ((current_class_name = (current_class = this.thisPackage(current_class_name) ? this.jc_package.getClass(current_class_name) : this.ex_manager.getClass(current_class_name)).getSuperClassName()) != null) {
                if (this.thisPackage(current_class_name)) {
                    JcClass jc_class_to_check = this.jc_package.getClass(current_class_name);
                    JcMethod jc_method_found = jc_class_to_check.getMethod(method_name, descriptor);
                    if (jc_method_found == null) continue;
                    this.getFromMethodRef(jc_method_found.getMethodDescriptor());
                    return current_class_name;
                }
                EfClass ef_class_to_check = this.ex_manager.getClass(current_class_name);
                EfMethod ef_method = ef_class_to_check.getMethod(method_name, descriptor);
                if (ef_method == null) return result;
                this.getFromMethodRef(ef_method.getMethodDescriptor());
                return current_class_name;
            }
            return result;
        } else {
            EfClass ef_class = this.ex_manager.getClass(class_name);
            if (ef_class == null) return result;
            EfMethod ef_method = this.ex_manager.getMethod(class_name, method_name, descriptor);
            if (ef_method == null) return result;
            this.getFromMethodRef(ef_method.getMethodDescriptor());
        }
        return result;
    }

    private String checkField(JcClass jc_class, String class_name, String field_name, String descriptor, int line_number) throws Exception {
        if (this.thisPackage(class_name)) {
            JcClass jc_field_class = this.jc_package.getClass(class_name);
            if (jc_field_class != null && this.jc_package.getField(class_name, field_name, descriptor) == null) {
                boolean done = false;
                String current_name = jc_field_class.getClassName();
                while (!done) {
                    if (this.jc_package.getClass(current_name) != null) {
                        String super_name = this.jc_package.getClass(current_name).getSuperClassName();
                        if (this.thisPackage(super_name)) {
                            current_name = super_name;
                            if (this.jc_package.getField(current_name, field_name, descriptor) == null) continue;
                            done = true;
                            String field_referenced_class = Names.getClassNameFromDescriptor(descriptor);
                            this.getFromClassRef(field_referenced_class);
                            return current_name;
                        }
                        current_name = super_name;
                        EfClass ef_class = this.ex_manager.getClass(current_name);
                        if (ef_class.getField(field_name, descriptor) != null) {
                            done = true;
                            return current_name;
                        }
                        String[] super_names = ef_class.getSuperClassNames();
                        for (int k = 0; k < super_names.length; ++k) {
                            ef_class = this.ex_manager.getClass(super_names[k]);
                            if (ef_class.getField(field_name, descriptor) == null) continue;
                            done = true;
                            String field_referenced_class = Names.getClassNameFromDescriptor(descriptor);
                            this.getFromClassRef(field_referenced_class);
                            return super_names[k];
                        }
                        done = true;
                        continue;
                    }
                    done = true;
                }
            }
        } else {
            EfField ef_field;
            EfClass ef_class = this.ex_manager.getClass(class_name);
            if (ef_class != null && (ef_field = this.ex_manager.getField(class_name, field_name, descriptor)) != null) {
                String field_referenced_class = Names.getClassNameFromDescriptor(descriptor);
                this.getFromClassRef(field_referenced_class);
            }
        }
        return null;
    }
}

