/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.CompareVersion;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyRev {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyRev() {
    }

    public static void main(String[] argv) {
        int i;
        boolean banner = true;
        for (i = 0; i < argv.length && argv[i].length() > 0 && argv[i].charAt(0) == '-'; ++i) {
            String s = argv[i];
            if (s.equals("-verbose")) {
                ++verbose;
                continue;
            }
            if (s.equals("-nobanner")) {
                banner = false;
                continue;
            }
            if (s.equals("-nowarn")) {
                VerifierError.noWarn = true;
                continue;
            }
            if (s.equals("-help")) {
                VerifyRev.printUsageAndExit();
                continue;
            }
            if (s.equals("-version")) {
                Messages.println("MainRev.3");
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
                continue;
            }
            VerifyRev.printUsageAndExit();
        }
        if (i + 2 != argv.length) {
            VerifyRev.printUsageAndExit();
        }
        if (verbose >= 1 && banner) {
            Messages.println("MainRev.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        String ef1_name = argv[i];
        String ef2_name = argv[i + 1];
        if (ef1_name.equals(ef2_name)) {
            VerifyRev.printUsageAndExit();
        }
        if (!ef1_name.endsWith(".exp") || !ef2_name.endsWith(".exp")) {
            VerifyRev.printUsageAndExit();
        }
        File ef1_file = new File(ef1_name);
        File ef2_file = new File(ef2_name);
        if (!ef1_file.getName().equals(ef2_file.getName())) {
            VerifyRev.printUsageAndExit();
        }
        if (verbose >= 1) {
            Messages.println("MainRev.4", ef1_name, (Object)ef2_name);
        }
        try {
            ExportFile ef1 = ExportFile.readFromFile(ef1_file);
            ExportFile ef2 = ExportFile.readFromFile(ef2_file);
            CompareVersion.compare(ef1, ef2);
        }
        catch (VerifierError e) {
            Messages.printSevere("MainRev.2", Messages.numWarning, e.getMessage(), Messages.format("MainRev.7"));
            System.exit(2);
        }
        Messages.println("MainRev.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.println("MainRev.1");
        System.exit(2);
    }
}

