/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.PackageItem;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValidValues {
    private static final int FIXED_RID_LENGTH = 10;
    private static final int MAX_PIX_LENGTH = 22;
    private static Vector<String> APPLICATION_TYPES = new Vector<String>(){
        {
            this.addElement("web");
            this.addElement("extended-applet");
            this.addElement("classic-applet");
            this.addElement("extension-lib");
            this.addElement("classic-lib");
        }
    };
    private static Vector<String> LIBRARY_TYPES = new Vector<String>(){
        {
            this.addElement("extension-lib");
            this.addElement("classic-lib");
        }
    };
    private static Vector<String> CREDENTIAL_AUTH_DURATIONS = new Vector<String>(){
        {
            this.addElement("access");
            this.addElement("card-session");
            this.addElement("client-lifetime");
        }
    };
    private static Vector<String> CREDENTIAL_AUTH_TYPES = new Vector<String>(){
        {
            this.addElement("client-only");
        }
    };
    private static Vector<String> BOOLEAN_VALUES = new Vector<String>(){
        {
            this.addElement("true");
            this.addElement("false");
        }
    };
    private static Vector<String> AUTH_METHODS = new Vector<String>(){
        {
            this.addElement("FORM");
            this.addElement("DIGEST");
            this.addElement("BASIC");
        }
    };

    public static boolean isValidAppType(String str) {
        if (str == null) {
            return false;
        }
        return APPLICATION_TYPES.contains(str);
    }

    public static boolean isValidLibType(String str) {
        if (str == null) {
            return false;
        }
        return LIBRARY_TYPES.contains(str);
    }

    public static boolean isValidCredentialAuthDuration(String str) {
        return CREDENTIAL_AUTH_DURATIONS.contains(str);
    }

    public static boolean isValidCredentialAuthType(String str) {
        return CREDENTIAL_AUTH_TYPES.contains(str);
    }

    public static boolean isValidBoolean(String str) {
        return BOOLEAN_VALUES.contains(str);
    }

    public static boolean isValidNNMToken(String str) {
        Pattern p = Pattern.compile("[A-Za-z0-9:._\\Q-\\E]*");
        Matcher m = p.matcher(str);
        m = m.reset();
        return m.matches();
    }

    public static boolean isValidAuthMethod(String str) {
        if (AUTH_METHODS.contains(str)) {
            return true;
        }
        return str.startsWith("JC-");
    }

    public static boolean isValidAID(String aid, String type, PackageItem item) {
        String aidAuthority = "//aid/";
        if (!aid.startsWith(aidAuthority)) {
            item.addError(ErrorKey.InvalidAID, aid);
            return false;
        }
        String aidSubStr = aid.substring(aidAuthority.length());
        int lastIndexofSlash = aidSubStr.lastIndexOf("/");
        if (lastIndexofSlash == -1) {
            item.addError(ErrorKey.MissingPIX, aid);
            return false;
        }
        if (lastIndexofSlash != aidSubStr.indexOf("/")) {
            item.addError(ErrorKey.InvalidAID, aid);
            return false;
        }
        String RID = aidSubStr.substring(0, lastIndexofSlash);
        String PIX = aidSubStr.substring(lastIndexofSlash + 1);
        if (RID.length() != 10) {
            item.addError(ErrorKey.InvalidRID, RID, aid);
            return false;
        }
        if (RID.startsWith("-")) {
            item.addError(ErrorKey.RIDStartsWithDash, aid);
            return false;
        }
        if (!ValidValues.isValidHexadecimalNumber(RID)) {
            item.addError(ErrorKey.RIDIsNotHexNumber, aid);
            return false;
        }
        if (PIX.equals("-")) {
            return true;
        }
        if (PIX.length() == 0) {
            item.addError(ErrorKey.EmptyPIX, aid);
            return false;
        }
        if (PIX.startsWith("-")) {
            item.addError(ErrorKey.PIXStartsWithDash, aid);
            return false;
        }
        if (PIX.length() % 2 != 0 || PIX.length() > 22) {
            item.addError(ErrorKey.InvalidPIXLength, aid);
            return false;
        }
        if (!ValidValues.isValidHexadecimalNumber(PIX)) {
            item.addError(ErrorKey.PIXIsNotHexNumber, aid);
            return false;
        }
        return true;
    }

    public static boolean isValidHexadecimalNumber(String number) {
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            try {
                Integer.parseInt(smallNumber, 16);
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println(e.toString());
                return false;
            }
        }
        return true;
    }
}

