/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.ChannelInfo;

public class SimChannelManager {
    public static final byte NULL_CONTEXTID = 15;
    private static ChannelInfo[] logicChannel = null;
    private static byte MAX_CHANNELS = (byte)-1;
    private static int CONTACTLESS_OFFSET;
    private static int ARRAY_SIZE;

    public static void init(byte maxChn) {
        MAX_CHANNELS = maxChn;
        CONTACTLESS_OFFSET = MAX_CHANNELS;
        ARRAY_SIZE = CONTACTLESS_OFFSET + MAX_CHANNELS;
        logicChannel = new ChannelInfo[ARRAY_SIZE];
        for (int i = 0; i < ARRAY_SIZE; ++i) {
            SimChannelManager.logicChannel[i] = new ChannelInfo();
            logicChannel[i].setChannelInfo((byte)15, false);
            logicChannel[i].closeChannel();
        }
        logicChannel[0].openChannel();
        logicChannel[CONTACTLESS_OFFSET].openChannel();
    }

    public static byte getActiveContext(byte channelID, byte interfaceId) {
        return logicChannel[channelID + CONTACTLESS_OFFSET * interfaceId].getActiveContext();
    }

    public static void setChannelInfo(byte channelID, byte interfaceId, byte ContextID, boolean isMultiSelect) {
        logicChannel[channelID + CONTACTLESS_OFFSET * interfaceId].setChannelInfo(ContextID, isMultiSelect);
    }

    public static boolean isPkgMultiSelectable(byte channelID, byte interfaceId) {
        return logicChannel[channelID + CONTACTLESS_OFFSET * interfaceId].isPkgMultiSelectable();
    }

    public static boolean isChannelOpen(byte channelID, byte interfaceId) {
        return logicChannel[channelID + CONTACTLESS_OFFSET * interfaceId].isChannelOpen();
    }

    public static boolean openChannel(byte channelID, byte interfaceId) {
        return logicChannel[channelID + CONTACTLESS_OFFSET * interfaceId].openChannel();
    }

    public static boolean closeChannel(byte channelID, byte interfaceId) {
        return logicChannel[channelID + CONTACTLESS_OFFSET * interfaceId].closeChannel();
    }

    public static byte getMaxChannels() {
        return MAX_CHANNELS;
    }

    public static byte openAvailableChannel(byte interfaceId) {
        if (interfaceId == 0) {
            for (int i = 1; i < MAX_CHANNELS; ++i) {
                if (logicChannel[i].isChannelOpen()) continue;
                logicChannel[i].openChannel();
                return (byte)i;
            }
        } else {
            for (int i = CONTACTLESS_OFFSET; i < ARRAY_SIZE; ++i) {
                if (logicChannel[i].isChannelOpen()) continue;
                logicChannel[i].openChannel();
                return (byte)(i - CONTACTLESS_OFFSET);
            }
        }
        return -1;
    }

    public static boolean isAppletActive(int contextID) {
        if (contextID == 15) {
            return false;
        }
        boolean activeApp = false;
        for (int i = 0; i < ARRAY_SIZE; i = (int)((byte)(i + 1))) {
            if (logicChannel[i].getActiveContext() != contextID || !logicChannel[i].isChannelOpen()) continue;
            activeApp = true;
        }
        return activeApp;
    }

    public static boolean isContextActive(byte contextID) {
        if (contextID == 15) {
            return false;
        }
        boolean activePkg = false;
        byte tgtCtx = (byte)(contextID & 0xFFFFFFF0);
        for (int i = 0; i < ARRAY_SIZE; i = (int)((byte)(i + 1))) {
            byte pkgCtx = logicChannel[i].getActiveContext();
            if (pkgCtx == 15 || tgtCtx != (pkgCtx = (byte)(pkgCtx & 0xFFFFFFF0)) || !logicChannel[i].isChannelOpen()) continue;
            activePkg = true;
        }
        return activePkg;
    }

    public static boolean isPkgMultiSelected(byte contextID) {
        boolean isMS = false;
        int targetCount = 0;
        if (contextID == 15) {
            return false;
        }
        byte tgtCtx = (byte)(contextID & 0xF0);
        for (int i = 0; i < ARRAY_SIZE; ++i) {
            int pkgCtx = logicChannel[i].getActiveContext() & 0xFF;
            if (pkgCtx == 15 || tgtCtx != (pkgCtx = (int)((byte)(pkgCtx & 0xF0))) || !logicChannel[i].isChannelOpen()) continue;
            targetCount = (byte)(targetCount + 1);
        }
        if (targetCount > 1) {
            isMS = true;
        }
        return isMS;
    }

    public static boolean isAppletMultiSelected(byte contextID) {
        boolean isMS = false;
        int targetCount = 0;
        if (contextID == 15) {
            return false;
        }
        for (int i = 0; i < ARRAY_SIZE; i = (int)((byte)(i + 1))) {
            byte pkgCtx = (byte)(logicChannel[i].getActiveContext() & 0xFF);
            if (contextID != pkgCtx || !logicChannel[i].isChannelOpen()) continue;
            ++targetCount;
        }
        if (targetCount > 1) {
            isMS = true;
        }
        return isMS;
    }

    public static boolean isShareableAccessAllowed(byte contextID) {
        if (!SimChannelManager.isContextActive(contextID)) {
            return true;
        }
        boolean msFlag = false;
        byte tgtCtx = (byte)(contextID & 0xF0);
        for (int i = 0; i < ARRAY_SIZE; i = (int)((byte)(i + 1))) {
            int pkgCtx = logicChannel[i].getActiveContext();
            if (pkgCtx == 15 || tgtCtx != (pkgCtx &= 0xF0) || !logicChannel[i].isChannelOpen()) continue;
            msFlag = logicChannel[i].isPkgMultiSelectable();
        }
        return msFlag;
    }

    public static boolean isAppletSelectionAllowed(int contextID) {
        int tgtCtx = contextID & 0xF0;
        if (contextID == 15) {
            return true;
        }
        for (int i = 0; i < ARRAY_SIZE; i = (int)((byte)(i + 1))) {
            int pkgCtx = logicChannel[i].getActiveContext();
            if (pkgCtx == 15 || tgtCtx != (pkgCtx &= 0xF0) || !logicChannel[i].isChannelOpen() || logicChannel[i].isPkgMultiSelectable()) continue;
            return false;
        }
        return true;
    }
}

