/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils.instructions;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.Instr;
import java.util.Vector;

public class JCObjectInstr
extends Instruction {
    public static final int CLASS_T_BOOLEAN = 4;
    public static final int CLASS_T_BYTE = 8;
    public static final int CLASS_T_SHORT = 9;
    public static final int CLASS_T_INT = 10;
    private byte[] args;
    Vector<Integer> argVector = new Vector();

    public JCObjectInstr(Instr instr, ClassConstantPool classConstantPool) {
        super(instr);
        switch (instr.opcode) {
            case 143: {
                this.resolveCPIndexAndSetArgs((short)instr.arg, classConstantPool);
                this.javaInstructions.add(new JavaInstruction(187, this.argVector));
                break;
            }
            case 144: {
                this.argVector.add(new Integer(this.getArrayType(instr.arg)));
                this.javaInstructions.add(new JavaInstruction(188, this.argVector));
                break;
            }
            case 145: {
                this.resolveCPIndexAndSetArgs((short)instr.arg, classConstantPool);
                this.javaInstructions.add(new JavaInstruction(189, this.argVector));
                break;
            }
            case 146: {
                this.javaInstructions.add(new JavaInstruction(190));
                break;
            }
            case 148: {
                this.setObjectTypeCPIndexArg(instr.arg, instr.arg2, classConstantPool);
                this.javaInstructions.add(new JavaInstruction(192, this.argVector));
                break;
            }
            case 149: {
                this.setObjectTypeCPIndexArg(instr.arg, instr.arg2, classConstantPool);
                this.javaInstructions.add(new JavaInstruction(193, this.argVector));
            }
        }
    }

    public JCObjectInstr(int n) {
        super(null);
        this.argVector.add(n);
        this.javaInstructions.add(new JavaInstruction(188, this.argVector));
    }

    private void resolveCPIndexAndSetArgs(short s, ClassConstantPool classConstantPool) {
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(s);
        String string = CAPUtil.getRefName(constantPoolEntry.classRef());
        short s2 = classConstantPool.getClassRefIndex(string);
        byte[] byArray = Util.getShortBytes(s2);
        this.argVector.add(new Integer(byArray[0] & 0xFF));
        this.argVector.add(new Integer(byArray[1] & 0xFF));
    }

    private int getArrayType(int n) {
        switch (n) {
            case 10: {
                return 4;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case 13: {
                return 10;
            }
        }
        System.out.println("Encountered bad array type");
        return 0;
    }

    private void setObjectTypeCPIndexArg(int n, int n2, ClassConstantPool classConstantPool) {
        ConstantPoolEntry constantPoolEntry;
        String string = null;
        if (n != 0) {
            switch (n) {
                case 10: {
                    string = "[Z";
                    break;
                }
                case 11: {
                    string = "[B";
                    break;
                }
                case 12: {
                    string = "[S";
                    break;
                }
                case 13: {
                    string = "[I";
                    break;
                }
                case 14: {
                    constantPoolEntry = Cap.ConstantPool.entry(n2);
                    string = CAPUtil.getRefName(constantPoolEntry.classRef());
                    string = "[L" + string + ";";
                }
            }
        } else {
            constantPoolEntry = Cap.ConstantPool.entry(n2);
            string = CAPUtil.getRefName(constantPoolEntry.classRef());
        }
        short s = classConstantPool.getClassRefIndex(string);
        byte[] byArray = Util.getShortBytes(s);
        this.argVector.add(new Integer(byArray[0] & 0xFF));
        this.argVector.add(new Integer(byArray[1] & 0xFF));
    }
}

