/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.ConverterException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Strings {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");

    public static final String toHexString(byte by) {
        return "0x" + Integer.toHexString(by & 0xFF).toUpperCase();
    }

    public static final String toHexString(short s) {
        String string = Integer.toHexString(s & 0xFFFF).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 4 - string.length(); i != 0; --i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String toHexString(int n) {
        String string = Long.toHexString(n & 0xFFFFFFFF).toUpperCase();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 8 - string.length(); i != 0; --i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String toHexString(byte[] byArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Strings.toHexString(byArray[0]));
        for (int i = 1; i < byArray.length; ++i) {
            stringBuffer.append(string);
            stringBuffer.append(Strings.toHexString(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static byte[] toByteArray(String string, String string2) throws Exception {
        String[] stringArray = Strings.toStrings(string, string2);
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = Integer.decode(stringArray[i]).byteValue();
            if (Integer.decode(stringArray[i]) <= 255) continue;
            throw new ConverterException(messages.getString("other.2"));
        }
        return byArray;
    }

    public static String[] toStrings(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final short computeShortHash(String string) {
        int n = 0;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = messageDigest.digest(byArray);
            n = byArray2.length >= 2 ? (int)((short)(byArray2[0] << 8 | byArray2[1] & 0xFF)) : -1;
        }
        catch (IOException iOException) {
            n = -1;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return (short)n;
    }

    public static final String toHexString_0(byte by) {
        int n = by & 0xFF;
        if (n > 15) {
            return Integer.toHexString(n);
        }
        return "0" + Integer.toHexString(n);
    }

    public static final String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            stringBuffer.append(Strings.toHexString_0(by));
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static final String toAidURI(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[5];
        byte[] byArray3 = new byte[byArray.length - 5];
        for (n = 0; n < 5; ++n) {
            byArray2[n] = byArray[n];
        }
        n = 0;
        for (int i = 5; i < byArray.length; ++i) {
            byArray3[n] = byArray[i];
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//aid/" + Strings.toHexString(byArray2) + "/" + Strings.toHexString(byArray3));
        return stringBuffer.toString();
    }
}

