/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.PackageTableManager;
import com.sun.javacard.jcasm.mask.SubRef;
import com.sun.javacard.jcasm.mask.TargetReference;
import java.util.Enumeration;
import java.util.Hashtable;

public class TableManager {
    public static final short EXTERNAL_REFERENCE_MASK = Short.MIN_VALUE;
    public static final int FIRST_TABLE_MAX = 64;
    public static final int SECOND_TABLE_MAX = 128;
    public static final int FIRST_LEVEL_BIT_SHIFT = 6;
    public static final int SECOND_LEVEL_BIT_SHIFT = 7;
    public static final int GLOBAL_REFERENCE_TABLE = 0;
    public static final int OBJECT_TABLE = 1;
    public static int FIRST_TABLE_ENTRY_SIZE;
    public static int REF_SIZE;
    private boolean isGRTResolved;
    Hashtable<Object, Integer> references;
    SubRef[] sr;
    int tableIdentifier = 0;
    int tableLocation = 0;

    TableManager(int n) {
        if (Main.FLAG_32_BIT) {
            FIRST_TABLE_ENTRY_SIZE = 5;
            REF_SIZE = 3;
        } else {
            FIRST_TABLE_ENTRY_SIZE = 3;
            REF_SIZE = 2;
        }
        this.references = new Hashtable();
        this.sr = new SubRef[64];
        this.tableIdentifier = n;
        if (n == 0) {
            this.isGRTResolved = false;
        }
    }

    int addExportedReference(Object object, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.sr[i] == null) {
                this.sr[i] = new SubRef();
            }
            if (this.sr[i].availableSlot == -1) continue;
            n3 = this.sr[i].addTargetReference(n, n2);
            n3 |= i << 7 | Short.MIN_VALUE;
            break;
        }
        this.references.put(object, new Integer(n3));
        return n3;
    }

    public int getExportedReference(Object object) {
        Integer n = this.references.get(object);
        return n;
    }

    TargetReference getExportedReference(int n) {
        int n2 = (n & 0x1F80) >> 7;
        int n3 = n & 0x7F;
        return this.sr[n2].tr[n3];
    }

    void resolveExportAddresses() {
        if (this.isGRTResolved) {
            return;
        }
        Enumeration<Object> enumeration = this.references.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            JCPackage jCPackage;
            Member member = (Member)enumeration.nextElement();
            Integer n2 = this.references.get(member);
            if (member instanceof JCClass) {
                jCPackage = ((JCClass)member).getParentPackage();
                n = PackageTableManager.getCompBaseAddress(jCPackage, 0);
            } else if (member instanceof JCMethod) {
                jCPackage = ((JCMethod)member).getParentClass().getParentPackage();
                n = PackageTableManager.getCompBaseAddress(jCPackage, 1);
            } else {
                jCPackage = ((Field)member).getParentClass().getParentPackage();
                n = PackageTableManager.getCompBaseAddress(jCPackage, 2);
            }
            TargetReference targetReference = this.getExportedReference(n2);
            targetReference.address = n + targetReference.address;
        }
        this.isGRTResolved = true;
    }

    int addObject(int n) {
        int n2 = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.sr[i] == null) {
                this.sr[i] = new SubRef();
            }
            if (this.sr[i].availableSlot == -1) continue;
            n2 = this.sr[i].addObjectLevel1(n);
            n2 |= i << 7;
            break;
        }
        return n2;
    }

    int addToMask(StringBuffer stringBuffer) {
        int n;
        int n2 = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        int n3 = CrefOutputFormatter.cof.currentRomAddr;
        int n4 = n2;
        if (this.tableIdentifier == 0) {
            CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable.append("/* Global reference table */" + Msg.eol);
            for (n = 0; n < 64; ++n) {
                if (this.sr[n] == null) continue;
                if (this.sr[n].availableSlot == -1) {
                    n3 += this.sr[n].addGRTToMask(CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable, n3, n);
                    continue;
                }
                n2 += this.sr[n].addGRTToMask(stringBuffer, n2, n);
            }
            stringBuffer.append("/* Global Reference Table: Main Table @" + Msg.toAddressString(n2) + "*/" + Msg.eol);
        } else {
            stringBuffer.append("/* Object Table */" + Msg.eol);
            for (n = 0; n < 64; ++n) {
                if (this.sr[n] == null) continue;
                if (this.sr[n].availableSlot == -1) {
                    n3 += this.sr[n].addObjectTableToMask(CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable, n3, n);
                    continue;
                }
                n2 += this.sr[n].addObjectTableToMask(stringBuffer, n2, n);
            }
            stringBuffer.append(Msg.eol + "/* Object Table: Main Table @" + Msg.toAddressString(n2) + "*/" + Msg.eol);
        }
        this.tableLocation = n2;
        String string = "0x00, 0x00, 0x00, ";
        if (Main.FLAG_32_BIT) {
            string = "0x00, 0x00, 0x00, 0x00, 0x00, ";
        }
        for (int i = 0; i < 64; ++i) {
            if (this.sr[i] != null) {
                if (Main.FLAG_32_BIT) {
                    stringBuffer.append(Msg.to32BitHexString(this.sr[i].location));
                    stringBuffer.append(Msg.toHexString((byte)this.sr[i].availableSlot) + ", ");
                } else {
                    stringBuffer.append(Msg.to16BitHexString(this.sr[i].location));
                    stringBuffer.append(Msg.toHexString((byte)this.sr[i].availableSlot) + ", ");
                }
            } else {
                stringBuffer.append(string);
            }
            if (i % 8 != 7) continue;
            stringBuffer.append(Msg.eol);
        }
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(n2 += FIRST_TABLE_ENTRY_SIZE * 64);
        CrefOutputFormatter.cof.currentRomAddr = n3;
        return n2 - n4;
    }
}

