/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Vector;

public class EfClass
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    public int[] supers;
    public int[] interfaces;
    public EfField[] fields;
    public EfMethod[] methods;
    private Vector<EfMethod> newMethodList;
    private Vector<EfField> newFields;
    private boolean sameVersion;
    private boolean refExists;
    private boolean isInterface;
    private static final int validFlags = 7697;
    private static final int abstractFinalFlags = 1040;
    private static final int shareableInterfaceFlags = 2560;

    EfClass(ExportFile exportFile) {
        super(exportFile);
    }

    public String thisName() {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.nameIndex]).classname();
    }

    public String superName(int n) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.supers[n]]).classname();
    }

    public String interfaceName(int n) {
        return ((EfConstant_ClassRef)this.ef.constantPool[this.interfaces[n]]).classname();
    }

    void read() throws IOException {
        int n;
        int n2;
        int n3;
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkClassrefIndex(this.nameIndex);
        int n4 = this.ef.in.readUnsignedShort();
        this.supers = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.supers[n3] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.supers[n3]);
        }
        n3 = this.ef.in.readUnsignedByte();
        this.interfaces = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.interfaces[n2] = this.ef.in.readUnsignedShort();
            this.ef.checkClassrefIndex(this.interfaces[n2]);
        }
        n2 = this.ef.in.readUnsignedShort();
        this.fields = new EfField[n2];
        for (n = 0; n < n2; ++n) {
            EfField efField = new EfField(this.ef, this.thisName());
            efField.read();
            this.fields[n] = efField;
        }
        n = this.ef.in.readUnsignedShort();
        this.methods = new EfMethod[n];
        for (int i = 0; i < n; ++i) {
            EfMethod efMethod = new EfMethod(this.ef, this.thisName());
            efMethod.read();
            this.methods[i] = efMethod;
        }
    }

    void verify(HashSet<String> hashSet, BitSet bitSet) {
        String string = this.thisName();
        if (!EfNames.validClassName(string)) {
            throw new VerifierError("EfClass.20", string);
        }
        try {
            boolean bl;
            int n;
            String string2;
            int n2 = string.lastIndexOf(47);
            String string3 = string2 = n2 == -1 ? "" : string.substring(0, n2);
            if (!string2.equals(this.ef.thisName())) {
                throw new VerifierError("EfClass.6", EfNames.prettyClass(this.ef.thisName()));
            }
            if (this.supers.length == 0 && !string.equals("java/lang/Object")) {
                throw new VerifierError("EfClass.22");
            }
            if ((this.accessFlag & 0xFFFFE1EE) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if (this.ef.minorVersion != 2 && (this.accessFlag & 0x1000) != 0) {
                throw new VerifierError("EfClass.1", this.accessFlag);
            }
            if ((this.accessFlag & 1) == 0) {
                throw new VerifierError("EfClass.2");
            }
            if ((this.accessFlag & 0x200) != 0) {
                if ((this.accessFlag & 0x400) == 0) {
                    throw new VerifierError("EfClass.3");
                }
                if ((this.accessFlag & 0x10) != 0) {
                    throw new VerifierError("EfClass.4");
                }
            }
            if ((this.accessFlag & 0x410) == 1040) {
                throw new VerifierError("EfClass.5");
            }
            boolean bl2 = (this.accessFlag & 0x1000) != 0;
            boolean bl3 = this.thisName().equals("java/rmi/Remote");
            for (n = 0; n < this.interfaces.length; ++n) {
                if (!this.interfaceName(n).equals("java/rmi/Remote")) continue;
                bl3 = true;
            }
            if (bl2 != bl3) {
                throw new VerifierError("EfClass.23", this.thisName());
            }
            n = (this.accessFlag & 0x800) != 0 ? 1 : 0;
            int n3 = this.thisName().equals("javacard/framework/Shareable");
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (!this.interfaceName(i).equals("javacard/framework/Shareable")) continue;
                n3 = 1;
            }
            if (n3 != n) {
                throw new VerifierError("EfClass.7");
            }
            if ((this.ef.thisPackage().flags & 1) == 0 && (this.accessFlag & 0xA00) != 2560) {
                throw new VerifierError("EfClass.8");
            }
            if (!hashSet.add(this.thisName())) {
                throw new VerifierError("EfClass.15");
            }
            if (bitSet.get(this.token)) {
                throw new VerifierError("EfClass.16", this.token);
            }
            bitSet.set(this.token);
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int i = 0; i < this.supers.length; ++i) {
                if (hashSet2.add(this.superName(i))) continue;
                throw new VerifierError("EfClass.17", EfNames.prettyClass(this.superName(i)));
            }
            if ((this.ef.thisPackage().flags & 1) != 0 && hashSet2.contains("javacard/framework/Applet") && (this.accessFlag & 0x400) == 0) {
                throw new VerifierError("EfClass.21", EfNames.prettyClass(this.ef.thisName()));
            }
            HashSet<String> hashSet3 = new HashSet<String>();
            for (bl = false; bl < this.interfaces.length; bl += 1) {
                if (hashSet3.add(this.interfaceName(bl ? 1 : 0))) continue;
                throw new VerifierError("EfClass.18", EfNames.prettyClass(this.interfaceName(bl ? 1 : 0)));
            }
            bl = (this.accessFlag & 0x200) != 0;
            HashSet<EfField> hashSet4 = new HashSet<EfField>();
            BitSet bitSet2 = new BitSet();
            BitSet bitSet3 = new BitSet();
            for (EfField n4 : this.fields) {
                n4.verify(bl, hashSet4, bitSet2, bitSet3);
            }
            HashSet<EfMethod> hashSet5 = new HashSet<EfMethod>();
            BitSet bitSet4 = new BitSet();
            BitSet bitSet5 = new BitSet();
            int n4 = 0;
            int n5 = 0;
            for (EfMethod efMethod : this.methods) {
                if (efMethod.isStaticOrInit()) {
                    ++n4;
                } else {
                    ++n5;
                }
                efMethod.verify(bl, hashSet5, bitSet4, bitSet5);
            }
            if (bitSet4.length() != n4) {
                throw new VerifierError("EfMethod.15");
            }
            if (bitSet5.length() != n5) {
                throw new VerifierError("EfMethod.15");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("EfClass.19", (Object)EfNames.prettyClass(this.thisName()), (Object)verifierError.getMessage());
        }
    }

    public int declaredInstanceSize() {
        int n = 0;
        for (EfField efField : this.fields) {
            int n2;
            if (efField.isStatic() || (n2 = efField.token + efField.wordSize()) <= n) continue;
            n = n2;
        }
        return n;
    }

    public String toString() {
        return EfNames.prettyClass(this.thisName());
    }

    void compareTo(EfClass efClass) {
        this.sameVersion = false;
        int n = this.accessFlag & 0x200;
        if (n == 0) {
            this.isInterface = false;
            if ((this.accessFlag & 0x10) < (efClass.accessFlag & 0x10)) {
                throw new VerifierError("RevisionError.4", this.thisName());
            }
        } else {
            this.isInterface = true;
        }
        if ((this.accessFlag & 0x400) < (efClass.accessFlag & 0x400)) {
            if (this.isInterface) {
                VerifierError.warning("RevisionWarning.2", this.thisName());
            } else {
                throw new VerifierError("RevisionError.5", this.thisName());
            }
        }
        if ((this.accessFlag & 0x1000) > (efClass.accessFlag & 0x1000)) {
            throw new VerifierError("RevisionError.41", this.thisName());
        }
        if ((this.accessFlag & 0x800) > (efClass.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.6", this.thisName());
        }
        this.compareCommon(efClass);
        this.checkNewMethods(efClass);
        this.checkNewFields(efClass);
    }

    void checkEquality(EfClass efClass) {
        this.sameVersion = true;
        int n = this.accessFlag & 0x200;
        if (n == 0 && (this.accessFlag & 0x10) != (efClass.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x400) != (efClass.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        if ((this.accessFlag & 0x800) != (efClass.accessFlag & 0x800)) {
            throw new VerifierError("RevisionError.7", this.thisName());
        }
        this.compareCommon(efClass);
    }

    void compareCommon(EfClass efClass) {
        if (this.token != efClass.token) {
            throw new VerifierError("RevisionError.8", this.thisName());
        }
        int n = this.accessFlag & 0x200;
        int n2 = efClass.accessFlag & 0x200;
        if (n != n2) {
            throw new VerifierError("RevisionError.9", this.thisName());
        }
        if (n == 0) {
            this.compareSuperClasses(efClass);
        }
        this.compareInterfaces(efClass);
        this.compareMethodLists(efClass);
        this.compareFieldLists(efClass);
    }

    private void compareSuperClasses(EfClass efClass) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        n2 = this.supers.length;
        n = efClass.supers.length;
        if (this.sameVersion && n2 != n) {
            throw new VerifierError("RevisionError.10", this.thisName());
        }
        for (int i = 0; i < n2; ++i) {
            bl = false;
            String string = this.superName(i);
            for (int j = 0; j < n; ++j) {
                String string2 = efClass.superName(j);
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new VerifierError("RevisionError.12", (Object)string, (Object)this.thisName());
        }
    }

    private void compareInterfaces(EfClass efClass) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        n2 = this.interfaces.length;
        n = efClass.interfaces.length;
        if (this.sameVersion && n2 != n) {
            throw new VerifierError("RevisionError.13", this.thisName());
        }
        for (int i = 0; i < n2; ++i) {
            bl = false;
            String string = this.interfaceName(i);
            for (int j = 0; j < n; ++j) {
                String string2 = efClass.interfaceName(j);
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.isInterface) {
                throw new VerifierError("RevisionError.14", (Object)string, (Object)this.thisName());
            }
            throw new VerifierError("RevisionError.15", (Object)string, (Object)this.thisName());
        }
    }

    private void compareMethodLists(EfClass efClass) {
        boolean bl = false;
        EfMethod efMethod = null;
        EfMethod efMethod2 = null;
        this.newMethodList = new Vector(efClass.methods.length);
        for (EfMethod efMethod3 : efClass.methods) {
            this.newMethodList.addElement(efMethod3);
        }
        int n = this.methods.length;
        int n2 = this.newMethodList.size();
        if (this.sameVersion && n != n2) {
            throw new VerifierError("RevisionError.16", this.thisName());
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            bl = false;
            efMethod = this.methods[i];
            String string = efMethod.name();
            String string2 = efMethod.sig();
            for (n3 = 0; n3 < this.newMethodList.size(); ++n3) {
                efMethod2 = this.newMethodList.get(n3);
                String string3 = efMethod2.name();
                String string4 = efMethod2.sig();
                if (!string.equals(string3) || !string2.equals(string4)) continue;
                bl = true;
                this.newMethodList.removeElementAt(n3);
                break;
            }
            if (bl) {
                if (this.sameVersion) {
                    efMethod.checkEquality(efMethod2);
                    continue;
                }
                n3 = (this.accessFlag & 0x10) > (efClass.accessFlag & 0x10) ? 1 : 0;
                efMethod.compareTo(efMethod2, n3 != 0);
                continue;
            }
            throw new VerifierError("RevisionError.18", (Object)string, (Object)this.thisName());
        }
    }

    private void checkNewMethods(EfClass efClass) {
        if (this.newMethodList.size() > 0) {
            if (this.isInterface) {
                EfMethod efMethod = this.newMethodList.get(0);
                throw new VerifierError("RevisionError.42", (Object)efMethod.name(), (Object)this.thisName());
            }
            if ((this.accessFlag & 0x10) > 0 || (efClass.accessFlag & 0x10) > 0) {
                return;
            }
            int n = this.newMethodList.size();
            for (int i = 0; i < n; ++i) {
                EfMethod efMethod = this.newMethodList.get(i);
                if ((efMethod.accessFlag & 8) != 0) continue;
                throw new VerifierError("RevisionError.19", (Object)efMethod.name(), (Object)this.thisName());
            }
        }
    }

    boolean compareFieldLists(EfClass efClass) {
        boolean bl = false;
        EfField efField = null;
        EfField efField2 = null;
        this.refExists = false;
        this.newFields = new Vector(efClass.fields.length);
        for (EfField efField3 : efClass.fields) {
            this.newFields.addElement(efField3);
        }
        int n = this.fields.length;
        int n2 = this.newFields.size();
        if (this.sameVersion) {
            if (n != n2) {
                throw new VerifierError("RevisionError.20", this.thisName());
            }
        } else if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            String string;
            bl = false;
            efField = this.fields[i];
            String string2 = efField.name();
            if (!this.refExists && (string = efField.sig()).indexOf("L") >= 0) {
                this.refExists = true;
            }
            for (int j = 0; j < this.newFields.size(); ++j) {
                efField2 = this.newFields.get(j);
                String string3 = efField2.name();
                if (!string2.equals(string3)) continue;
                bl = true;
                this.newFields.removeElementAt(j);
                break;
            }
            if (bl) {
                if (this.sameVersion) {
                    efField.checkEquality(efField2);
                    continue;
                }
                efField.compareTo(efField2);
                continue;
            }
            throw new VerifierError("RevisionError.21", (Object)string2, (Object)this.thisName());
        }
        return true;
    }

    void checkNewFields(EfClass efClass) {
        if (this.newFields.size() > 0 && this.refExists) {
            for (int i = 0; i < this.newFields.size(); ++i) {
                EfField efField = this.newFields.get(i);
                String string = efField.sig();
                if (string.indexOf("L") >= 0 || (efField.accessFlag & 8) > 0) continue;
                throw new VerifierError("RevisionError.22", (Object)efField.name(), (Object)this.thisName());
            }
        }
    }

    public EfField getFieldForName(String string) {
        for (EfField efField : this.fields) {
            if (!efField.name().equals(string)) continue;
            return efField;
        }
        return null;
    }

    public EfField getFieldForTokenAndFlag(int n, boolean bl) {
        for (EfField efField : this.fields) {
            if (efField.token != n || bl != efField.isStatic()) continue;
            return efField;
        }
        return null;
    }

    public String getConstantFieldNameByValueAndDesc(int n, String string) {
        for (EfField efField : this.fields) {
            if (efField.token != 255 || !efField.sig().equals(string) || efField.constantvalue().value() != n) continue;
            int n2 = this.thisName().lastIndexOf("/");
            return this.thisName().substring(n2 + 1) + "." + efField.name();
        }
        return null;
    }

    public EfMethod getMethodForTokenAndFlag(int n, boolean bl) {
        for (int i = 0; i < this.methods.length; ++i) {
            if (this.methods[i].token != n || bl != this.methods[i].isStaticOrInit()) continue;
            return this.methods[i];
        }
        return null;
    }

    public EfMethod getMethodForNameAndSig(String string, String string2) {
        for (EfMethod efMethod : this.methods) {
            if (!efMethod.name().equals(string) || !efMethod.sig().equals(string2)) continue;
            return efMethod;
        }
        return null;
    }

    public EfMethod getMethodFromSupers(int n, boolean bl) {
        for (int i = 0; i < this.supers.length; ++i) {
            EfMethod efMethod;
            int n2 = Classref.refForName(((EfConstant_ClassRef)this.ef.constantPool[this.supers[i]]).classname());
            EfClass efClass = Classref.toExportClass(n2);
            if (efClass == null || (efMethod = efClass.getMethodForTokenAndFlag(this.token, false)) == null) continue;
            return efMethod;
        }
        return null;
    }
}

