/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.StringUtils;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.ValidValues;
import com.sun.javacard.validator.XMLNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class JavaCardXML
extends PackageItem {
    public static final String XSD_NAME = "javacard-app_3_0.xsd";
    private String version;
    private Vector<String> dynamicallyLoadedClasses = new Vector();
    private Vector<String> shareableInterfaceClasses = new Vector();
    private Vector<String> userRoles = new Vector();
    private Vector<String> oncardClientRoles = new Vector();
    private Vector<String> cardHolderAutherizationRoles = new Vector();
    private File file;
    private XMLNode xmlNode;

    public JavaCardXML(File file) {
        this.file = file;
    }

    @Override
    public String getItemDisplayName() {
        String string = "";
        if (this.getParent() != null) {
            string = this.getParent().getItemDisplayName() + "/";
        }
        string = string + "javacard.xml";
        return string;
    }

    public void saveCanonicalizedTo(File file) throws Exception {
        String string = this.xmlNode.toString();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void initialize() {
        ArrayList<XMLNode> arrayList;
        XMLNode xMLNode;
        XMLNode xMLNode2;
        XMLNode xMLNode3;
        this.xmlNode = null;
        try {
            this.xmlNode = new XMLNode(this, this.file, XSD_NAME, "http://java.sun.com/xml/ns/javacard");
        }
        catch (Exception exception) {
            this.addError(ErrorKey.XMLParsingError, this.file.getName(), exception.getMessage());
            return;
        }
        this.version = this.xmlNode.getAttribute("version");
        if (!"3.0".equals(this.version)) {
            this.addError(ErrorKey.InvalidVersion, this.version);
        }
        if ((xMLNode3 = this.xmlNode.getChildNode("dynamically-loaded-classes")) != null) {
            this.gatherDynamicallyLoadedClassNames(xMLNode3);
        }
        if ((xMLNode2 = this.xmlNode.getChildNode("shareable-interface-classes")) != null) {
            this.gatherShareableInterfaceClassNames(xMLNode2);
        }
        if ((xMLNode = this.xmlNode.getChildNode("card-holder-authorization")) != null) {
            this.gatherCardHolderAutherizationRoles(xMLNode);
        }
        if ((arrayList = this.xmlNode.getChildNodes("security-role")) != null) {
            for (XMLNode xMLNode4 : arrayList) {
                this.gatherSecurityRoles(xMLNode4);
            }
        }
    }

    private void gatherSecurityRoles(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("role-name");
        String string = null;
        for (XMLNode xMLNode2 : arrayList) {
            string = xMLNode2.getAttribute("category");
            if (string == null) {
                this.addError(ErrorKey.MissingRoleNameCategory, new Object[0]);
                continue;
            }
            if ("USER".equals(string)) {
                this.userRoles.addElement(xMLNode2.getTextValue());
                continue;
            }
            if ("ON-CARD-CLIENT".equals(string)) {
                this.oncardClientRoles.addElement(xMLNode2.getTextValue());
                continue;
            }
            this.addError(ErrorKey.UnknownRoleNameCategory, string);
        }
    }

    private void gatherCardHolderAutherizationRoles(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("role-name");
        for (XMLNode xMLNode2 : arrayList) {
            this.cardHolderAutherizationRoles.addElement(xMLNode2.getTextValue());
        }
    }

    private void gatherShareableInterfaceClassNames(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("class");
        for (XMLNode xMLNode2 : arrayList) {
            this.shareableInterfaceClasses.addElement(xMLNode2.getAttribute("name"));
        }
    }

    private void gatherDynamicallyLoadedClassNames(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("class");
        for (XMLNode xMLNode2 : arrayList) {
            this.dynamicallyLoadedClasses.addElement(xMLNode2.getAttribute("name"));
        }
    }

    @Override
    public void processInternal() {
        Module module = (Module)this.getParent();
        for (String object2 : this.dynamicallyLoadedClasses) {
            if (!StringUtils.isValidClassName(object2)) {
                this.addError(ErrorKey.IllegalClassName, object2, "dynamically-loaded-classes");
                continue;
            }
            if (module.hasClass(object2)) continue;
            this.addWarning(ErrorKey.DeclaredClassDoesNotExists, object2, "dynamically-loaded-classes");
        }
        for (String string : this.shareableInterfaceClasses) {
            if (!StringUtils.isValidClassName(string)) {
                this.addError(ErrorKey.IllegalClassName, string, "shareable-interface-class");
                continue;
            }
            if (module.hasClass(string)) {
                try {
                    if (!module.isInterface(string)) {
                        this.addError(ErrorKey.DeclaredClassIsNotInterface, string, "shareable-interface-class");
                        continue;
                    }
                    if (!module.isShareableInterface(string)) {
                        this.addError(ErrorKey.DeclaredClassIsNotShareableInterface, string, "shareable-interface-class");
                        continue;
                    }
                    if (module.isPublic(string)) continue;
                    this.addWarning(ErrorKey.DeclaredClassIsNotPublic, string, "shareable-interface-class");
                }
                catch (Exception exception) {}
                continue;
            }
            this.addWarning(ErrorKey.DeclaredClassDoesNotExists, string, "shareable-interface-class");
        }
        for (String string : this.oncardClientRoles) {
            if (ValidValues.isValidNNMToken(string)) continue;
            this.addError(ErrorKey.RoleNameNotNMTOKEN, string);
        }
        for (String string : this.userRoles) {
            if (ValidValues.isValidNNMToken(string)) continue;
            this.addError(ErrorKey.RoleNameNotNMTOKEN, string);
        }
        for (String string : this.cardHolderAutherizationRoles) {
            if (this.userRoles.contains(string)) continue;
            this.addError(ErrorKey.InvalidRoleNameInCHA, string);
        }
        ModuleJCRD moduleJCRD = module.getJCRD();
        Vector<String> vector = moduleJCRD.getOncardClientRoleList();
        Vector<String> vector2 = moduleJCRD.getUserRoleList();
        for (String string : this.oncardClientRoles) {
            if (vector.contains(string)) continue;
            this.addError(ErrorKey.ClientRoleNotInJCRD, string);
        }
        for (String string : this.userRoles) {
            if (vector2.contains(string)) continue;
            this.addError(ErrorKey.UserRoleNotInJCRD, string);
        }
        this.checkProxies();
    }

    public Vector<String> getOncardClientRoles() {
        return this.oncardClientRoles;
    }

    public Vector<String> getUserRoles() {
        return this.userRoles;
    }

    void checkProxies() {
        Module module = (Module)this.getParent();
        String string = null;
        if (module instanceof ClassicModule) {
            string = ((ClassicModule)module).getAppletXML().getPackageName();
        }
        if (string != null) {
            String string2 = string + ".proxy";
            Vector<String> vector = module.getClasses().getNamesOfClassesInPackage(string2);
            for (String string3 : vector) {
                int n;
                String string4 = string3.substring(n = string3.lastIndexOf(".") + 1);
                if (!string4.startsWith("Proxy") || this.dynamicallyLoadedClasses.contains(string3)) continue;
                this.addError(ErrorKey.proxyClassNotListedAsDLC, string3);
            }
        }
    }
}

