/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.OffsetAndLength;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeBase;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Iterator;
import java.util.TreeSet;

class StaticFieldComponent
extends Safeptr {
    private Safeptr endInitArray;
    private TreeSet allStaticFields;

    StaticFieldComponent(byte[] byArray) {
        super(byArray, "StaticField");
    }

    int imageSize() {
        return this.u2(0);
    }

    int referenceCount() {
        return this.u2(2);
    }

    int arrayInitCount() {
        return this.u2(4);
    }

    InitializedArray arrayInit() {
        return new InitializedArray(this.offset(6));
    }

    int defaultValueCount() {
        return this.endInitArray.u2(0);
    }

    int nonDefaultValueCount() {
        return this.endInitArray.u2(2);
    }

    Safeptr nonDefaultValuesStaticfield() {
        return this.endInitArray.offset(4);
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("StaticFieldComponent.100");
        }
        this.allStaticFields = new TreeSet();
        InitializedArray initializedArray = this.arrayInit();
        int n = this.arrayInitCount();
        while (n > 0) {
            initializedArray.next();
            --n;
        }
        this.endInitArray = initializedArray;
        if (this.arrayInitCount() > this.referenceCount()) {
            throw new VerifierError("StaticFieldComponent.1");
        }
        if (this.imageSize() != this.referenceCount() * 2 + this.defaultValueCount() + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.2");
        }
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        int n2 = Cap.Descriptor.classCount();
        while (n2 > 0) {
            if ((classDescriptor.flags() & 0x40) == 0) {
                int n3 = 0;
                while (n3 < classDescriptor.fieldCount()) {
                    FieldDescriptor fieldDescriptor = classDescriptor.fieldDescr(n3);
                    this.verifyField(fieldDescriptor);
                    ++n3;
                }
            }
            --n2;
            classDescriptor.next();
        }
        this.verifyOverlap();
        this.allStaticFields = null;
        if (this.size() != this.endInitArray.ofs + 4 + this.nonDefaultValueCount()) {
            throw new VerifierError("StaticFieldComponent.17");
        }
    }

    private void verifyField(FieldDescriptor fieldDescriptor) {
        int n;
        if ((fieldDescriptor.flags() & 8) == 0) {
            return;
        }
        int n2 = fieldDescriptor.staticRef();
        Type type = Type.parseField(fieldDescriptor.type());
        if (n2 < this.referenceCount() * 2) {
            n = 2;
            if ((n2 & 1) != 0) {
                throw new VerifierError("StaticFieldComponent.3");
            }
            if (n2 < this.arrayInitCount()) {
                int n3;
                Type type2;
                InitializedArray initializedArray = this.arrayInit();
                int n4 = 0;
                while (n4 < n2) {
                    initializedArray.next();
                    n4 += 2;
                }
                switch (initializedArray.type()) {
                    case 2: {
                        type2 = Type.BooleanArray;
                        n3 = 1;
                        break;
                    }
                    case 3: {
                        type2 = Type.ByteArray;
                        n3 = 1;
                        break;
                    }
                    case 4: {
                        type2 = Type.ShortArray;
                        n3 = 2;
                        break;
                    }
                    case 5: {
                        type2 = Type.IntArray;
                        n3 = 4;
                        Cap.Header.useInts();
                        break;
                    }
                    default: {
                        throw new VerifierError("StaticFieldComponent.4", initializedArray.type());
                    }
                }
                if (!type.equals(type2)) {
                    if ((fieldDescriptor.type() & 0x8000) == 0) {
                        TypeClass typeClass = (TypeClass)type;
                        if (typeClass.classref != Classref.Object) {
                            throw new VerifierError("StaticFieldComponent.5", (Object)type, (Object)type2);
                        }
                    } else {
                        throw new VerifierError("StaticFieldComponent.5", (Object)type, (Object)type2);
                    }
                }
                if (initializedArray.count() % n3 != 0) {
                    throw new VerifierError("StaticFieldComponent.13", initializedArray.count(), n3);
                }
                if (initializedArray.count() / n3 > Short.MAX_VALUE) {
                    throw new VerifierError("StaticFieldComponent.16", initializedArray.count() / n3);
                }
                if (initializedArray.type() == 2) {
                    int n5 = 0;
                    while (n5 < initializedArray.count()) {
                        int n6 = initializedArray.values().u1(n5);
                        if (n6 != 0 && n6 != 1) {
                            throw new VerifierError("StaticFieldComponent.14", n6);
                        }
                        ++n5;
                    }
                }
            } else if (!(type instanceof TypeClass) && !(type instanceof TypeArray)) {
                throw new VerifierError("StaticFieldComponent.6", (Object)type, n2);
            }
        } else {
            if (!(type instanceof TypeBase)) {
                throw new VerifierError("StaticFieldComponent.7", (Object)type, n2);
            }
            switch (((TypeBase)type).kind) {
                case 2: 
                case 3: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                default: {
                    throw new VerifierError("StaticFieldComponent.8", (Object)type, n2);
                }
            }
            if (((TypeBase)type).kind == 2 && n2 >= this.imageSize() - this.nonDefaultValueCount()) {
                int n7 = n2 - (this.imageSize() - this.nonDefaultValueCount());
                int n8 = this.nonDefaultValuesStaticfield().u1(n7);
                if (n8 != 0 && n8 != 1) {
                    throw new VerifierError("StaticFieldComponent.15", n8);
                }
            }
        }
        this.allStaticFields.add(new OffsetAndLength(n2, n));
    }

    private void verifyOverlap() {
        int n = 0;
        Iterator iterator = this.allStaticFields.iterator();
        while (iterator.hasNext()) {
            OffsetAndLength offsetAndLength = (OffsetAndLength)iterator.next();
            if (offsetAndLength.offset < n) {
                throw new VerifierError("StaticFieldComponent.9", n);
            }
            if (offsetAndLength.offset > n) {
                throw new VerifierError("StaticFieldComponent.10", n);
            }
            n += offsetAndLength.length;
        }
        if (n > this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.11");
        }
        if (n < this.imageSize()) {
            throw new VerifierError("StaticFieldComponent.12");
        }
    }
}

