/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.impl;

import com.sun.javacard.impl.AppTableEntry;
import com.sun.javacard.impl.AppletInfo;
import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageEntry;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.AppletEvent;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.MultiSelectable;
import javacard.framework.SystemException;
import javacard.framework.Util;

public class AppletMgr {
    public static final byte DELETE_APPLETS = -60;
    public static final byte APP_NULL = -1;
    public static final byte APP_FIRST = 0;
    public static final byte APPS_MAX = 16;
    public static final byte NO_APPLET_BEING_PROCESSED = -1;
    public static final byte APPLET_INDEX = 3;
    static final byte MAX_APPLETS_TO_BE_DELETED = 8;
    private static final byte CHANNEL_CLOSED = 0;
    private static final byte CHANNEL_DISABLED = 1;
    private static final byte CHANNEL_OPEN = 2;
    private static final byte CHANNEL_OPEN_MS = 3;
    private static final byte CHANNEL_MS_MASK = 1;
    private static final byte CHANNEL_OPEN_MASK = 2;
    static AppTableEntry[] theAppTable;
    static byte[] theAppState;
    public static byte currentAppletIndex;
    private static byte[] AppletMgrBuffer;
    private static byte[] currentAppAID;
    private static byte appInProcess;
    public static boolean installTransactionFlag;

    AppletMgr() {
    }

    static byte addAppletEntry(byte pkgContext) {
        if (theAppTable == null) {
            theAppTable = new AppTableEntry[16];
            theAppState = new byte[16];
            AppletMgrBuffer = JCSystem.makeTransientByteArray((short)25, (byte)2);
            currentAppAID = new byte[16];
            NativeMethods.setJCREentry(currentAppAID, false);
        }
        byte i2 = 0;
        while (i2 < 16) {
            if (theAppTable[i2] == null) {
                AppletMgr.theAppTable[i2] = new AppTableEntry();
                AppletMgr.theAppTable[i2].theContext = pkgContext;
                appInProcess = i2;
                return i2;
            }
            i2 = (byte)(i2 + 1);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AID createApplet(byte[] bArray, short bOffset, byte bLength, byte pkgContext) {
        byte appID = 0;
        byte currentChannel = 0;
        byte myContextId = 0;
        boolean isMyContextMultiSelected = false;
        try {
            short m_paramOffset;
            JCSystem.beginTransaction();
            installTransactionFlag = true;
            appID = AppletMgr.addAppletEntry(pkgContext);
            if (appID == -1) {
                Object var11_8 = null;
                return var11_8;
            }
            currentChannel = NativeMethods.getCurrentlySelectedChannel();
            byte contextId = PrivAccess.getContextId(appID);
            myContextId = NativeMethods.getChannelContext(currentChannel);
            boolean bl = isMyContextMultiSelected = NativeMethods.getChannelStatus(currentChannel) == 3;
            if ((NativeMethods.getContextStatus(contextId) & 1) == 1 && contextId != 0) {
                ISOException.throwIt((short)25682);
            }
            short s2 = m_paramOffset = (short)(bOffset + (short)bLength);
            m_paramOffset = (short)(m_paramOffset + 1);
            byte m_paramLength = bArray[s2];
            if (m_paramLength == 0) {
                m_paramLength = 3;
                bArray[(byte)(m_paramOffset + 2)] = 0;
                bArray[(byte)(m_paramOffset + 1)] = 0;
                bArray[m_paramOffset] = 0;
            }
            short theAddress = PackageMgr.getAppletInfo(bArray, bOffset, bLength, (byte)1);
            boolean isMultiSelectable = (NativeMethods.getContextStatus(contextId) & 1) == 0;
            NativeMethods.clearTransientObjs(currentChannel, (byte)2);
            if (myContextId != 15) {
                NativeMethods.setChannelContext(currentChannel, (byte)15, false);
            }
            NativeMethods.setChannelContext(currentChannel, contextId, isMultiSelectable);
            NativeMethods.callInstall(theAddress, contextId, bArray, m_paramOffset, m_paramLength, PackageMgr.getPkgIdForContext(pkgContext));
        }
        finally {
            boolean wasCreationSuccessful = true;
            installTransactionFlag = false;
            if (appInProcess != -1) {
                JCSystem.abortTransaction();
                NativeMethods.clearInvalidTransientReferences();
                wasCreationSuccessful = false;
            }
            NativeMethods.clearTransientObjs(currentChannel, (byte)2);
            NativeMethods.setChannelContext(currentChannel, (byte)15, false);
            if (myContextId != 15) {
                NativeMethods.setChannelContext(currentChannel, myContextId, isMyContextMultiSelected);
            }
            if (wasCreationSuccessful) {
                return PrivAccess.getPrivAccess().getAID(appID);
            }
            return null;
        }
    }

    public static byte findApplet(byte[] bArray, short offset, byte length) {
        byte i2 = 0;
        while (i2 < 16) {
            AppTableEntry theEntry = theAppTable[i2];
            if (theEntry != null && theEntry.theAID != null && theEntry.theAID.equals(bArray, offset, length)) {
                return i2;
            }
            i2 = (byte)(i2 + 1);
        }
        return -1;
    }

    static byte findApplet(AID theAID) {
        byte i2 = 0;
        while (i2 < 16) {
            AppTableEntry theEntry = theAppTable[i2];
            if (theEntry != null && theEntry.theAID != null && theEntry.theAID.equals(theAID)) {
                return i2;
            }
            i2 = (byte)(i2 + 1);
        }
        return -1;
    }

    static void register(Applet theApplet, AID theAID) {
        byte appID = PrivAccess.getPreviousAppID();
        if (AppletMgr.theAppTable[appID].theAID != null) {
            SystemException.throwIt((short)4);
        }
        if (theAID == null) {
            byte pkgId = 0;
            byte pkgContext = AppletMgr.theAppTable[appID].theContext;
            pkgId = PackageMgr.getPkgIdForContext(pkgContext);
            theAID = pkgId == PackageMgr.g_packageInProcess ? PackageMgr.g_newPackage.applets[AppletMgr.currentAppletIndex].theClassAID : PackageMgr.f_pkgTable[pkgId].applets[AppletMgr.currentAppletIndex].theClassAID;
        }
        if (AppletMgr.findApplet(theAID) != -1) {
            SystemException.throwIt((short)4);
        }
        AppletMgr.theAppTable[appID].theApplet = theApplet;
        AppletMgr.theAppTable[appID].theAID = theAID;
        AppletMgr.commit(appID);
    }

    public static void setCurrentAppletIndex(byte[] bArray, short offset, byte length, byte pkgId) {
        currentAppletIndex = (byte)-1;
        PackageEntry pe = PackageMgr.g_packageInProcess == pkgId && PackageMgr.g_newPackage != null ? PackageMgr.g_newPackage : PackageMgr.f_pkgTable[pkgId];
        byte i2 = 0;
        while (i2 < pe.appletCount) {
            AppletInfo ai2 = pe.applets[i2];
            if (ai2.theClassAID.equals(bArray, offset, length)) {
                currentAppletIndex = i2;
                return;
            }
            i2 = (byte)(i2 + 1);
        }
    }

    public static void commit(byte appID) {
        AppletMgr.theAppState[appID] = 1;
        appInProcess = (byte)-1;
        PackageMgr.commit();
        installTransactionFlag = false;
        JCSystem.commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callUninstallMethods(byte[] contexts, byte appCount) throws ISOException {
        byte appID = 0;
        byte channelId = APDU.getCLAChannel();
        byte i2 = 0;
        while (i2 < appCount) {
            if ((NativeMethods.getContextStatus(contexts[i2]) & 1) == 1) {
                ISOException.throwIt((short)25682);
            }
            i2 = (byte)(i2 + 1);
        }
        NativeMethods.clearTransientObjs(channelId, (byte)2);
        byte i3 = 0;
        while (i3 < appCount) {
            appID = (byte)(contexts[i3] & 0xF);
            Applet theApplet = AppletMgr.theAppTable[appID].theApplet;
            if (theApplet instanceof AppletEvent) {
                NativeMethods.setChannelContext(channelId, (byte)15, false);
                NativeMethods.setChannelContext(channelId, contexts[i3], theApplet instanceof MultiSelectable);
                try {
                    ((AppletEvent)((Object)theApplet)).uninstall();
                }
                catch (Throwable t2) {
                }
                finally {
                    NativeMethods.clearTransientObjs(channelId, (byte)2);
                    NativeMethods.setChannelContext(channelId, (byte)15, false);
                    NativeMethods.setChannelContext(channelId, (byte)0, false);
                    if (JCSystem.getTransactionDepth() != 0) {
                        JCSystem.abortTransaction();
                    }
                }
            }
            i3 = (byte)(i3 + 1);
        }
    }

    public static byte getAppletsForPackage(byte[] appIds, byte offset, byte pkgId) {
        byte pkgContext = PackageMgr.getPkgContext(pkgId);
        byte count = 0;
        int i2 = 0;
        while (i2 < 16) {
            if (theAppTable[i2] != null && AppletMgr.theAppTable[i2].theContext == pkgContext) {
                if (appIds != null) {
                    byte by = offset;
                    offset = (byte)(offset + 1);
                    appIds[by] = (byte)(pkgContext << 4 | i2);
                }
                count = (byte)(count + 1);
            }
            i2 = (byte)(i2 + 1);
        }
        return count;
    }

    public static void handleAppletDeletion(APDU apdu) {
        int aidCount = 0;
        int aidLengthRead = 0;
        int aidlength = -1;
        int aidAndIdBufferOffset = 0;
        byte[] buffer = apdu.getBuffer();
        byte count = buffer[2];
        try {
            short Lc;
            if (count < 1 || count > 8) {
                ISOException.throwIt((short)27270);
            }
            if ((Lc = (short)(buffer[4] & 0xFF)) < 7 || Lc > 136) {
                ISOException.throwIt((short)26368);
            }
            short bytesRead = apdu.setIncomingAndReceive();
            Util.arrayFillNonAtomic(AppletMgrBuffer, (short)0, (short)AppletMgrBuffer.length, (byte)0);
            while (bytesRead > 0) {
                short i2 = 5;
                while (i2 < (short)(bytesRead + 5)) {
                    if (aidlength == -1) {
                        aidlength = buffer[i2];
                    } else {
                        int n2 = aidAndIdBufferOffset;
                        aidAndIdBufferOffset = (short)(aidAndIdBufferOffset + 1);
                        AppletMgr.AppletMgrBuffer[n2] = buffer[i2];
                        aidLengthRead = (byte)(aidLengthRead + 1);
                    }
                    if (aidLengthRead == aidlength) {
                        byte appContext = AppletMgr.findApplet(AppletMgrBuffer, (short)aidCount, (byte)aidlength);
                        if (appContext == -1) {
                            ISOException.throwIt((short)25667);
                        }
                        AppletMgr.AppletMgrBuffer[aidCount] = appContext = (byte)((byte)(AppletMgr.theAppTable[appContext].theContext << 4) | appContext);
                        aidLengthRead = 0;
                        aidCount = (byte)(aidCount + 1);
                        aidAndIdBufferOffset = (short)aidCount;
                        aidlength = -1;
                    }
                    i2 = (short)(i2 + 1);
                }
                bytesRead = apdu.receiveBytes((short)5);
            }
            Util.arrayCopyNonAtomic(AppletMgrBuffer, (short)0, buffer, (short)0, count);
            AppletMgr.callUninstallMethods(buffer, count);
            JCSystem.beginTransaction();
            GarbageCollector.deleteApplets(buffer, count);
            JCSystem.commitTransaction();
        }
        catch (ISOException e2) {
            if (JCSystem.getTransactionDepth() != 0) {
                JCSystem.abortTransaction();
            }
            ISOException.throwIt(e2.getReason());
        }
        catch (Exception e3) {
            if (JCSystem.getTransactionDepth() != 0) {
                JCSystem.abortTransaction();
            }
            ISOException.throwIt((short)25636);
        }
    }

    public static void removeApplet(byte appletIndex) {
        AppletMgr.theAppState[appletIndex] = 0;
        AppletMgr.theAppTable[appletIndex] = null;
    }

    static {
        currentAppletIndex = (byte)-1;
        appInProcess = (byte)-1;
        installTransactionFlag = false;
    }
}

