/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import java.rmi.Remote;
import javacard.framework.SystemException;

public class CardRemoteObject
implements Remote {
    private static final short MAX_OBJECTS = 16;
    private static short[] array;

    public CardRemoteObject() {
        CardRemoteObject.export(this);
    }

    public static void export(Remote obj) throws SecurityException {
        if (array == null) {
            array = new short[16];
            NativeMethods.setJCREentry((Object)array, (boolean)false);
            GarbageCollector.setExpObjArray((short[])array);
        }
        if (obj == null) {
            return;
        }
        short id = NativeMethods.getObjectID((Object)obj);
        CardRemoteObject.export(id);
    }

    public static void unexport(Remote obj) throws SecurityException {
        if (obj == null) {
            return;
        }
        short objID = NativeMethods.getObjectID((Object)obj);
        CardRemoteObject.unexport(objID);
    }

    private static void unexport(short objID) throws SecurityException {
        NativeMethods.checkAccess((short)objID);
        if (array == null) {
            return;
        }
        int i = 0;
        while (i < 16) {
            if (array[i] == objID) {
                CardRemoteObject.array[i] = 0;
            }
            i = (short)(i + 1);
        }
    }

    private static void export(short objID) throws SecurityException {
        NativeMethods.checkAccess((short)objID);
        int i = 0;
        while (i < 16) {
            if (array[i] == 0) {
                CardRemoteObject.array[i] = objID;
                return;
            }
            i = (short)(i + 1);
        }
        SystemException.throwIt((short)5);
    }

    static boolean isExported(Remote obj) throws SecurityException {
        if (obj == null) {
            return true;
        }
        short objID = NativeMethods.getObjectID((Object)obj);
        return CardRemoteObject.isExported(objID);
    }

    private static boolean isExported(short objID) throws SecurityException {
        NativeMethods.checkAccess((short)objID);
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < 16) {
            if (array[i] == objID) {
                return true;
            }
            i = (short)(i + 1);
        }
        return false;
    }
}

