/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.framework.service.Service;
import javacard.framework.service.ServiceException;

public class Dispatcher {
    private Service[] services;
    private byte[] servicePhases;
    private short numServices;
    public static final byte PROCESS_NONE = 0;
    public static final byte PROCESS_INPUT_DATA = 1;
    public static final byte PROCESS_COMMAND = 2;
    public static final byte PROCESS_OUTPUT_DATA = 3;

    public Dispatcher(short maxServices) throws ServiceException {
        if (maxServices < 0) {
            ServiceException.throwIt((short)1);
        }
        this.services = new Service[maxServices];
        this.servicePhases = new byte[maxServices];
        this.numServices = 0;
    }

    public void addService(Service service, byte phase) throws ServiceException {
        if (phase < 0 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        if (service == null) {
            ServiceException.throwIt((short)1);
        }
        short i = 0;
        while (i < this.numServices) {
            if (this.services[i] == service && this.servicePhases[i] == phase) {
                return;
            }
            i = (short)(i + 1);
        }
        if (this.numServices >= this.services.length) {
            ServiceException.throwIt((short)2);
        }
        boolean inTransaction = false;
        if (JCSystem.getTransactionDepth() == 0) {
            inTransaction = true;
            JCSystem.beginTransaction();
        }
        this.servicePhases[this.numServices] = phase;
        short s = this.numServices;
        this.numServices = (short)(s + 1);
        this.services[s] = service;
        if (inTransaction) {
            JCSystem.commitTransaction();
        }
    }

    public void removeService(Service service, byte phase) throws ServiceException {
        if (service == null) {
            ServiceException.throwIt((short)1);
        }
        if (phase < 0 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        short i = 0;
        while (i < this.numServices) {
            if (this.services[i] == service && this.servicePhases[i] == phase) {
                boolean inTransaction = false;
                if (JCSystem.getTransactionDepth() == 0) {
                    inTransaction = true;
                    JCSystem.beginTransaction();
                }
                short j = i;
                while (j < (short)(this.numServices - 1)) {
                    this.services[j] = this.services[(short)(j + 1)];
                    this.servicePhases[j] = this.servicePhases[(short)(j + 1)];
                    j = (short)(j + 1);
                }
                this.numServices = (short)(this.numServices - 1);
                if (inTransaction) {
                    JCSystem.commitTransaction();
                }
                return;
            }
            i = (short)(i + 1);
        }
    }

    public Exception dispatch(APDU command, byte phase) throws ServiceException {
        if (phase < 1 || phase > 3) {
            ServiceException.throwIt((short)1);
        }
        byte[] buffer = command.getBuffer();
        try {
            short i = 0;
            while (i < this.numServices) {
                if (phase > 1 || this.servicePhases[i] == 1 && this.services[i].processDataIn(command)) break;
                i = (short)(i + 1);
            }
            short i2 = 0;
            while (i2 < this.numServices) {
                if (phase > 2 || this.servicePhases[i2] == 2 && this.services[i2].processCommand(command)) break;
                i2 = (short)(i2 + 1);
            }
            if (command.getCurrentState() < 3) {
                return null;
            }
            short i3 = 0;
            while (i3 < this.numServices) {
                if (this.servicePhases[i3] != 3 || !this.services[i3].processDataOut(command)) {
                    i3 = (short)(i3 + 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return e;
        }
        short outLength = (short)(buffer[4] & 0xFF);
        command.setOutgoingLength(outLength);
        command.sendBytes((short)5, outLength);
        ISOException.throwIt(Util.getShort(buffer, (short)2));
        return null;
    }

    public void process(APDU command) throws ISOException {
        Exception e = this.dispatch(command, (byte)1);
        if (e == null) {
            ISOException.throwIt((short)27904);
        } else {
            ISOException.throwIt((short)28416);
        }
    }
}

