/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

public class Apdu {
    public static final int CLA = 0;
    public static final int INS = 1;
    public static final int P1 = 2;
    public static final int P2 = 3;
    public static final int P3 = 4;
    public static final int CASE_1 = 1;
    public static final int CASE_2S = 2;
    public static final int CASE_3S = 3;
    public static final int CASE_4S = 4;
    public static final int CASE_2E = 5;
    public static final int CASE_3E = 6;
    public static final int CASE_4E = 7;
    public static final int LOGICAL_CHN_MASK = 3;
    public static final int APDU_TYPE_MASK = 240;
    static final int CMD_HDR_BYTES = 4;
    public byte[] command = new byte[5];
    public int Lc = 0;
    public byte[] dataIn = null;
    public int Le = 0;
    public byte[] dataOut = null;
    public byte[] sw1sw2 = new byte[2];

    public byte[] getCommand() {
        return this.command;
    }

    public byte[] getDataIn() {
        return this.dataIn;
    }

    public void setDataIn(byte[] byArray) {
        this.dataIn = byArray;
        this.Lc = byArray == null ? 0 : byArray.length;
    }

    public void setDataIn(byte[] byArray, int n) {
        this.dataIn = byArray;
        this.Lc = n;
    }

    public int getLc() {
        return this.Lc;
    }

    public void setDataOut(byte[] byArray) {
        this.dataOut = byArray;
        this.Le = byArray == null ? 0 : byArray.length;
    }

    public void setDataOut(byte[] byArray, int n) {
        this.dataOut = byArray;
        if (byArray == null && n > 0) {
            throw new IllegalArgumentException();
        }
        if (byArray.length < n) {
            throw new IllegalArgumentException();
        }
        this.Le = n;
    }

    public int getLe() {
        return this.Le;
    }

    public byte[] getDataOut() {
        return this.dataOut;
    }

    public byte[] getSw1Sw2() {
        return this.sw1sw2;
    }

    public int getStatus() {
        return ((this.sw1sw2[0] & 0xFF) << 8 | this.sw1sw2[1] & 0xFF) & 0xFFFF;
    }

    public int getCase() {
        if (this.Lc == 0 && this.Le >= 0 && this.Le < 256) {
            return 2;
        }
        if (this.Lc == 0 && this.Le > 256) {
            return 5;
        }
        if (this.Lc > 256 && this.Le == 0) {
            return 6;
        }
        if (this.Lc > 0 && this.Lc <= 255 && this.Le >= 0 && this.Le < 256) {
            return 4;
        }
        return 7;
    }

    public byte getChannelInfo() {
        byte by = (byte)(this.command[0] & 3);
        byte by2 = (byte)(this.command[0] & 0xFFFFFFF0);
        if (by2 != 0 && by2 != -128 && by2 != -112 && by2 != -96) {
            return 0;
        }
        return by;
    }

    public byte[] getCommandApduBytes() {
        byte[] byArray = new byte[5 + this.Lc + 1];
        System.arraycopy(this.command, 0, byArray, 0, 4);
        byArray[4] = (byte)this.Lc;
        if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, byArray, 5, this.Lc);
        }
        byArray[5 + this.Lc] = (byte)this.Le;
        return byArray;
    }

    public byte[] getResponseApduBytes() {
        byte[] byArray = new byte[5 + this.Lc + 1 + this.Le + 2];
        System.arraycopy(this.command, 0, byArray, 0, 4);
        byArray[this.command.length] = (byte)this.Lc;
        if (this.Lc != 0) {
            System.arraycopy(this.dataIn, 0, byArray, 5, this.Lc);
        }
        byArray[this.command.length + 1 + this.Lc] = (byte)this.Le;
        if (this.dataOut.length != 0) {
            System.arraycopy(this.dataOut, 0, byArray, 5 + this.Lc + 1, this.Le);
        }
        System.arraycopy(this.sw1sw2, 0, byArray, byArray.length - 2, 2);
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CLA: " + Apdu.byteHexString(this.command[0]) + ", ");
        stringBuffer.append("INS: " + Apdu.byteHexString(this.command[1]) + ", ");
        stringBuffer.append("P1: " + Apdu.byteHexString(this.command[2]) + ", ");
        stringBuffer.append("P2: " + Apdu.byteHexString(this.command[3]) + ", ");
        stringBuffer.append("Lc: " + Apdu.byteHexString(this.Lc));
        int n = 0;
        while (n < this.Lc) {
            stringBuffer.append(", " + Apdu.byteHexString(this.dataIn[n]));
            ++n;
        }
        stringBuffer.append(", Le: " + Apdu.byteHexString(this.Le));
        if (this.dataOut != null) {
            int n2 = 0;
            while (n2 < this.Le) {
                if (n2 >= this.dataOut.length) break;
                stringBuffer.append(", " + Apdu.byteHexString(this.dataOut[n2]));
                ++n2;
            }
        }
        stringBuffer.append(", SW1: " + Apdu.byteHexString(this.sw1sw2[0]));
        stringBuffer.append(", SW2: " + Apdu.byteHexString(this.sw1sw2[1]));
        return stringBuffer.toString();
    }

    private static String byteHexString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0xFF) < 16) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(n & 0xFF));
        return stringBuffer.toString();
    }
}

