/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadPCSCClient;
import com.sun.javacard.apduio.CadT0Client;
import com.sun.javacard.apduio.CadT1Client;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;

public abstract class CadDevice {
    protected static ResourceBundle _messages = ResourceBundle.getBundle("com/sun/javacard/apduio/MessagesBundle");
    protected InputStream in;
    protected OutputStream out;
    protected boolean debug = false;
    public static final byte PROTOCOL_T0 = 0;
    public static final byte PROTOCOL_T1 = 1;
    public static final byte PROTOCOL_TCL = 91;
    public static final byte PROTOCOL_PCSC = -85;
    protected byte deviceProtocol;

    protected CadDevice(byte devProtocolType, InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        int dbgLevel = Integer.getInteger("apduIODebug", 0);
        if ((dbgLevel & 1) == 1) {
            this.debug = true;
        }
        this.deviceProtocol = devProtocolType;
    }

    protected CadDevice(byte devProtocolType) {
        int dbgLevel = Integer.getInteger("apduIODebug", 0);
        if ((dbgLevel & 1) == 1) {
            this.debug = true;
        }
        this.deviceProtocol = devProtocolType;
    }

    public byte getDeviceProtocol() {
        return this.deviceProtocol;
    }

    public static CadClientInterface getCadClientInstance(byte protocolType, InputStream in, OutputStream out) {
        CadDevice theCad;
        switch (protocolType) {
            case 0: {
                theCad = new CadT0Client(in, out);
                break;
            }
            case 1: {
                theCad = new CadT1Client(in, out);
                break;
            }
            case -85: {
                theCad = new CadPCSCClient(0);
                break;
            }
            default: {
                return null;
            }
        }
        return theCad;
    }

    public static CadClientInterface getPCSCClientInstance(int readerNumber) {
        return new CadPCSCClient(readerNumber);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.out.flush();
        this.out.close();
        this.out = null;
    }
}

