/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JCArithmeticInstr;
import com.sun.javacard.components.caputils.instructions.JCConstInstr;
import com.sun.javacard.components.caputils.instructions.JCControlInstr;
import com.sun.javacard.components.caputils.instructions.JCFieldAccessInstr;
import com.sun.javacard.components.caputils.instructions.JCInvokeInstr;
import com.sun.javacard.components.caputils.instructions.JCLoadInstr;
import com.sun.javacard.components.caputils.instructions.JCObjectInstr;
import com.sun.javacard.components.caputils.instructions.JCPushInstr;
import com.sun.javacard.components.caputils.instructions.JCStackInstr;
import com.sun.javacard.components.caputils.instructions.JCStoreInstr;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import java.util.Vector;

public class BCConverter {
    public static Vector<Instruction> convert(MethodDescriptor md, boolean isExtended, ClassConstantPool cp) {
        MethodInfo mi = Cap.getMethod().methodInfo(md.methodOffset());
        Safeptr jcByteCode = isExtended ? mi.bytecodeExtended() : mi.bytecodeCompact();
        Instr[] instrs = Instr.instrsBetween(jcByteCode, md.bytecodeCount());
        Vector<Instruction> byteCodeVector = new Vector<Instruction>();
        for (int i = 0; i < instrs.length; i += instrs[i].length()) {
            Instruction javaInstr = null;
            switch (instrs[i].opcode) {
                case 0: {
                    javaInstr = new Instruction(instrs[i], new JavaInstruction(0));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    javaInstr = new JCConstInstr(instrs[i]);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    javaInstr = new JCPushInstr(instrs[i], cp);
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    javaInstr = new JCLoadInstr(instrs[i]);
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    javaInstr = new JCStoreInstr(instrs[i]);
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    javaInstr = new JCStackInstr(instrs[i]);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 150: 
                case 151: {
                    javaInstr = new JCArithmeticInstr(instrs[i]);
                    break;
                }
                case 95: {
                    byteCodeVector.add(new JCControlInstr(instrs[i], byteCodeVector));
                    int nextInstrIndex = i + instrs[i].length();
                    javaInstr = new JCControlInstr(instrs[i], instrs[nextInstrIndex]);
                    i = nextInstrIndex;
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 147: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    javaInstr = new JCControlInstr(instrs[i], byteCodeVector);
                    break;
                }
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    javaInstr = new JCFieldAccessInstr(instrs[i], cp);
                    break;
                }
                case 139: 
                case 140: 
                case 141: 
                case 142: {
                    javaInstr = new JCInvokeInstr(instrs[i], cp);
                    break;
                }
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: {
                    javaInstr = new JCObjectInstr(instrs[i], cp);
                }
            }
            byteCodeVector.add(javaInstr);
        }
        return byteCodeVector;
    }

    public static void fixOffsets(Vector<Instruction> bcVector) {
        for (int i = 0; i < bcVector.size(); ++i) {
            Instruction instruction = bcVector.elementAt(i);
            Instr jcInstr = instruction.getJCInstruction();
            if (jcInstr.opcode == 117 || jcInstr.opcode == 118) {
                BCConverter.fixLookupSwitchOffsets(instruction, i, bcVector);
            }
            if (jcInstr.opcode == 115 || jcInstr.opcode == 116) {
                BCConverter.fixTableSwitchOffsets(instruction, i, bcVector);
            }
            if (!BCConverter.isBranchInstruction(jcInstr.opcode)) continue;
            int capJumpSize = jcInstr.arg;
            int classJumpSize = 0;
            if (capJumpSize > 0) {
                classJumpSize = BCConverter.getForwardBranchOffset(bcVector, i, capJumpSize);
            } else if (capJumpSize < 0) {
                classJumpSize = BCConverter.getBackwardBranchOffset(bcVector, i, capJumpSize);
            }
            instruction.getJavaInstructions().elementAt(0).fixJumpOffsetArgument(classJumpSize);
        }
    }

    private static void fixLookupSwitchOffsets(Instruction instr, int instrIdx, Vector<Instruction> bcVector) {
        int i;
        Vector<Integer> argVector = new Vector<Integer>();
        InstrLookupSwitch jcInstr = (InstrLookupSwitch)instr.getJCInstruction();
        int numPadBytes = JCControlInstr.getNumPadBytes(bcVector, instrIdx);
        for (i = 0; i < numPadBytes; ++i) {
            argVector.add(new Integer(0));
        }
        if (jcInstr.dfl >= 0) {
            BCConverter.addIntegerArgument(argVector, BCConverter.getForwardBranchOffset(bcVector, instrIdx, jcInstr.dfl));
        } else {
            BCConverter.addIntegerArgument(argVector, BCConverter.getBackwardBranchOffset(bcVector, instrIdx, jcInstr.dfl));
        }
        BCConverter.addIntegerArgument(argVector, jcInstr.ncases);
        for (i = 0; i < jcInstr.ncases; ++i) {
            BCConverter.addIntegerArgument(argVector, jcInstr.keys[i]);
            if (jcInstr.offsets[i] >= 0) {
                BCConverter.addIntegerArgument(argVector, BCConverter.getForwardBranchOffset(bcVector, instrIdx, jcInstr.offsets[i]));
                continue;
            }
            BCConverter.addIntegerArgument(argVector, BCConverter.getBackwardBranchOffset(bcVector, instrIdx, jcInstr.offsets[i]));
        }
        instr.getJavaInstructions().elementAt(0).fixSwitchOffsetArguments(argVector);
    }

    private static void fixTableSwitchOffsets(Instruction instr, int instrIdx, Vector<Instruction> bcVector) {
        int i;
        Vector<Integer> argVector = new Vector<Integer>();
        InstrTableSwitch jcInstr = (InstrTableSwitch)instr.getJCInstruction();
        int numPadBytes = JCControlInstr.getNumPadBytes(bcVector, instrIdx);
        for (i = 0; i < numPadBytes; ++i) {
            argVector.add(new Integer(0));
        }
        if (jcInstr.dfl >= 0) {
            BCConverter.addIntegerArgument(argVector, BCConverter.getForwardBranchOffset(bcVector, instrIdx, jcInstr.dfl));
        } else {
            BCConverter.addIntegerArgument(argVector, BCConverter.getBackwardBranchOffset(bcVector, instrIdx, jcInstr.dfl));
        }
        BCConverter.addIntegerArgument(argVector, jcInstr.low);
        BCConverter.addIntegerArgument(argVector, jcInstr.high);
        for (i = 0; i < jcInstr.offsets.length; ++i) {
            if (jcInstr.offsets[i] >= 0) {
                BCConverter.addIntegerArgument(argVector, BCConverter.getForwardBranchOffset(bcVector, instrIdx, jcInstr.offsets[i]));
                continue;
            }
            BCConverter.addIntegerArgument(argVector, BCConverter.getBackwardBranchOffset(bcVector, instrIdx, jcInstr.offsets[i]));
        }
        instr.getJavaInstructions().elementAt(0).fixSwitchOffsetArguments(argVector);
    }

    private static int getForwardBranchOffset(Vector<Instruction> bcVector, int instructionIndex, int jumpSize) {
        int capBCOffset = 0;
        int classBCOffset = 0;
        int currInstrIndex = instructionIndex;
        while (capBCOffset != jumpSize) {
            Instruction instruction = bcVector.elementAt(currInstrIndex);
            capBCOffset += instruction.getJCInstruction().length();
            Vector<JavaInstruction> javaInstrs = instruction.getJavaInstructions();
            for (int i = 0; i < javaInstrs.size(); ++i) {
                classBCOffset += javaInstrs.elementAt(i).getSize();
            }
            ++currInstrIndex;
        }
        return classBCOffset;
    }

    public static short translateOffset(Vector<Instruction> bcVector, short offset) {
        int capBCOffset = 0;
        int classBCOffset = 0;
        int currInstrIndex = 0;
        while (capBCOffset < offset) {
            Instruction instruction = bcVector.elementAt(currInstrIndex);
            capBCOffset += instruction.getJCInstruction().length();
            Vector<JavaInstruction> javaInstrs = instruction.getJavaInstructions();
            for (int i = 0; i < javaInstrs.size(); ++i) {
                classBCOffset += javaInstrs.elementAt(i).getSize();
            }
            ++currInstrIndex;
        }
        return (short)classBCOffset;
    }

    private static int getBackwardBranchOffset(Vector<Instruction> bcVector, int instructionIndex, int jumpSize) {
        int capBCOffset = 0;
        int classBCOffset = 0;
        int currInstrIndex = instructionIndex;
        while (capBCOffset != jumpSize) {
            Instruction instruction = bcVector.elementAt(--currInstrIndex);
            capBCOffset -= instruction.getJCInstruction().length();
            Vector<JavaInstruction> javaInstrs = instruction.getJavaInstructions();
            for (int i = 0; i < javaInstrs.size(); ++i) {
                classBCOffset -= javaInstrs.elementAt(i).getSize();
            }
        }
        return classBCOffset;
    }

    private static boolean isBranchInstruction(int jcOpCode) {
        switch (jcOpCode) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                return true;
            }
        }
        return false;
    }

    private static void addIntegerArgument(Vector<Integer> argVector, int argValue) {
        byte[] valueBytes = Util.getIntBytes(argValue);
        for (int i = 0; i < 4; ++i) {
            argVector.add(new Integer(valueBytes[i]));
        }
    }
}

