/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CapProcessor;
import com.sun.javacard.components.caputils.MethodNameTableKey;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import java.util.Hashtable;
import java.util.Vector;

public class CAPUtil {
    static final String initMethodName = "<init>";
    static int genRefNameCount = 0;
    static Hashtable<Integer, String> refNames = new Hashtable();
    static Hashtable<Integer, String> classMethodDescriptors = new Hashtable();
    static Hashtable<MethodNameTableKey, String> instanceMethodNamesByToken = new Hashtable();

    public static String getRefName(int ref) {
        String refName = refNames.get(new Integer(ref));
        if (refName == null) {
            EfClass ec = Classref.checkExportedAndReturnExportClass(ref);
            refName = ec != null ? ec.thisName() : CAPUtil.getConstructedRefName(ref);
            refNames.put(new Integer(ref), refName);
        }
        return refName;
    }

    private static String getConstructedRefName(int classRef) {
        String clName = null;
        byte[] strArray = new byte[]{(byte)(CAPUtil.getCharOffset(genRefNameCount, 1) + 65), (byte)(CAPUtil.getCharOffset(genRefNameCount, 2) + 65), (byte)(CAPUtil.getCharOffset(genRefNameCount, 3) + 65)};
        try {
            clName = new String(strArray, "US-ASCII");
        }
        catch (Exception e) {
            System.out.println("Unexpected character encoding exception");
            System.exit(1);
        }
        ++genRefNameCount;
        return CapProcessor.pkgName + "/" + clName;
    }

    public static String getClassFieldName(FieldDescriptor fd, EfClass ec) {
        EfField eff;
        int token = fd.token();
        if (ec != null && token != 255 && (eff = ec.getFieldForTokenAndFlag(token, false)) != null) {
            return eff.name();
        }
        return CAPUtil.getConstructedFieldName(fd);
    }

    public static String getClassMethodName(ClassDescriptor cdescriptor, MethodDescriptor md, boolean isStatic, boolean isInit, EfClass ec) {
        EfMethod em;
        boolean isInterfaceMethod = false;
        if (isInit) {
            return new String(initMethodName);
        }
        if (Cap.getApplet() != null && Cap.getApplet().isInstallMethod(md)) {
            return "install";
        }
        int token = md.token();
        if (ec != null && token != 255 && (em = ec.getMethodForTokenAndFlag(token, isStatic | isInit)) != null) {
            return em.name();
        }
        String methodName = null;
        if (!isStatic && !isInit) {
            token = md.token();
            if (token != 255) {
                methodName = instanceMethodNamesByToken.get(new MethodNameTableKey(cdescriptor, md));
            }
            if (methodName == null) {
                ClassDescriptor cdesc = ClassDescriptor.getClassDescForMethodLoc(md.methodOffset());
                if (cdesc != null) {
                    methodName = CAPUtil.getMethodNameFromImplementedInterfaces(cdesc, token);
                    if (methodName == null) {
                        int classRef = cdesc.thisClass();
                        ClassInfo clInfo = Cap.getClassComponent().infoOfs(classRef);
                        int superClassRef = clInfo.superclass();
                        while (superClassRef != 65535) {
                            EfClass exportedClass = Classref.checkExportedAndReturnExportClass(superClassRef);
                            if (exportedClass != null) {
                                EfMethod em2 = exportedClass.getMethodForTokenAndFlag(token, false);
                                if (em2 == null) {
                                    em2 = exportedClass.getMethodFromSupers(token, false);
                                }
                                if (em2 != null) {
                                    methodName = em2.name();
                                }
                                break;
                            }
                            if (Classref.isExternal(superClassRef)) continue;
                            superClassRef = Cap.getClassComponent().infoOfs(superClassRef).superclass();
                        }
                    } else {
                        isInterfaceMethod = true;
                    }
                }
                if (methodName != null && token != 255) {
                    instanceMethodNamesByToken.put(new MethodNameTableKey(md), methodName);
                }
            }
        }
        if (methodName == null) {
            methodName = CAPUtil.getConstructedMethodName(md);
            if (!isStatic && !isInit && token != 255) {
                instanceMethodNamesByToken.put(new MethodNameTableKey(md), methodName);
            }
        }
        return methodName;
    }

    private static String getMethodNameFromImplementedInterfaces(ClassDescriptor cdesc, int token) {
        String methodName = null;
        int interfaceCount = cdesc.interfaceCount();
        int classRef = cdesc.thisClass();
        ClassInfo clInfo = Cap.getClassComponent().infoOfs(classRef);
        if (interfaceCount == 0) {
            return null;
        }
        ImplementedInterface implInterface = clInfo.firstImplementedInterface();
        for (int i = 0; i < interfaceCount; ++i) {
            int interfaceRef = cdesc.interfaceRef(i);
            EfClass exportedClass = Classref.checkExportedAndReturnExportClass(interfaceRef);
            if (exportedClass == null) {
                implInterface.next();
                continue;
            }
            int methodCount = implInterface.count();
            for (int j = 0; j < methodCount; ++j) {
                int interfaceMethodToken = implInterface.indexMethod(j);
                if (interfaceMethodToken != token) continue;
                EfMethod em = exportedClass.getMethodForTokenAndFlag(j, false);
                if (em != null) {
                    methodName = em.name();
                }
                if (methodName != null) break;
            }
            if (methodName != null) break;
            implInterface.next();
        }
        return methodName;
    }

    private static String getConstructedFieldName(FieldDescriptor fd) {
        boolean st = (fd.flags() & 8) == 8;
        String name = st ? "sfield" : "field";
        name = name + "_token" + fd.token();
        name = name + "_descoff" + fd.getDescOffset();
        if (st) {
            name = name + "_staticref" + fd.staticRef();
        }
        return name;
    }

    private static String getConstructedMethodName(MethodDescriptor md) {
        boolean st = (md.flags() & 8) == 8;
        String name = st ? "smethod" : "method";
        name = name + "_token" + md.token();
        name = name + "_descoff" + md.getDescOffset();
        if (st) {
            name = name + "_moffset" + md.methodOffset();
        }
        return name;
    }

    public static String getFieldDescrStr(short type) {
        if ((short)(type & Short.MIN_VALUE) == Short.MIN_VALUE) {
            type = (short)(type & Short.MAX_VALUE);
            switch (type) {
                case 2: {
                    return "Z";
                }
                case 3: {
                    return "B";
                }
                case 4: {
                    return "S";
                }
                case 5: {
                    return "I";
                }
            }
            throw new VerifierError("Invalid type descriptor");
        }
        Vector<String> descStrVector = CAPUtil.getTypeDescrStr(type);
        if (descStrVector.size() == 0 || descStrVector.size() > 1) {
            throw new VerifierError("Invalid type descriptor");
        }
        return descStrVector.elementAt(0);
    }

    public static String getMethodDescriptorString(int typeOffset) {
        String descStr = classMethodDescriptors.get(new Integer(typeOffset));
        if (descStr == null) {
            Vector<String> methodDescVector = CAPUtil.getTypeDescrStr((short)typeOffset);
            int vectorSize = methodDescVector.size();
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            for (int i = 0; i < vectorSize - 1; ++i) {
                sb.append(methodDescVector.elementAt(i));
            }
            sb.append(")" + methodDescVector.elementAt(vectorSize - 1));
            descStr = sb.toString();
            classMethodDescriptors.put(new Integer(typeOffset), descStr);
        }
        return descStr;
    }

    private static Vector<String> getTypeDescrStr(short typeOffset) {
        Vector<String> types = new Vector<String>();
        Safeptr typeDescr = Cap.getTypeDescr().at(typeOffset);
        int nibbleCount = typeDescr.u1(0);
        int nibbleOffset = 2;
        block13: for (nibbleOffset = 2; nibbleOffset < nibbleCount + 2; ++nibbleOffset) {
            StringBuffer descString = new StringBuffer();
            int type = typeDescr.nibble(nibbleOffset);
            switch (type) {
                case 1: {
                    types.add("V");
                    continue block13;
                }
                case 2: {
                    types.add("Z");
                    continue block13;
                }
                case 3: {
                    types.add("B");
                    continue block13;
                }
                case 4: {
                    types.add("S");
                    continue block13;
                }
                case 5: {
                    types.add("I");
                    continue block13;
                }
                case 14: {
                    descString.append("[");
                }
                case 6: {
                    descString.append("L");
                    int pkgToken = typeDescr.nibble(++nibbleOffset);
                    pkgToken = pkgToken << 4 | typeDescr.nibble(++nibbleOffset);
                    int classToken = typeDescr.nibble(++nibbleOffset);
                    classToken = classToken << 4 | typeDescr.nibble(++nibbleOffset);
                    int classRef = pkgToken << 8 | classToken;
                    descString.append(CAPUtil.getRefName(classRef) + ";");
                    types.add(descString.toString());
                    continue block13;
                }
                case 13: {
                    types.add("[I");
                    continue block13;
                }
                case 10: {
                    types.add("[Z");
                    continue block13;
                }
                case 11: {
                    types.add("[B");
                    continue block13;
                }
                case 12: {
                    types.add("[S");
                    continue block13;
                }
                default: {
                    throw new VerifierError("Invalid type descriptor for field");
                }
            }
        }
        return types;
    }

    private static byte getCharOffset(int num, int pos) {
        int rem = 0;
        for (int i = 0; i < pos; ++i) {
            rem = num % 26;
            num = (num - rem) / 26;
        }
        return (byte)rem;
    }
}

