/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.CapProcessor;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassMemberInfo;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClassFieldsTable {
    private ClassDescriptor cdesc;
    private CapProcessor cp;
    Hashtable<String, ClassMemberInfo> classFields = new Hashtable();

    public ClassFieldsTable(ClassConstantPool constantPool, ClassDescriptor cdesc, EfClass exportedClass) {
        int fieldCount = cdesc.fieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            FieldDescriptor fd = cdesc.fieldDescr(i);
            String fieldName = CAPUtil.getClassFieldName(fd, exportedClass);
            String fieldDesc = CAPUtil.getFieldDescrStr((short)fd.type());
            int nameIndex = constantPool.getUtf8InfoIndex(fieldName);
            int descIndex = constantPool.getUtf8InfoIndex(fieldDesc);
            this.addField(fd, nameIndex, descIndex);
        }
    }

    private void addField(FieldDescriptor fd, int nameIndex, int descIndex) {
        ClassMemberInfo fieldInfo = new ClassMemberInfo();
        fieldInfo.setAccessFlags((short)fd.flags());
        fieldInfo.setNameIndex((short)nameIndex);
        fieldInfo.setDescriptorIndex((short)descIndex);
        this.classFields.put(fd.toString(), fieldInfo);
    }

    public Enumeration getClassFields() {
        return this.classFields.elements();
    }

    public short getFieldCount() {
        return (short)this.classFields.size();
    }
}

