/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugcomponent;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.debugcomponent.ClassDebugInfo;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class DebugComponent
extends Component {
    private int package_index;
    private JcPackage jc_package;
    ClassDebugInfo[] classes;
    Vector<String> utf8_strings;

    public DebugComponent(JcPackage jc_package) {
        super(12, "debug");
        this.jc_package = jc_package;
        this.build();
    }

    private void build() {
        this.utf8_strings = new Vector(20, 10);
        this.package_index = this.addString(this.jc_package.getPackageName());
        JcClass[] jc_classes = this.jc_package.getClasses();
        this.classes = new ClassDebugInfo[jc_classes.length];
        for (int i = 0; i < jc_classes.length; ++i) {
            this.classes[i] = jc_classes[i].isAnnotation() ? null : new ClassDebugInfo(jc_classes[i], this);
        }
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeShort(this.utf8_strings.size());
            for (int i = 0; i < this.utf8_strings.size(); ++i) {
                String utf8_string = this.utf8_strings.elementAt(i);
                byte[] utf8Bytes = utf8_string.getBytes("UTF8");
                dos.writeShort(utf8Bytes.length);
                dos.write(utf8Bytes, 0, utf8Bytes.length);
            }
            dos.writeShort(this.package_index);
            int count = 0;
            for (ClassDebugInfo element : this.classes) {
                if (element == null) continue;
                ++count;
            }
            dos.writeShort(count);
            for (ClassDebugInfo element : this.classes) {
                if (element == null) continue;
                element.toBinary(dos);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    public int addString(String a_string) {
        for (int i = 0; i < this.utf8_strings.size(); ++i) {
            String this_string = this.utf8_strings.elementAt(i);
            if (!this_string.equals(a_string)) continue;
            return i;
        }
        this.utf8_strings.addElement(a_string);
        return this.utf8_strings.size() - 1;
    }

    @Override
    public int dataSize() {
        int size = 0;
        for (ClassDebugInfo element : this.classes) {
            if (element == null) continue;
            size += element.getSize();
        }
        for (int i = 0; i < this.utf8_strings.size(); ++i) {
            String utf8_string = this.utf8_strings.elementAt(i);
            try {
                byte[] utf8_bytes = utf8_string.getBytes("UTF8");
                size = size + 2 + utf8_bytes.length;
                continue;
            }
            catch (UnsupportedEncodingException w) {
                throw new ConverterInternalError(w.getMessage());
            }
        }
        return size + 6;
    }
}

