/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ConstantPoolComponent
extends Component {
    protected Vector<Info> cpVector = new Vector();

    public ConstantPoolComponent(JCPackage p) {
        super(p);
    }

    public Vector<Info> getConstantPoolInfos() {
        return this.cpVector;
    }

    public void addConstantPoolEntry(Info i) {
        this.cpVector.addElement(i);
    }

    @Override
    public int dataSize() {
        int size = 2;
        for (Info i : this.cpVector) {
            size += i.size();
        }
        return size;
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeShort(this.cpVector.size());
            for (Info i : this.cpVector) {
                byte[] array = i.toByteArray(this.parentPackage);
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }

    public void add(Info i) {
        this.cpVector.addElement(i);
    }

    protected byte[] format(Info info) {
        byte[] record = null;
        int addr = 0;
        int index = 0;
        switch (info.getType()) {
            case 1: {
                record = new byte[4];
                record[index++] = (byte)info.getType();
                addr = info.resolve().getRelocAddr();
                record[index++] = (byte)(addr >> 8 & 0xFF);
                record[index++] = (byte)(addr & 0xFF);
                record[index++] = 0;
                break;
            }
            case 5: 
            case 6: {
                if (!info.isPackageInternal()) break;
                record = new byte[4];
                record[index++] = (byte)info.getType();
                record[index++] = 0;
                addr = info.resolve().getRelocAddr();
                record[index++] = (byte)(addr >> 8 & 0xFF);
                record[index++] = (byte)(addr & 0xFF);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                record = new byte[5];
                record[index++] = (byte)info.getType();
                record[index++] = 0;
                record[index++] = 0;
                record[index++] = (byte)info.getClassToken();
                record[index++] = (byte)info.resolve().getRelocAddr();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return record;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Count: " + this.cpVector.size() + Msg.eol);
        int count = 0;
        for (Info i : this.cpVector) {
            byte[] array = i.toByteArray(this.parentPackage);
            sb.append("ConstantPool[" + count++ + "]: " + Msg.toHexString(array) + Msg.eol);
        }
        return sb.toString();
    }
}

