/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public abstract class OutputFormatter {
    protected Properties mappingTable;

    public OutputFormatter(BufferedReader configFile) throws IOException {
        String section = "none";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.mappingTable = new Properties();
        boolean startReading = false;
        switch (Globals.target) {
            case 3: {
                section = "[Cref]";
                break;
            }
            case 4: {
                section = "[Jref]";
                break;
            }
        }
        if (configFile != null) {
            String s;
            while ((s = configFile.readLine()) != null) {
                if (s.trim().equalsIgnoreCase(section) || s.trim().equalsIgnoreCase("[Common]")) {
                    startReading = true;
                    continue;
                }
                if (s.trim().startsWith("[") && s.trim().endsWith("]")) {
                    startReading = false;
                }
                if (!startReading || s.length() <= 0) continue;
                s = s + "\n";
                dos.writeBytes(s);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            this.mappingTable.load(bis);
        }
    }

    public String getMapEntry(String key) {
        assert (key != null) : "key != null";
        return (String)this.mappingTable.get(key);
    }

    public abstract void format(RomMask var1);

    public abstract void write(OutputStream var1) throws IOException;

    public Properties getProperties() {
        return this.mappingTable;
    }
}

