/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Objects;

public class EfMethod
extends EfElement {
    public short token;
    public int accessFlag;
    int nameIndex;
    int descriptorIndex;
    private boolean sameVersion;
    private String parentClassName;
    private EfClass parentClass;
    private static final int validFlags = 1053;
    private static final int publicProtectedFlags = 5;
    private static final int abstractFinalFlags = 1040;
    private static final int abstractStaticFlags = 1032;
    private static final int abstractPublicFlags = 1025;

    EfMethod(ExportFile ef, String className) {
        super(ef);
        this.parentClassName = className;
    }

    public EfClass getParentClass() {
        if (this.parentClass == null) {
            this.parentClass = this.ef.findClassByName(this.parentClassName);
        }
        return this.parentClass;
    }

    void read() throws IOException {
        this.token = (short)this.ef.in.readUnsignedByte();
        this.accessFlag = this.ef.in.readUnsignedShort();
        this.nameIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.nameIndex);
        this.descriptorIndex = this.ef.in.readUnsignedShort();
        this.ef.checkUtf8Index(this.descriptorIndex);
    }

    public String name() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.nameIndex]).contents;
    }

    public String sig() {
        return ((EfConstant_Utf8)this.ef.constantPool[this.descriptorIndex]).contents;
    }

    public boolean isStaticOrInit() {
        return (this.accessFlag & 8) != 0 || this.name().equals("<init>");
    }

    void verify(boolean inInterface, HashSet<EfMethod> methodNames, BitSet staticMethodTokens, BitSet virtualMethodTokens) {
        if (!EfNames.validMethodName(this.name())) {
            throw new VerifierError("EfMethod.3", this.name());
        }
        if (!EfNames.validMethodDescriptor(this.sig())) {
            throw new VerifierError("EfMethod.4", this.sig());
        }
        try {
            BitSet methodTokens;
            if ((this.accessFlag & 0xFFFFFBE2) != 0) {
                throw new VerifierError("EfMethod.5", this.accessFlag);
            }
            if ((this.accessFlag & 5) == 5) {
                throw new VerifierError("EfMethod.6");
            }
            if ((this.accessFlag & 5) == 0) {
                throw new VerifierError("EfMethod.7");
            }
            if ((this.accessFlag & 0x410) == 1040) {
                throw new VerifierError("EfMethod.8");
            }
            if ((this.accessFlag & 0x408) == 1032) {
                throw new VerifierError("EfMethod.9");
            }
            if (inInterface && (this.accessFlag & 0x401) != 1025) {
                throw new VerifierError("EfMethod.10");
            }
            if (this.name().equals("<init>") && (this.accessFlag & 8) != 0) {
                throw new VerifierError("EfMethod.11");
            }
            if (!methodNames.add(this)) {
                throw new VerifierError("EfMethod.1");
            }
            BitSet bitSet = methodTokens = this.isStaticOrInit() ? staticMethodTokens : virtualMethodTokens;
            if (methodTokens.get(this.token)) {
                throw new VerifierError("EfMethod.2", this.token);
            }
            if (!inInterface && !this.isStaticOrInit()) {
                for (EfClass thisClass : this.ef.classes) {
                    if (!thisClass.thisName().equals(this.parentClassName)) continue;
                    for (int j = 0; j < thisClass.supers.length; ++j) {
                        String superClsName = thisClass.superName(j);
                        boolean superClsFound = false;
                        for (int k = 0; k < this.ef.classes.length && !superClsFound; ++k) {
                            if (!this.ef.classes[k].thisName().equals(superClsName)) continue;
                            EfClass superClass = this.ef.classes[k];
                            superClsFound = true;
                            boolean superMethod = false;
                            short highestSuperToken = 0;
                            for (int l = 0; l < superClass.methods.length && !superMethod; ++l) {
                                EfMethod m = superClass.methods[l];
                                if (m.isStaticOrInit()) continue;
                                if (m.token > highestSuperToken) {
                                    highestSuperToken = m.token;
                                }
                                if (!m.equals(this)) continue;
                                superMethod = true;
                                if (m.token == this.token) continue;
                                throw new VerifierError("EfMethod.13");
                            }
                            if (superMethod || this.token >= highestSuperToken) continue;
                            throw new VerifierError("EfMethod.14");
                        }
                    }
                }
            }
            methodTokens.set(this.token);
        }
        catch (VerifierError e) {
            throw new VerifierError("EfMethod.12", (Object)this, (Object)e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EfMethod)) {
            return false;
        }
        EfMethod that = (EfMethod)obj;
        return this.name().equals(that.name()) && this.sig().equals(that.sig());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.name());
        hash = 89 * hash + Objects.hashCode(this.sig());
        return hash;
    }

    public String toString() {
        return EfNames.prettyMethod(this.name(), this.sig());
    }

    public void compareTo(EfMethod newMethod, boolean oldFinalNewNotFinal) {
        this.sameVersion = false;
        this.compareCommon(newMethod);
        if ((this.accessFlag & 1) > (newMethod.accessFlag & 1)) {
            throw new VerifierError("RevisionError.25", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) < (newMethod.accessFlag & 0x10) && !oldFinalNewNotFinal) {
            throw new VerifierError("RevisionError.26", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x400) < (newMethod.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.27", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    public void checkEquality(EfMethod newMethod) {
        this.sameVersion = true;
        this.compareCommon(newMethod);
        if ((this.accessFlag & 1) != (newMethod.accessFlag & 1)) {
            throw new VerifierError("RevisionError.24", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 4) != (newMethod.accessFlag & 4)) {
            throw new VerifierError("RevisionError.24", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x10) != (newMethod.accessFlag & 0x10)) {
            throw new VerifierError("RevisionError.24", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 0x400) != (newMethod.accessFlag & 0x400)) {
            throw new VerifierError("RevisionError.28", (Object)this.name(), (Object)this.parentClassName);
        }
    }

    void compareCommon(EfMethod newMethod) {
        if (this.token != newMethod.token) {
            throw new VerifierError("RevisionError.23", (Object)this.name(), (Object)this.parentClassName);
        }
        if ((this.accessFlag & 8) != (newMethod.accessFlag & 8)) {
            throw new VerifierError("RevisionError.38", (Object)this.name(), (Object)this.parentClassName);
        }
    }
}

