/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.OptionNames;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.ValidValues;
import com.sun.javacard.util.Diagnostics;
import com.sun.javacard.validator.Validator;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import org.apache.commons.cli.Option;

public class ValidateCommand
extends SubCommand {
    Vector<File> exportFiles;

    public ValidateCommand() {
        super("validate");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("t", "type"));
        this.addOption(new CommandOption("e", "exportpath"));
        this.addOption(new CommandOption("x", "exportfile"));
    }

    @Override
    public int execute() throws Exception {
        Vector<String> exportPathNames = new Vector<String>();
        Vector<String> exportFileNames = new Vector<String>();
        Packager packager = Packager.getPackager();
        packager.setVerbose(this.verbose);
        this.toolsLogger.info("validate.info.1", new Object[0]);
        block6: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case XTRA: {
                    packager.addXtraOption(option.getValue());
                    continue block6;
                }
                case TYPE: {
                    packager.setType(option.getValue());
                    continue block6;
                }
                case EXPORTPATH: {
                    exportPathNames.addElement(option.getValue());
                    continue block6;
                }
                case EXPORTFILE: {
                    exportFileNames.addElement(option.getValue());
                    continue block6;
                }
                default: {
                    String str1 = option.getOpt();
                    String str2 = option.getLongOpt();
                    String str3 = "";
                    if (str1 != null) {
                        str3 = str3 + str1;
                    }
                    if (str1 != null && str2 != null) {
                        str3 = str3 + " (or) ";
                    }
                    if (str2 != null) {
                        str3 = str3 + str2;
                    }
                    this.toolsLogger.severe("Unknown option:" + str3, new Object[0]);
                    throw new Exception("Unknown option " + str3);
                }
            }
        }
        if (this.validateCommandLine(packager) != 0) {
            return 1;
        }
        this.exportFiles = new Vector();
        for (String s : exportPathNames) {
            File folder = new File(s);
            if (!folder.exists()) {
                throw new Exception(ErrorKey.DoesNotExists.getMessage(s));
            }
            if (!folder.isDirectory()) {
                throw new Exception(ErrorKey.IsNotADirectory.getMessage(s));
            }
            this.populateExportFiles(this.exportFiles, folder);
        }
        for (String s : exportFileNames) {
            File f = new File(s);
            if (!f.exists()) {
                throw new Exception(ErrorKey.DoesNotExists.getMessage(s));
            }
            this.exportFiles.addElement(f);
        }
        if (this.argumentsArray == null || this.argumentsArray.length != 1) {
            this.toolsLogger.severe(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]), new Object[0]);
            throw new Exception(ErrorKey.ModuleFileOrFolderNotSpecified.getMessage(new Object[0]));
        }
        int type = 0;
        type = packager.getType().equals("web") ? 10 : (packager.getType().equals("classic-applet") ? 12 : (packager.getType().equals("extended-applet") ? 11 : (packager.getType().equals("extension-lib") ? 1 : 0)));
        Validator v = new Validator();
        v.setExportFiles(this.exportFiles);
        Diagnostics diagnostics = v.validate(this.argumentsArray[0], type, null);
        String status = diagnostics.isOk() ? ErrorKey.SUCCESS.getMessage(new Object[0]) : ErrorKey.FAILED.getMessage(new Object[0]);
        diagnostics.printDiagnostics(status, "Packager/validate", ErrorKey.Error2.getMessage(new Object[0]), ErrorKey.Warning2.getMessage(new Object[0]), ErrorKey.Error1.getMessage(new Object[0]), ErrorKey.Warning1.getMessage(new Object[0]));
        return diagnostics.isOk() ? 0 : 1;
    }

    private int validateCommandLine(Packager packager) {
        Vector<String> errorMessages = new Vector<String>();
        String type = packager.getType();
        if (type == null) {
            errorMessages.add(ErrorKey.MissingType.getMessage(new Object[0]));
        } else if (!ValidValues.isValidAppType(type)) {
            errorMessages.add(ErrorKey.InvalidModuleOrLibType.getMessage(type));
        }
        if (!errorMessages.isEmpty()) {
            for (String str : errorMessages) {
                this.toolsLogger.severe("[ " + ErrorKey.Error1.getMessage(new Object[0]) + "] " + str.trim(), new Object[0]);
            }
            return 1;
        }
        return 0;
    }

    private void populateExportFiles(Vector<File> exportFiles, File f) {
        if (f.isFile()) {
            if (f.getName().endsWith(".exp")) {
                exportFiles.addElement(f);
            }
            return;
        }
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File p) {
                return p.isDirectory() || p.getName().endsWith(".exp");
            }
        });
        if (files != null) {
            for (File x : files) {
                this.populateExportFiles(exportFiles, x);
            }
        }
    }
}

