/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.ServerT0Protocol;
import com.sun.javacard.impl.Constants;
import com.sun.javacard.jcwde.Globals;
import com.sun.javacard.jcwde.SimulationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SimAPDU
implements CadServerListener,
Constants {
    private static final short BUFFER_OVERFLOW = -16383;
    private static final short READ_ERROR = -16381;
    private static final short WRITE_ERROR = -16380;
    private static final short INVALID_GET_RESPONSE = -16378;
    private static final byte ACK_NONE = 0;
    private static final byte ACK_INS = 1;
    private static final byte ACK_NOT_INS = 2;
    private static final byte GET_RESPONSE_CLA = 0;
    private static final byte GET_RESPONSE_INS = -64;
    private static final byte GET_RESPONSE_P1 = 0;
    private static final byte GET_RESPONSE_P2 = 0;
    private static boolean invalidGetResponse = false;
    public static int port = 0;
    public static ServerSocket srvSock = null;
    protected static ServerT0Protocol _protocol;
    protected static SimAPDU _simApdu;
    private static byte[] apduBuffer;
    private static short apduStatus;
    private static byte[] command;

    static ServerT0Protocol protocol() {
        if (_protocol == null) {
            try {
                byte[] atr = new byte[]{59, -16, 17, 0, -1, 0};
                Socket sock = srvSock.accept();
                sock.setTcpNoDelay(true);
                BufferedInputStream bin = new BufferedInputStream(sock.getInputStream());
                BufferedOutputStream bos = new BufferedOutputStream(sock.getOutputStream());
                _protocol = new ServerT0Protocol((InputStream)bin, (OutputStream)bos);
                _simApdu = new SimAPDU();
                _protocol.addCadServerListener((CadServerListener)_simApdu);
                _protocol.sendATR(atr);
            }
            catch (Exception e) {
                System.err.println(e);
                throw new SimulationException();
            }
        }
        return _protocol;
    }

    public void powerUp(CadEvent evt) {
    }

    public void powerDown(CadEvent evt) {
        System.out.println(Globals._messages.getString("PowerDown"));
        System.exit(0);
    }

    public static short t0RcvCommand() {
        if (SimAPDU.protocol().t0RcvCommand(apduBuffer) != 0) {
            return -16381;
        }
        System.arraycopy(apduBuffer, 0, command, 0, 5);
        return 0;
    }

    public static short t0SndStatusRcvCommand() {
        if (invalidGetResponse) {
            invalidGetResponse = false;
            System.arraycopy(command, 0, apduBuffer, 0, 5);
        } else {
            if (SimAPDU.protocol().t0SndStatusRcvCommand(apduBuffer, apduStatus) != 0) {
                return -16381;
            }
            System.arraycopy(apduBuffer, 0, command, 0, 5);
        }
        return 0;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static short t0RcvData(short offset) {
        short receiveLen;
        byte status;
        block5: {
            short s;
            short receiveSpace;
            block4: {
                block3: {
                    status = 0;
                    receiveLen = (short)(command[4] & 0xFF);
                    receiveSpace = (short)(apduBuffer.length - offset);
                    if (receiveLen <= receiveSpace) break block3;
                    receiveLen = receiveSpace;
                    if (!true) break block4;
                    s = receiveSpace;
                    receiveSpace = (short)(s - 1);
                    if (s == 0 || status != 0) break block5;
                }
                status = SimAPDU.protocol().t0RcvData(apduBuffer, offset, receiveLen, command[1]);
                break block5;
            }
            do {
                short s2 = offset;
                offset = (short)(offset + 1);
                status = SimAPDU.protocol().t0RcvData(apduBuffer, s2, (short)1, ~command[1]);
                s = receiveSpace;
                receiveSpace = (short)(s - 1);
            } while (s != 0 && status == 0);
        }
        SimAPDU.command[4] = (byte)(command[4] - receiveLen);
        if (status == 0) {
            return receiveLen;
        }
        return -16381;
    }

    public static short t0SndData(byte[] data, short offset, short length, byte procByteType) {
        switch (procByteType) {
            case 0: {
                if (SimAPDU.protocol().t0SndData(data, offset, length) == 0) break;
                return -16380;
            }
            case 1: {
                if (SimAPDU.protocol().t0SndData(data, offset, length, command[1]) == 0) break;
                return -16380;
            }
            case 2: {
                if (SimAPDU.protocol().t0SndData(data, offset, length, ~command[1]) == 0) break;
                return -16380;
            }
            default: {
                return -16380;
            }
        }
        return 0;
    }

    public static short t0SndGetResponse(byte channelId) {
        if (SimAPDU.protocol().t0SndStatusRcvCommand(command, apduStatus) != 0) {
            return -16381;
        }
        if ((byte)(command[0] & 0xFFFFFFFC) != 0 || command[1] != -64 || command[2] != 0 || command[3] != 0) {
            invalidGetResponse = true;
            return -16378;
        }
        if ((command[0] & 3) != channelId) {
            invalidGetResponse = true;
            return -16378;
        }
        return (short)(command[4] & 0xFF);
    }

    public static short t0Wait() {
        if (SimAPDU.protocol().t0SndData(apduBuffer, (short)0, (short)0, (byte)96) != 0) {
            return -16380;
        }
        return 0;
    }

    public static byte[] t0InitAPDUBuffer() {
        try {
            srvSock = new ServerSocket(port);
        }
        catch (Exception iE) {
            System.err.println(iE);
            System.err.println(Globals._messages.getString("BadSocket") + port);
            throw new SimulationException();
        }
        return apduBuffer;
    }

    public static short t0SetStatus(short sw1Sw2) {
        apduStatus = sw1Sw2;
        return 0;
    }

    static {
        apduBuffer = new byte[133];
        apduStatus = 0;
        command = new byte[5];
    }
}

