/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcwde;

import com.sun.javacard.jcwde.ChannelInfo;

public class SimChannelManager {
    public static final byte NULL_CONTEXTID = 15;
    static ChannelInfo[] logicChannel = null;
    static byte maxChannels = (byte)-1;

    public static void init(byte maxChn) {
        maxChannels = maxChn;
        logicChannel = new ChannelInfo[maxChannels];
        int i = 0;
        while (i < maxChn) {
            SimChannelManager.logicChannel[i] = new ChannelInfo();
            logicChannel[i].setChannelInfo((byte)15, false);
            logicChannel[i].closeChannel();
            ++i;
        }
        logicChannel[0].openChannel();
    }

    public static byte getActiveContext(byte channelID) {
        return logicChannel[channelID].getActiveContext();
    }

    public static void setChannelInfo(byte channelID, byte ContextID, boolean isMultiSelect) {
        logicChannel[channelID].setChannelInfo(ContextID, isMultiSelect);
    }

    public static boolean isPkgMultiSelectable(byte channelID) {
        return logicChannel[channelID].isPkgMultiSelectable();
    }

    public static boolean isChannelOpen(byte channelID) {
        return logicChannel[channelID].isChannelOpen();
    }

    public static boolean openChannel(byte channelID) {
        return logicChannel[channelID].openChannel();
    }

    public static boolean closeChannel(byte channelID) {
        return logicChannel[channelID].closeChannel();
    }

    public static byte getMaxChannels() {
        return maxChannels;
    }

    public static byte openAvailableChannel() {
        byte foundChannel = -1;
        byte i = 1;
        while (i < maxChannels) {
            if (!logicChannel[i].isChannelOpen()) {
                foundChannel = i;
                logicChannel[i].openChannel();
                break;
            }
            i = (byte)(i + 1);
        }
        return foundChannel;
    }

    public static boolean isAppletActive(int contextID) {
        if (contextID == 15) {
            return false;
        }
        boolean activeApp = false;
        byte i = 0;
        while (i < maxChannels) {
            if (logicChannel[i].getActiveContext() == contextID && logicChannel[i].isChannelOpen()) {
                activeApp = true;
            }
            i = (byte)(i + 1);
        }
        return activeApp;
    }

    public static boolean isContextActive(byte contextID) {
        if (contextID == 15) {
            return false;
        }
        boolean activePkg = false;
        byte tgtCtx = (byte)(contextID & 0xFFFFFFF0);
        byte i = 0;
        while (i < maxChannels) {
            byte pkgCtx = logicChannel[i].getActiveContext();
            if (pkgCtx != 15 && tgtCtx == (pkgCtx = (byte)(pkgCtx & 0xFFFFFFF0)) && logicChannel[i].isChannelOpen()) {
                activePkg = true;
            }
            i = (byte)(i + 1);
        }
        return activePkg;
    }

    public static boolean isPkgMultiSelected(byte contextID) {
        boolean isMS = false;
        int targetCount = 0;
        if (contextID == 15) {
            return false;
        }
        byte tgtCtx = (byte)(contextID & 0xF0);
        int i = 0;
        while (i < maxChannels) {
            int pkgCtx = logicChannel[i].getActiveContext() & 0xFF;
            if (pkgCtx != 15 && tgtCtx == (pkgCtx = (int)((byte)(pkgCtx & 0xF0))) && logicChannel[i].isChannelOpen()) {
                targetCount = (byte)(targetCount + 1);
            }
            ++i;
        }
        if (targetCount > 1) {
            isMS = true;
        }
        return isMS;
    }

    public static boolean isAppletMultiSelected(byte contextID) {
        boolean isMS = false;
        int targetCount = 0;
        if (contextID == 15) {
            return false;
        }
        byte i = 0;
        while (i < maxChannels) {
            byte pkgCtx = (byte)(logicChannel[i].getActiveContext() & 0xFF);
            if (contextID == pkgCtx && logicChannel[i].isChannelOpen()) {
                ++targetCount;
            }
            i = (byte)(i + 1);
        }
        if (targetCount > 1) {
            isMS = true;
        }
        return isMS;
    }

    public static boolean isShareableAccessAllowed(byte contextID) {
        if (!SimChannelManager.isContextActive(contextID)) {
            return true;
        }
        boolean msFlag = false;
        byte tgtCtx = (byte)(contextID & 0xF0);
        byte i = 0;
        while (i < maxChannels) {
            int pkgCtx = logicChannel[i].getActiveContext();
            if (pkgCtx != 15 && tgtCtx == (pkgCtx &= 0xF0) && logicChannel[i].isChannelOpen()) {
                msFlag = logicChannel[i].isPkgMultiSelectable();
            }
            i = (byte)(i + 1);
        }
        return msFlag;
    }

    public static boolean isAppletSelectionAllowed(int contextID) {
        int tgtCtx = contextID & 0xF0;
        if (contextID == 15) {
            return true;
        }
        byte i = 0;
        while (i < maxChannels) {
            int pkgCtx = logicChannel[i].getActiveContext();
            if (pkgCtx != 15 && tgtCtx == (pkgCtx &= 0xF0) && logicChannel[i].isChannelOpen() && !logicChannel[i].isPkgMultiSelectable()) {
                return false;
            }
            i = (byte)(i + 1);
        }
        return true;
    }
}

