/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamWriter;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class UTF8_Writer
extends StreamWriter {
    private static boolean SUB_MODE = true;
    private static byte SUB_BYTE = (byte)63;
    private int charOff;
    private int byteOff;
    private int badInputLength;
    private char highHalfZoneCode;

    @Override
    public synchronized void write(int c) throws IOException {
        if (this.closed) {
            throw new IOException("CLOSED");
        }
        this.write(new char[]{(char)c}, 0, 1);
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("CLOSED");
        }
        int size = this.sizeOf(cbuf, off, len);
        byte[] bbuf = new byte[Math.max(size, 4)];
        NativeMethods.setGloballyAccessible(bbuf);
        int count = this.convert(cbuf, off, len, bbuf, 0, bbuf.length);
        this.out.write(bbuf, 0, count);
    }

    @Override
    public synchronized void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }

    @Override
    public int sizeOf(char[] array, int offset, int length) {
        return length * 3;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("CLOSED");
        }
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new IOException("UTF8_Writer: Malformed UTF-8 input.");
        }
        this.charOff = 0;
        this.byteOff = 0;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws IOException {
        char inputChar;
        byte[] outputByte = new byte[6];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (!SUB_MODE && this.badInputLength != 0) {
            this.charOff += this.badInputLength;
            this.badInputLength = 0;
        }
        if (this.highHalfZoneCode != '\u0000') {
            inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                int ucs4 = (inputChar - 55296) * 1024 + (input[inOff] - 56320) + 65536;
                output[0] = (byte)(0xF0 | ucs4 >> 18 & 7);
                output[1] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                output[2] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                output[3] = (byte)(0x80 | ucs4 & 0x3F);
                this.byteOff += 4;
                ++this.charOff;
            } else {
                this.badInputLength = 0;
                if (!SUB_MODE) throw new IOException("UTF8_Writer: Malformed UTF-8 input.");
                output[0] = SUB_BYTE;
                ++this.byteOff;
            }
        }
        while (this.charOff < inEnd) {
            int outputSize;
            int inputSize;
            inputChar = input[this.charOff];
            if (inputChar < '\u0080') {
                outputByte[0] = (byte)inputChar;
                inputSize = 1;
                outputSize = 1;
            } else if (inputChar < '\u0800') {
                outputByte[0] = (byte)(0xC0 | inputChar >> 6 & 0x1F);
                outputByte[1] = (byte)(0x80 | inputChar & 0x3F);
                inputSize = 1;
                outputSize = 2;
            } else if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                if (this.charOff + 1 >= inEnd) {
                    this.highHalfZoneCode = inputChar;
                    return this.byteOff - outOff;
                }
                char lowChar = input[this.charOff + 1];
                if (lowChar < '\udc00' || lowChar > '\udfff') {
                    this.badInputLength = 1;
                    if (!SUB_MODE) throw new IOException("UTF8_Writer: Malformed UTF-8 input.");
                    output[0] = SUB_BYTE;
                    outputSize = 1;
                    inputSize = this.badInputLength;
                    this.badInputLength = 0;
                } else {
                    int ucs4 = (inputChar - 55296) * 1024 + (lowChar - 56320) + 65536;
                    outputByte[0] = (byte)(0xF0 | ucs4 >> 18 & 7);
                    outputByte[1] = (byte)(0x80 | ucs4 >> 12 & 0x3F);
                    outputByte[2] = (byte)(0x80 | ucs4 >> 6 & 0x3F);
                    outputByte[3] = (byte)(0x80 | ucs4 & 0x3F);
                    outputSize = 4;
                    inputSize = 2;
                }
            } else {
                outputByte[0] = (byte)(0xE0 | inputChar >> 12 & 0xF);
                outputByte[1] = (byte)(0x80 | inputChar >> 6 & 0x3F);
                outputByte[2] = (byte)(0x80 | inputChar & 0x3F);
                inputSize = 1;
                outputSize = 3;
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new IOException("UTF8_Writer: Conversion buffer full.");
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }
}

