/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import com.sun.javacard.BootstrapClassLoader;
import com.sun.javacard.Logger;
import com.sun.javacard.file.FileConnection;
import com.sun.javacard.impl.NativeMethods;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class ClassLoader {
    private static Hashtable<Thread, ClassLoader> loaders = ClassLoader.getNewLoadersHashtable();
    protected ClassLoader parent;
    protected int id;
    protected boolean preloaded;
    protected String classPath;
    private int bundleID;
    private int appType;

    private static Hashtable<Thread, ClassLoader> getNewLoadersHashtable() {
        Hashtable<Thread, ClassLoader> ht = new Hashtable<Thread, ClassLoader>();
        NativeMethods.setJCREentry(ht, false);
        return ht;
    }

    public static void setCurrentClassLoader(ClassLoader loader) {
        Thread thread = Thread.currentThread();
        if (loader == null) {
            loaders.remove(thread);
        } else {
            loaders.put(thread, loader);
        }
    }

    public static ClassLoader getCurrentClassLoader() {
        return loaders.get(Thread.currentThread());
    }

    ClassLoader() {
    }

    ClassLoader(ClassLoader parent, String classPath, int level) {
        if (classPath == null) {
            classPath = "";
        }
        if (!classPath.endsWith("/")) {
            classPath = classPath + "/";
        }
        this.id = this.getNextAvailableID0();
        this.parent = parent;
        this.classPath = classPath;
        this.initClassLoader0(this.id, parent.id, this.classPath, level, 0);
    }

    public final int getID() {
        return this.id;
    }

    public final boolean isPreloaded() {
        return this.preloaded;
    }

    public final void setPreloaded(boolean preloaded) {
        Logger.debug("ClassLoader::setPreloaded(" + preloaded + "). CLID: " + this.id + ", classPath: " + this.classPath + ", preloaded: " + this.preloaded);
        if (this.isPreloaded()) {
            return;
        }
        this.preloaded = preloaded;
        this.setPreloaded0(this.id, preloaded);
    }

    public void setClassPath(String classPath) {
        if (classPath != null && !classPath.endsWith("/")) {
            classPath = classPath + "/";
        }
        if (classPath == null) {
            classPath = "";
        }
        this.classPath = classPath;
        this.setClassPath0(this.id, classPath);
    }

    public void setBundleID(int bundleID) {
        this.bundleID = bundleID;
        this.setBundleID0(this.id, bundleID);
    }

    public int getBundleID() {
        return this.bundleID;
    }

    public void setAppType(int appType) {
        this.appType = appType;
        this.setAppType0(this.id, appType);
    }

    public String getClassPath() {
        return this.classPath;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.length() <= 0 || name.indexOf(47) != -1 || name.indexOf(91) != -1) {
            throw new ClassNotFoundException(name);
        }
        return this.loadClass0(this.id, name);
    }

    public void freeClasses(int bundleId) {
        this.freeClasses0(bundleId, this.id);
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = null;
        Logger.debug("    getResourceAsStream()", name);
        Logger.debug("    ", name);
        if (this.parent != null) {
            is = this.parent.getResourceAsStream(name);
        }
        if (is == null && this.classPath != null) {
            StringTokenizer st = new StringTokenizer(this.classPath, " :");
            String cpElement = null;
            FileConnection fc = null;
            while (st.hasMoreTokens()) {
                cpElement = st.nextToken();
                Logger.verbose("cpelement and name are    ", cpElement, name);
                fc = new FileConnection(cpElement, name);
                try {
                    if (!fc.exists()) continue;
                    is = fc.openInputStream();
                    if (NativeMethods.getCurrentContext() != 0 || NativeMethods.getPreviousContext() == 0) break;
                    NativeMethods.transferOwnershipToPreviousContext(is);
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return is;
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        return BootstrapClassLoader.getBootstrapClassLoader();
    }

    public void initSIPromoting(Vector<String> siList, Vector<String> spList) {
        StringBuffer shareableClasses = new StringBuffer();
        StringBuffer sealedPackages = new StringBuffer();
        if (siList != null && siList.size() > 0) {
            for (String str : siList) {
                shareableClasses.append(str + ",");
            }
        }
        if (spList != null && spList.size() > 0) {
            for (String str : spList) {
                sealedPackages.append(str + ",");
            }
        }
        this.initSIPromoting0(shareableClasses.toString(), sealedPackages.toString(), this.id);
    }

    private native void initSIPromoting0(String var1, String var2, int var3);

    public native void processShareables();

    public native void doneSIPromoting();

    protected native Class<?> loadClass0(int var1, String var2) throws ClassNotFoundException;

    private native void setPreloaded0(int var1, boolean var2);

    protected native void initClassLoader0(int var1, int var2, String var3, int var4, int var5);

    protected native void setClassPath0(int var1, String var2);

    protected native void setBundleID0(int var1, int var2);

    protected native void setAppType0(int var1, int var2);

    protected native short getNextAvailableID0();

    protected native void freeClasses0(int var1, int var2);
}

