/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard;

import com.sun.javacard.ClassLoader;
import com.sun.javacard.ThreadHashtable;
import com.sun.javacard.impl.NativeMethods;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;

public class ContextManager {
    private static ContextManager cm;
    private ThreadHashtable<ContextHandler.Context> currentContexts = new ThreadHashtable();
    private ThreadHashtable<State> savedStates = new ThreadHashtable();
    private ThreadHashtable<Request> currentRequest = new ThreadHashtable();

    public static void initContextManager() {
        if (cm == null) {
            cm = new ContextManager();
            NativeMethods.setJCREentry(cm, true);
        }
    }

    private ContextManager() {
    }

    void saveCurrentState() {
        ClassLoader oldClassloader = ClassLoader.getCurrentClassLoader();
        ContextHandler.Context oldcontext = ContextManager.cm.currentContexts.get();
        this.savedStates.set(new State(oldcontext, oldClassloader));
    }

    void restoreSavedState() {
        State state = this.savedStates.get();
        ContextManager.cm.currentContexts.set(state.context);
        ClassLoader.setCurrentClassLoader(state.classLoader);
    }

    void setCurrentContextInContextList(ContextHandler.Context context) {
        this.currentContexts.set(context);
    }

    ContextHandler.Context getConextForCurrentThread() {
        return this.currentContexts.get();
    }

    Request getRequestForCurrentThread() {
        return this.currentRequest.get();
    }

    void setCurrentRequestInRequestList(Request request) {
        this.currentRequest.set(request);
    }

    public static Request getCurrentRequest() {
        return cm.getRequestForCurrentThread();
    }

    public static void setCurrentRequest(Request request) {
        cm.setCurrentRequestInRequestList(request);
    }

    public static ContextHandler.Context getCurrentContext() {
        return cm.getConextForCurrentThread();
    }

    public static void setCurrentContext(ContextHandler.Context context) {
        cm.setCurrentContextInContextList(context);
    }

    public static void saveState() {
        cm.saveCurrentState();
    }

    public static void restoreState() {
        cm.restoreSavedState();
    }

    public static void resetContexts(ContextHandler.Context context) {
        cm.resetCons(context.getContextPath());
    }

    void resetCons(String path) {
        this.currentContexts.removeContext(path);
        this.currentRequest = new ThreadHashtable();
    }

    private static class State {
        ContextHandler.Context context;
        ClassLoader classLoader;

        State(ContextHandler.Context ctxt, ClassLoader clLoader) {
            this.context = ctxt;
            this.classLoader = clLoader;
        }
    }
}

