/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.appletcontainer;

import com.sun.javacard.appletcontainer.APDUDispatcher;
import com.sun.javacard.impl.NativeMethods;
import java.util.Vector;

public class ChannelManager {
    public static final int MAX_CHANNELS = 20;
    public static final short NULL_CONTEXT = -1;
    public static final byte OP_CHANNEL_CLOSE = 0;
    public static final byte OP_CHANNEL_OPEN = 1;
    public static final byte OP_CHANNEL_OPEN_AUTOSELECT = 2;
    public static final byte CHANNEL_CLOSED = 0;
    public static final byte CHANNEL_DISABLED = 1;
    public static final byte CHANNEL_OPEN = 2;
    public static final byte CHANNEL_OPEN_MS = 3;
    public static final byte APPLET_MULTISELECTED = 8;
    public static final byte APPLET_ACTIVE = 4;
    public static final byte CONTEXT_MULTISELECTED = 2;
    public static final byte CONTEXT_ACTIVE = 1;
    private short[] contexts = new short[20];
    private byte[] statuses = new byte[20];
    private byte currentChannel;
    private APDUDispatcher dispatcher;
    private int interfaceID;

    public ChannelManager(APDUDispatcher dispatcher, int interfaceID) {
        this.dispatcher = dispatcher;
        this.interfaceID = interfaceID;
        this.reset();
    }

    private void reset() {
        this.currentChannel = 0;
        for (int i = 0; i < 20; ++i) {
            this.contexts[i] = -1;
            this.statuses[i] = i == this.currentChannel ? 2 : 0;
        }
    }

    public void deselectAll() {
        for (int i = 0; i < 20; ++i) {
            if (this.statuses[i] == 0) continue;
            this.dispatcher.deselectOnly((byte)i, true);
        }
        this.reset();
    }

    public boolean isValidChannel(int channel) {
        return channel >= 0 && channel < 20;
    }

    public void setCurrentChannel(byte currentChannel) {
        this.currentChannel = currentChannel;
    }

    public byte getCurrentChannel() {
        return this.currentChannel;
    }

    public short getCurrentContext() {
        return this.contexts[this.currentChannel];
    }

    public short getContext(byte channel) {
        return this.contexts[channel];
    }

    public byte getCurrentAppID() {
        return (byte)(this.contexts[this.currentChannel] & 0xFF);
    }

    public byte getAppID(byte channel) {
        return (byte)(this.contexts[channel] & 0xFF);
    }

    public byte getCurrentFirewallID() {
        return (byte)(this.contexts[this.currentChannel] >> 8 & 0xFF);
    }

    public byte getFirewallID(byte channel) {
        return (byte)(this.contexts[channel] >> 8 & 0xFF);
    }

    public void setCurrentContext(short contextID) {
        this.contexts[this.currentChannel] = contextID;
    }

    public boolean setContext(byte channel, short context) {
        if (!this.isValidChannel(channel)) {
            return false;
        }
        this.contexts[channel] = context;
        return true;
    }

    public byte getCurrentStatus() {
        return this.statuses[this.currentChannel];
    }

    public byte getStatus(byte channel) {
        return this.statuses[channel];
    }

    public byte[] getActiveAppIDs() {
        Vector<Byte> appIDs = new Vector<Byte>();
        for (int i = 0; i < 20; ++i) {
            if (this.contexts[i] == -1) continue;
            appIDs.addElement((byte)(this.contexts[i] & 0xFF));
        }
        byte[] ids = new byte[appIDs.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = (Byte)appIDs.elementAt(i);
        }
        return ids;
    }

    public int getMaxChannels() {
        return 20;
    }

    public byte manageChannel(byte channel, byte operation) {
        byte status = 0;
        int retValue = -1;
        if (this.isValidChannel(channel)) {
            status = this.statuses[channel];
        }
        switch (operation) {
            case 1: {
                if (status != 0) break;
                this.statuses[channel] = 2;
                retValue = 0;
                break;
            }
            case 0: {
                if (status == 0) break;
                this.statuses[channel] = 0;
                retValue = 0;
                break;
            }
            case 2: {
                channel = this.getAvailableChannel();
                if (channel < 0) {
                    retValue = -1;
                    break;
                }
                this.statuses[channel] = 2;
                retValue = channel;
            }
        }
        return (byte)retValue;
    }

    byte getAvailableChannel() {
        byte channel = 0;
        for (channel = 0; channel < 20; channel = (byte)(channel + 1)) {
            if (this.statuses[channel] != 0) continue;
            return channel;
        }
        return -1;
    }

    public byte getContextStatus(short context, byte status) {
        if (context == -1) {
            return 0;
        }
        byte firewallID = (byte)(context >> 8 & 0xFF);
        byte appID = (byte)(context & 0xFF);
        for (byte i = 0; i < 20; i = (byte)(i + 1)) {
            if (this.getFirewallID(i) != firewallID) continue;
            status = (status & 1) != 0 ? (byte)(status | 2) : (byte)(status | 1);
            if (this.getAppID(i) != appID) continue;
            status = (status & 4) != 0 ? (byte)(status | 8) : (byte)(status | 4);
        }
        return status;
    }

    public boolean isAppContextActiveOnAnotherChannel(byte context) {
        for (byte i = 0; i < 20; i = (byte)(i + 1)) {
            byte channelContext = this.getFirewallID(i);
            if (channelContext != context || i == this.currentChannel) continue;
            return true;
        }
        return false;
    }

    public void clearTransientObjs(byte channel, int event) {
        if (!this.isValidChannel(channel)) {
            return;
        }
        if (event == 2) {
            NativeMethods.clearTransientObjects(this.getFirewallID(channel));
        }
    }

    public void resetChannelInfoNative() {
        this.resetChannelInfoNative0(this.interfaceID);
    }

    public native void resetChannelInfoNative0(int var1);

    public void saveChannelInfoNative(boolean classicApplet) {
        this.saveChannelInfoNative0(this.interfaceID, this.getCurrentChannel(), this.getCurrentAppID(), this.getCurrentFirewallID(), classicApplet);
    }

    public native void saveChannelInfoNative0(int var1, byte var2, byte var3, byte var4, boolean var5);
}

