/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl;

import com.sun.javacard.cm.impl.ApplicationBundleImpl;
import com.sun.javacard.cm.impl.ApplicationImpl;
import com.sun.javacard.cm.impl.IDManager;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.jcre.JCRuntime;
import com.sun.javacard.security.X509CredentialManager;
import com.sun.javacard.spi.cardmgmt.Application;
import com.sun.javacard.spi.security.ProtectionDomain;
import com.sun.javacard.util.JCSystemAccessor;
import com.sun.javacard.util.PathLookupTable;
import com.sun.midp.io.Base64;
import com.sun.midp.pki.X509Certificate;
import com.sun.spot.security.Signature;
import com.sun.spot.security.implementation.RSAPrivateKey;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javacard.security.PrivateKey;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.ContextPermission;
import javacardx.security.CredentialManager;

public class SecurityUtil {
    private static SecurityUtil instance;

    public static void initSecurityUtil() {
        instance = new SecurityUtil();
        NativeMethods.setJCREentry(instance, false);
    }

    public static SecurityUtil getSecurityUtilInstance() {
        return instance;
    }

    public boolean verifyBundleSig(String base64cert, String sigStr, byte[] jarData) {
        Signature signature;
        X509Certificate cert = this.getCert(base64cert);
        try {
            signature = Signature.getInstance((String)"MD5WithRSA");
            signature.initVerify(cert.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        byte[] sig = null;
        try {
            sig = Base64.decode(sigStr);
        }
        catch (IOException e) {
            return false;
        }
        try {
            signature.update(jarData, 0, jarData.length);
            if (!signature.verify(sig)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private X509Certificate getCert(String base64cert) {
        X509Certificate cert = null;
        byte[] derCert = null;
        try {
            derCert = Base64.decode(base64cert);
        }
        catch (IOException e) {
            return null;
        }
        try {
            cert = X509Certificate.generateCertificate(derCert, 0, derCert.length);
        }
        catch (IOException e) {
            return null;
        }
        return cert;
    }

    public CredentialManager createCredentialManager(byte[] caRootCertificateBytes, byte[] serverCertBytes, byte[] sslPrivKeyModBytes, byte[] sslPrivKeyExpBytes, byte[] acceptedIssuerBytes) throws Exception {
        X509Certificate sCert;
        String sslPrivKeyExp;
        String sslPrivKeyMod;
        Vector<String> caRootStrings = new Vector<String>();
        if (caRootCertificateBytes == null) {
            String s;
            int i = 0;
            while ((s = JCRuntime.getConfigProperty("ssl.trusted.ca." + i, null)) != null) {
                caRootStrings.addElement(s);
                ++i;
            }
        } else {
            caRootStrings.addElement(new String(caRootCertificateBytes));
        }
        Vector<String> acceptedIssuerStrings = new Vector<String>();
        if (acceptedIssuerBytes == null) {
            String s;
            int i = 0;
            while ((s = JCRuntime.getConfigProperty("ssl.accepted.issuer." + i, null)) != null) {
                acceptedIssuerStrings.addElement(s);
                ++i;
            }
        } else {
            acceptedIssuerStrings.addElement(new String(acceptedIssuerBytes));
        }
        String serverCertStr = serverCertBytes == null ? JCRuntime.getConfigProperty("ssl.selfIdentityAsServer", null) : new String(serverCertBytes);
        if (sslPrivKeyModBytes == null || sslPrivKeyExpBytes == null) {
            sslPrivKeyMod = JCRuntime.getConfigProperty("ssl.selfIdentitySSLPrivateKeyMod", null);
            sslPrivKeyExp = JCRuntime.getConfigProperty("ssl.selfIdentitySSLPrivateKeyExp", null);
        } else {
            sslPrivKeyMod = new String(sslPrivKeyModBytes);
            sslPrivKeyExp = new String(sslPrivKeyExpBytes);
        }
        byte[] der = null;
        byte[] mod = null;
        byte[] exp = null;
        try {
            der = Base64.decode(serverCertStr);
        }
        catch (IOException e) {
            throw new Exception(String.valueOf(4012));
        }
        try {
            sCert = X509Certificate.generateCertificate(der, 0, der.length);
        }
        catch (IOException e) {
            throw new Exception(String.valueOf(4013));
        }
        try {
            mod = Base64.decode(sslPrivKeyMod);
        }
        catch (IOException e) {
            throw new Exception(String.valueOf(4012));
        }
        try {
            exp = Base64.decode(sslPrivKeyExp);
        }
        catch (IOException e) {
            throw new Exception(String.valueOf(4012));
        }
        RSAPrivateKey privKey = new RSAPrivateKey(mod, exp);
        Vector<X509Certificate> caRoots = new Vector<X509Certificate>();
        Enumeration enumeration = caRootStrings.elements();
        while (enumeration.hasMoreElements()) {
            try {
                der = Base64.decode((String)enumeration.nextElement());
            }
            catch (IOException e) {
                throw new Exception(String.valueOf(4012));
            }
            try {
                caRoots.addElement(X509Certificate.generateCertificate(der, 0, der.length));
            }
            catch (IOException e) {
                throw new Exception(String.valueOf(4013));
            }
        }
        Vector<X509Certificate> acceptedIssuers = new Vector<X509Certificate>();
        enumeration = acceptedIssuerStrings.elements();
        while (enumeration.hasMoreElements()) {
            try {
                der = Base64.decode((String)enumeration.nextElement());
            }
            catch (IOException e) {
                throw new Exception(String.valueOf(4012));
            }
            try {
                acceptedIssuers.addElement(X509Certificate.generateCertificate(der, 0, der.length));
            }
            catch (IOException e) {
                throw new Exception(String.valueOf(4013));
            }
        }
        X509Certificate[] certificateChain = new X509Certificate[]{sCert};
        Object[] trustedCertificates = new X509Certificate[caRoots.size()];
        caRoots.copyInto(trustedCertificates);
        Object[] acceptedIssuerCertificates = new X509Certificate[acceptedIssuers.size()];
        acceptedIssuers.copyInto(acceptedIssuerCertificates);
        X509CredentialManager aCredentialMgr = new X509CredentialManager((PrivateKey)privKey, certificateChain, (X509Certificate[])trustedCertificates, (X509Certificate[])acceptedIssuerCertificates);
        if (NativeMethods.getPreviousContext() != 0) {
            NativeMethods.transferOwnershipToPreviousContext(aCredentialMgr);
        }
        return aCredentialMgr;
    }

    public static void updateAppPDMatrix(int currentAppId, String currentAppUri, ApplicationBundleImpl appBundle) {
        String allUri = "/*";
        ProtectionDomain currentAppPD = appBundle.doGetProtectionDomain();
        int max = IDManager.getLastAppID();
        int c = max / 32;
        int arrSize = max % 32 > 0 ? c * 32 + 32 : c * 32;
        byte[] accessToApp = new byte[arrSize];
        byte[] accessFromApp = new byte[arrSize];
        Vector<Application> createdApps = ApplicationImpl.getCreatedApps();
        PathLookupTable<ServiceFactory> serviceRegistry = JCSystemAccessor.getJCSystemAccessor().getServiceRegistry();
        block0: for (int i = 0; i < createdApps.size(); ++i) {
            Vector<String> standardURIs;
            ApplicationImpl app = (ApplicationImpl)createdApps.elementAt(i);
            int appId = app.getApplicationId();
            ProtectionDomain appPD = ((ApplicationBundleImpl)app.getApplicationGroup()).doGetProtectionDomain();
            if (appPD.getName().equals(currentAppPD.getName())) {
                accessToApp[appId - 1] = 1;
                accessFromApp[appId - 1] = 1;
                continue;
            }
            if (currentAppPD.implies(new ContextPermission("pd:" + appPD.getName(), "switch")) || currentAppPD.implies(new ContextPermission(allUri, "switch")) || currentAppPD.implies(new ContextPermission(app.getAppURI(), "switch"))) {
                accessToApp[appId - 1] = 1;
            } else if (serviceRegistry.containsStandardURI(app.getAppURI())) {
                standardURIs = serviceRegistry.getStandardURI(app.getAppURI());
                for (String uri : standardURIs) {
                    if (!currentAppPD.implies(new ContextPermission(uri, "switch"))) continue;
                    accessToApp[appId - 1] = 1;
                    break;
                }
            }
            if (appPD.implies(new ContextPermission("pd:" + currentAppPD.getName(), "switch")) || appPD.implies(new ContextPermission(allUri, "switch")) || appPD.implies(new ContextPermission(currentAppUri, "switch"))) {
                accessFromApp[appId - 1] = 1;
                continue;
            }
            if (!serviceRegistry.containsStandardURI(currentAppUri)) continue;
            standardURIs = serviceRegistry.getStandardURI(currentAppUri);
            for (String uri : standardURIs) {
                if (!appPD.implies(new ContextPermission(uri, "switch"))) continue;
                accessFromApp[appId - 1] = 1;
                continue block0;
            }
        }
        accessToApp[currentAppId - 1] = 1;
        accessFromApp[currentAppId - 1] = 1;
        SecurityUtil.setToAppPDMatrix(currentAppId, accessToApp);
        SecurityUtil.setFromAppPDMatrix(currentAppId, accessFromApp);
    }

    public static void updatePDMatrixForStandardNS(String currentAppURI, String standardURI) {
        String allUri = "/*";
        Application currentApp = Application.lookup(currentAppURI);
        int currentAppId = ((ApplicationImpl)currentApp).getApplicationId();
        ApplicationBundleImpl bundle = (ApplicationBundleImpl)currentApp.getApplicationGroup();
        ProtectionDomain currentAppPD = bundle.doGetProtectionDomain();
        int max = IDManager.getLastAppID();
        int c = max / 32;
        int arrSize = max % 32 > 0 ? c * 32 + 32 : c * 32;
        byte[] accessFromApp = new byte[arrSize];
        Vector<Application> createdApps = ApplicationImpl.getCreatedApps();
        for (int i = 0; i < createdApps.size(); ++i) {
            ApplicationImpl app = (ApplicationImpl)createdApps.elementAt(i);
            int appId = app.getApplicationId();
            ProtectionDomain appPD = ((ApplicationBundleImpl)app.getApplicationGroup()).doGetProtectionDomain();
            if (appPD.getName().equals(currentAppPD.getName())) {
                accessFromApp[appId - 1] = 1;
                continue;
            }
            if (appPD.implies(new ContextPermission("pd:" + currentAppPD.getName(), "switch")) || appPD.implies(new ContextPermission(allUri, "switch")) || appPD.implies(new ContextPermission(currentAppURI, "switch"))) {
                accessFromApp[appId - 1] = 1;
                continue;
            }
            if (standardURI == null || !appPD.implies(new ContextPermission(standardURI, "switch"))) continue;
            accessFromApp[appId - 1] = 1;
        }
        accessFromApp[currentAppId - 1] = 1;
        SecurityUtil.setFromAppPDMatrix(currentAppId, accessFromApp);
    }

    public static native void resetAppPDMatrix(int var0);

    private static native void setToAppPDMatrix(int var0, byte[] var1);

    private static native void setFromAppPDMatrix(int var0, byte[] var1);
}

