/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.impl.applethandler;

import com.sun.javacard.Logger;
import com.sun.javacard.cm.impl.applethandler.AppletElementNotSupportedException;
import com.sun.javacard.cm.impl.applethandler.AppletInfo;
import com.sun.javacard.cm.impl.jcrd.FormatErrorException;
import com.sun.javacard.jaxp.org.xml.sax.SAXException;
import com.sun.javacard.util.APDUUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import org.mortbay.xml.XmlParser;

public class AppletApplicationDescriptor {
    private Vector<AppletInfo> appletsInfoList;

    public AppletApplicationDescriptor(InputStream is) throws IOException, SAXException, FormatErrorException, AppletElementNotSupportedException {
        Logger.debug("Parsing applet.xml");
        this.appletsInfoList = new Vector();
        XmlParser xp = new XmlParser();
        XmlParser.Node node = xp.parse(is);
        Logger.debug("Node is:" + node);
        this.verifyVersion(node);
        Iterator<Object> iter = node.iterator();
        XmlParser.Node node1 = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node1 = (XmlParser.Node)o;
            String element = node1.getTag();
            if ("description".equals(element)) {
                Logger.debug("desc." + element);
                continue;
            }
            if ("display-name".equals(element)) {
                Logger.debug("display" + element);
                continue;
            }
            if ("applet".equals(element)) {
                Logger.debug("populate applet info list");
                this.populateAppletInfoList(node1);
                continue;
            }
            throw new AppletElementNotSupportedException(element);
        }
        if (this.appletsInfoList.isEmpty()) {
            throw new FormatErrorException("4310");
        }
    }

    private void populateAppletInfoList(XmlParser.Node node) throws FormatErrorException {
        String aAID = node.getString("applet-AID", false, true);
        if (aAID == null) {
            throw new FormatErrorException("4301", "<applet-AID>\n<applet>");
        }
        if (!APDUUtil.isValidAID(aAID)) {
            throw new FormatErrorException("4302", "<applet-AID>\n<applet>");
        }
        Logger.debug("AID" + aAID);
        for (AppletInfo a : this.appletsInfoList) {
            if (!a.getAID().equals(aAID)) continue;
            throw new FormatErrorException("4303", aAID + "\n" + "<applet-AID>");
        }
        String appletClassName = node.getString("applet-class", false, true);
        if (appletClassName == null) {
            throw new FormatErrorException("4301", "<applet-class>\n<applet>");
        }
        if (appletClassName.equals("")) {
            throw new FormatErrorException("4302", "<applet-class>\n<applet>");
        }
        Logger.debug("Applet class" + appletClassName);
        AppletInfo appletInfo = new AppletInfo(appletClassName, aAID);
        this.appletsInfoList.addElement(appletInfo);
    }

    private void verifyVersion(XmlParser.Node node) throws FormatErrorException {
        String element = node.getTag();
        String version = node.getAttribute("version");
        if (!element.equalsIgnoreCase("applet-app")) {
            throw new FormatErrorException("4306", "");
        }
        if (version == null) {
            throw new FormatErrorException("4307", "");
        }
        if (version == null || !version.equals("3.0")) {
            throw new FormatErrorException("4308", version);
        }
    }

    public Vector<AppletInfo> getAppletList() {
        return this.appletsInfoList;
    }

    public Vector<String> getAppletClasses() {
        Vector<String> classNames = new Vector<String>();
        for (AppletInfo i : this.appletsInfoList) {
            classNames.addElement(i.getClassName());
        }
        return classNames;
    }

    public AppletInfo getAppletWithAID(String aid) {
        Logger.debug("aid:" + aid);
        if (this.appletsInfoList != null) {
            for (AppletInfo appletInfo : this.appletsInfoList) {
                Logger.debug("appletInfo" + appletInfo);
                if (!aid.equalsIgnoreCase(appletInfo.getAID())) continue;
                return appletInfo;
            }
        }
        return null;
    }
}

