/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cm.registries;

import com.sun.javacard.cm.impl.ApplicationImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.TransientReference;
import org.mortbay.jetty.WebConnector;

public class SecureCommunicationInfoRegistry {
    private static Vector<Integer> reservedList = new Vector();
    private static Hashtable<String, WebConnector> redirectTable = new Hashtable();
    private static TransientReference<Hashtable<String, WebConnector>> dynamicRedirectTable = new TransientReference<Object>(null);
    private static Hashtable<Integer, ApplicationImpl> portMap = new Hashtable();

    public static WebConnector removeFromRedirectTable(String key) {
        if (key.startsWith("///")) {
            key = key.substring(2);
        }
        return redirectTable.remove(key);
    }

    public static WebConnector removeFromDynamicRedirectTable(String key) {
        Hashtable<String, WebConnector> h;
        if (key.startsWith("///")) {
            key = key.substring(2);
        }
        if ((h = dynamicRedirectTable.get()) != null) {
            return dynamicRedirectTable.get().remove(key);
        }
        return null;
    }

    public static void clearRedirectTable() {
        redirectTable.clear();
    }

    public static ApplicationImpl removeFromPortMap(int key) {
        return portMap.remove(key);
    }

    public static ApplicationImpl getApplicationFromPortMap(int port) {
        ApplicationImpl application = portMap.get(new Integer(port));
        return application;
    }

    public static void addToPortMap(int port, ApplicationImpl application) {
        portMap.put(new Integer(port), application);
    }

    public static void addToReservedList(int port) {
        reservedList.addElement(new Integer(port));
    }

    public static boolean isPortReserved(int port) {
        return reservedList.contains(new Integer(port));
    }

    public static void removeFromReservedList(int portNumber) {
        reservedList.removeElement(new Integer(portNumber));
    }

    public static void addToRedirectTable(String appURI, WebConnector connector) {
        if (appURI.startsWith("///")) {
            appURI = appURI.substring(2);
        }
        redirectTable.put(appURI, connector);
    }

    public static void addToDynamicRedirectTable(String appURI, WebConnector connector) {
        if (appURI.startsWith("///")) {
            appURI = appURI.substring(2);
        }
        Hashtable<String, WebConnector> h = null;
        h = dynamicRedirectTable.get();
        if (h == null) {
            h = new Hashtable();
            dynamicRedirectTable.set(h);
        }
        h.put(appURI, connector);
    }

    public static boolean isContextInRedirectTable(String appURI) {
        if (appURI.startsWith("///")) {
            appURI = appURI.substring(2);
        }
        if (redirectTable.containsKey(appURI)) {
            return true;
        }
        Hashtable<String, WebConnector> h = dynamicRedirectTable.get();
        return h != null && h.containsKey(appURI);
    }

    public static boolean isContextInStaticRedirectTable(String appURI) {
        if (appURI.startsWith("///")) {
            appURI = appURI.substring(2);
        }
        return redirectTable.containsKey(appURI);
    }

    public static boolean isContextInDynamicRedirectTable(String appURI) {
        Hashtable<String, WebConnector> h;
        if (appURI.startsWith("///")) {
            appURI = appURI.substring(2);
        }
        return (h = dynamicRedirectTable.get()) != null && h.containsKey(appURI);
    }

    public static int getPortFromContext(String appURI) {
        Hashtable<String, WebConnector> h;
        WebConnector connector;
        if (appURI.startsWith("///")) {
            appURI = appURI.substring(2);
        }
        if ((connector = redirectTable.get(appURI)) == null && dynamicRedirectTable != null && (h = dynamicRedirectTable.get()) != null) {
            connector = h.get(appURI);
        }
        if (connector == null) {
            return -1;
        }
        assert (connector != null) : "Unexpected null";
        return connector.getLocalPort();
    }

    public static boolean isPortInRedirectTable(int port) {
        boolean result = false;
        Enumeration<WebConnector> connectors = redirectTable.elements();
        while (connectors.hasMoreElements()) {
            WebConnector connector = connectors.nextElement();
            if (connector.getLocalPort() != port) continue;
            return true;
        }
        Hashtable<String, WebConnector> h = dynamicRedirectTable.get();
        if (h != null) {
            Enumeration<WebConnector> enumeration = h.elements();
            while (enumeration.hasMoreElements()) {
                WebConnector connector = enumeration.nextElement();
                if (connector.getLocalPort() != port) continue;
                return true;
            }
        }
        return false;
    }

    public static Hashtable<String, WebConnector> getDynamicRedirectTable() {
        return dynamicRedirectTable.get();
    }
}

