/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.file;

import com.sun.javacard.URI;
import com.sun.javacard.file.FSHelper;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.util.URIUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javacardx.framework.JCSystem;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.io.ConnectorPermission;

@TransactionType(value=TransactionTypeValue.SUPPORTS)
public class FileConnection
implements javacardx.io.FileConnection {
    public static final char PATHSEPARATOR = '/';
    public static final String PATHSEPARATORSTRING = "/";
    private static final String URLSCHEME = "file://";
    private static final String WEBINF = "WEB-INF";
    private static final String METAINF = "META-INF";
    private static long tempFileCounter = 0L;
    private boolean deleteOnReset = false;
    private boolean accessCheck = false;
    private boolean closed = false;
    NativeInputStream is = null;
    NativeOutputStream os = null;
    private int mode = 3;
    boolean outputStreamOpened = false;
    boolean inputStreamOpened = false;
    private String name = null;
    private String path;
    int handle = 0;
    private static final String TMP = "/eeprom/tmp";
    static Hashtable<String, Vector<FileConnection>> openConnections = new Hashtable();
    static Hashtable<String, Vector<FileConnection>> inputStreams = new Hashtable();
    static Hashtable<String, Vector<FileConnection>> outputStreams = new Hashtable();
    static Hashtable<String, String> fileMap = new Hashtable();
    private static FSHelper fsHelper = new FSHelper();
    String actualPath = null;
    String docroot = null;
    String webinf = null;
    String metainf = null;

    public FileConnection(FileConnection parent, String name) {
        this(parent.getAbsolutePath(), name);
    }

    public FileConnection(String parentPath, String name) {
        if (parentPath == null) {
            parentPath = TMP;
        }
        this.name = name;
        this.path = parentPath;
        if (!this.path.endsWith(PATHSEPARATORSTRING)) {
            this.path = this.path + PATHSEPARATORSTRING;
        }
        this.path = this.path + name;
        this.name = name;
        this.fixPath();
        this.actualPath = this.path;
        this.mode = 3;
    }

    public FileConnection(String path) {
        this(path, false, 3);
        this.actualPath = path;
    }

    public FileConnection(String path, boolean accessCheck, int mode) {
        path = URIUtils.normalize(path);
        this.accessCheck = accessCheck;
        this.docroot = JCSystem.getURI() + "/docroot";
        this.webinf = this.docroot + PATHSEPARATORSTRING + WEBINF;
        this.metainf = this.docroot + PATHSEPARATORSTRING + METAINF;
        if (accessCheck) {
            String appURI = JCSystem.getURI();
            this.actualPath = fileMap.get(appURI);
            if (path.equals(this.webinf + "/classes") || path.startsWith(this.webinf + "/classes/") || path.equals(this.webinf + "/lib") || path.startsWith(this.webinf + "/lib/") || path.equals(this.webinf + "/web.xml") || path.equals(this.webinf + "/web.xml/") || path.equals(this.metainf) | path.startsWith(this.metainf + PATHSEPARATORSTRING)) {
                throw new SecurityException("FileConnection to this node cannot be opened");
            }
            if (!URIUtils.isInAppNamespace(path)) {
                throw new SecurityException("FileURL is not in applications file namespace");
            }
            this.actualPath = path.indexOf(appURI) != -1 ? this.actualPath + path.substring(appURI.length()) : this.actualPath + path;
            fsHelper.addToOpenConnections(this, this.actualPath);
            this.mode = mode;
        } else {
            this.actualPath = path;
        }
        if (path.charAt(0) != '/') {
            path = PATHSEPARATORSTRING + path;
        }
        this.path = path;
        int index = path.lastIndexOf(47);
        this.name = index == 0 ? PATHSEPARATORSTRING : path.substring(index + 1);
        this.fixPath();
    }

    public void setPathInternal(String path) {
        this.path = path;
        this.docroot = path + "/docroot";
        this.webinf = this.docroot + PATHSEPARATORSTRING + WEBINF;
        this.metainf = this.docroot + PATHSEPARATORSTRING + METAINF;
    }

    public static void addToMap(String appURI, String folder) {
        fileMap.put(appURI, folder);
    }

    public static String getFromMap(String appURI) {
        return fileMap.get(appURI);
    }

    public static void updateMap(String oldAppURI, String newAppURI) {
        String folderName = fileMap.get(oldAppURI);
        if (folderName == null) {
            return;
        }
        fileMap.remove(oldAppURI);
        fileMap.put(newAppURI, folderName);
    }

    public static void deleteFromMap(String appURI) {
        fileMap.remove(appURI);
    }

    @Override
    public FileConnection open(String fileURL) throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection is closed");
        }
        URI fileURI = new URI(fileURL);
        String s = URIUtils.resolveWithScheme("file", fileURL);
        if (!s.startsWith(URLSCHEME)) {
            throw new IllegalArgumentException();
        }
        fileURL = URIUtils.normalize(fileURL);
        if (fileURI.isAbsolute()) {
            int colon = fileURL.indexOf(58);
            fileURL = fileURL.substring(colon + 1);
        } else {
            fileURL = !fileURL.startsWith(PATHSEPARATORSTRING) ? this.path + '/' + fileURL : this.path + fileURL;
        }
        FileConnection child = new FileConnection(fileURL, this.accessCheck, 3);
        return child;
    }

    private void fixPath() {
        if (!this.path.startsWith(PATHSEPARATORSTRING)) {
            this.path = PATHSEPARATORSTRING + this.path;
        }
        if (this.path.endsWith(PATHSEPARATORSTRING)) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public boolean exists() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "read"));
        }
        return this.exists0(this.actualPath);
    }

    @Override
    public boolean isDirectory() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (!this.exists()) {
            return false;
        }
        return this.isDirectory0(this.actualPath);
    }

    public boolean isFile() {
        return this.isFile0(this.actualPath);
    }

    public void create() {
        if (this.handle != 0) {
            return;
        }
        this.handle = this.create0(this.actualPath, this.deleteOnReset, this.mode);
        if (this.handle != 0) {
            this.setLastModified0(this.handle, System.currentTimeMillis());
        }
    }

    public void makeApplicationRootDir() {
        if (this.handle != 0) {
            return;
        }
        this.handle = this.mkdirs0(this.actualPath, this.deleteOnReset, this.mode);
    }

    @Override
    public boolean createNewFile() throws IOException {
        if (!this.canCreateFileOrDir(true, false)) {
            return false;
        }
        if (this.handle != 0 || this.exists0(this.actualPath)) {
            return false;
        }
        this.handle = this.create0(this.actualPath, this.deleteOnReset, this.mode);
        if (this.handle == 0) {
            return false;
        }
        this.setLastModified0(this.handle, System.currentTimeMillis());
        return true;
    }

    boolean canCreateFileOrDir(boolean throwExceptionForReadPerm, boolean checkForWritePermssionsForParentDirs) throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (this.exists0(this.actualPath)) {
            return false;
        }
        if (!this.accessCheck) {
            return true;
        }
        FileConnection parentFile = this.getParentFile();
        while (parentFile != null && !parentFile.exists0(parentFile.actualPath)) {
            if (checkForWritePermssionsForParentDirs && this.accessCheck) {
                AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, parentFile.path), "write"));
            }
            FileConnection grandParent = parentFile.getParentFile();
            parentFile.close();
            parentFile = grandParent;
        }
        if (parentFile == null) {
            return false;
        }
        if (!parentFile.isWriteable() || !parentFile.isDirectory0(parentFile.actualPath)) {
            if (throwExceptionForReadPerm) {
                throw new IOException("Cannot create in non-writeable directory");
            }
            return false;
        }
        parentFile.close();
        return true;
    }

    @Override
    public boolean mkdir() throws IOException {
        boolean done;
        if (!this.canCreateFileOrDir(false, false)) {
            return false;
        }
        FileConnection parentFile = this.getParentFile();
        if (parentFile == null) {
            return false;
        }
        if (!(parentFile.exists0(parentFile.actualPath) && parentFile.isWriteable() && parentFile.isDirectory0(parentFile.actualPath))) {
            parentFile.close();
            return false;
        }
        this.handle = this.mkdirs0(this.actualPath, this.deleteOnReset, this.mode);
        boolean bl = done = this.handle != 0;
        if (done) {
            this.setLastModified0(this.handle, System.currentTimeMillis());
        }
        return done;
    }

    @Override
    public boolean mkdirs() throws IOException {
        boolean done;
        if (!this.canCreateFileOrDir(false, true)) {
            return false;
        }
        this.handle = this.mkdirs0(this.actualPath, this.deleteOnReset, this.mode);
        boolean bl = done = this.handle != 0;
        if (done) {
            this.setLastModified0(this.handle, System.currentTimeMillis());
        }
        return done;
    }

    @Override
    public boolean delete() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (!this.canWrite()) {
            return false;
        }
        if (!fsHelper.canDelete(!this.accessCheck, this, this.actualPath, false)) {
            return false;
        }
        boolean deleted = this.delete0(this.actualPath, true);
        if (deleted) {
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return deleted;
    }

    public boolean deleteInternal() {
        return this.delete0(this.actualPath, false);
    }

    @Override
    public boolean canRead() throws IOException {
        if (!this.exists()) {
            return false;
        }
        return this.isReadable();
    }

    private boolean isReadable() {
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.isReadable0(this.handle);
    }

    @Override
    public boolean canWrite() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (!this.exists0(this.actualPath)) {
            return false;
        }
        return this.isWriteable();
    }

    boolean isWriteable() {
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.isWriteable0(this.handle);
    }

    public static FileConnection createTempFile(String prefix, String suffix) {
        return new FileConnection("/temp/" + prefix + tempFileCounter++ + suffix);
    }

    public void deleteOnExit() {
    }

    @Override
    public void deleteOnReset() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        this.deleteOnReset = true;
    }

    @Override
    public boolean deleteAll() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (!this.canWrite()) {
            return false;
        }
        if (!fsHelper.canDelete(!this.accessCheck, this, this.actualPath, true)) {
            return false;
        }
        if (this.isDirectory0(this.actualPath) && this.isAnyFileInDirectoryNotWritable(this)) {
            return false;
        }
        boolean deleted = this.delete0(this.actualPath, false);
        if (deleted) {
            fsHelper.closeStreamsForDeletedFilesOrDirs(this.actualPath);
        }
        return deleted;
    }

    boolean isAnyFileInDirectoryNotWritable(FileConnection aDirectory) throws IOException {
        boolean result = false;
        FileConnection[] FCs = aDirectory.listFiles();
        if (FCs != null) {
            for (FileConnection fc : FCs) {
                if (!fc.isWriteable()) {
                    result = true;
                    break;
                }
                if (fc.isDirectory0(fc.actualPath) && (result = this.isAnyFileInDirectoryNotWritable(fc))) break;
            }
            for (FileConnection fc : FCs) {
                fc.close();
            }
        }
        return result;
    }

    public FileConnection getCanonicalFile() {
        return this;
    }

    public String getCanonicalPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        String pathToReturn = this.path;
        if (pathToReturn.startsWith("//")) {
            pathToReturn = pathToReturn.substring(new String("//").length());
        }
        return pathToReturn;
    }

    public String toString() {
        return this.getPath();
    }

    private FileConnection getParentFile(String forPath) {
        String appURI = "";
        if (forPath.startsWith(URLSCHEME)) {
            forPath = forPath.substring(forPath.indexOf(58) + 1);
        }
        String tmpPath = forPath;
        if (forPath.startsWith("//")) {
            tmpPath = forPath.substring(2);
        }
        if (this.accessCheck && (appURI = JCSystem.getURI()).startsWith("//")) {
            appURI = appURI.substring(2);
        }
        if (tmpPath.equals(PATHSEPARATORSTRING) || appURI.equals(tmpPath) || forPath.equals(appURI)) {
            return null;
        }
        return new FileConnection(forPath.substring(0, forPath.lastIndexOf(47)), this.accessCheck, 3);
    }

    public FileConnection getParentFile() {
        return this.getParentFile(this.path);
    }

    @Override
    public String getParent() {
        FileConnection parent = this.getParentFile();
        if (parent == null) {
            return null;
        }
        String path = parent.getPath();
        parent.close();
        return path;
    }

    @Override
    public String getURL() {
        String urlToReturn = this.path;
        if (urlToReturn.startsWith("//")) {
            urlToReturn = urlToReturn.substring(new String("//").length());
        }
        return URLSCHEME + urlToReturn;
    }

    public long lastModified() {
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.getLastModified0(this.handle);
    }

    public int length() {
        return this.length0(this.actualPath);
    }

    @Override
    public Enumeration<String> list() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.isDirectory()) {
            if (!this.canRead()) {
                return null;
            }
            boolean isWEBINF = false;
            if (this.accessCheck) {
                if (this.path.equals(this.webinf)) {
                    isWEBINF = true;
                }
                if (this.path.startsWith(this.metainf)) {
                    return null;
                }
            }
            int childCount = this.childCount0(this.actualPath);
            Vector<String> children = new Vector<String>();
            for (int i = 0; i < childCount; ++i) {
                String node = this.childName0(this.actualPath, i);
                if (this.accessCheck && (isWEBINF && (node.startsWith("classes") || node.startsWith("lib") || node.startsWith("web.xml")) || this.path.equals(this.docroot) && node.startsWith(METAINF))) continue;
                children.addElement(node);
            }
            return children.elements();
        }
        return null;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.closed || !this.exists() || this.isDirectory() || this.mode == 2 || this.is != null || !this.canRead() || this.inputStreamOpened) {
            throw new IOException();
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        this.is = new NativeInputStream(this);
        Vector<FileConnection> isv = inputStreams.get(this.actualPath);
        if (isv == null) {
            isv = new Vector();
            inputStreams.put(this.actualPath, isv);
        }
        isv.addElement(this);
        this.inputStreamOpened = true;
        return this.is;
    }

    @Override
    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.openOutputStream(false);
    }

    @Override
    public OutputStream openOutputStream(boolean append) throws IOException {
        if (this.closed || this.os != null || this.mode == 1 || this.isDirectory0(this.actualPath) || this.outputStreamOpened) {
            throw new IOException();
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (!this.exists0(this.actualPath)) {
            FileConnection parentFile = this.getParentFile();
            if (parentFile == null) {
                throw new IOException();
            }
            if (!(!parentFile.exists0(parentFile.actualPath) || parentFile.isWriteable() && parentFile.isDirectory0(parentFile.actualPath))) {
                throw new IOException();
            }
            this.create();
            if (this.handle == 0) {
                throw new IOException();
            }
            this.setLastModified0(this.handle, System.currentTimeMillis());
        } else {
            if (!this.isWriteable()) {
                throw new IOException();
            }
            this.handle = this.open0(this.actualPath, append);
        }
        this.os = new NativeOutputStream(this, append);
        Vector<FileConnection> osv = outputStreams.get(this.actualPath);
        if (osv == null) {
            osv = new Vector();
            outputStreams.put(this.actualPath, osv);
        }
        osv.addElement(this);
        this.outputStreamOpened = true;
        return this.os;
    }

    @Override
    public DataOutputStream openDataOutputStream(boolean append) throws IOException {
        return new DataOutputStream(this.openOutputStream(append));
    }

    @Override
    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream(false));
    }

    @Override
    public void close() {
        this.closed = true;
        fsHelper.removeFromOpenConnections(this, this.actualPath);
    }

    public FileConnection[] listFiles() throws IOException {
        if (!this.isDirectory()) {
            return null;
        }
        Object[] fs = null;
        Enumeration<String> children = this.list();
        if (children != null) {
            Vector<FileConnection> files = new Vector<FileConnection>();
            while (children.hasMoreElements()) {
                files.addElement(new FileConnection(this.actualPath, children.nextElement()));
            }
            fs = new FileConnection[files.size()];
            files.copyInto(fs);
        }
        return fs;
    }

    @Override
    public long getLastModified() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (!this.exists()) {
            return 0L;
        }
        if (!this.isReadable()) {
            return 0L;
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.getLastModified0(this.handle);
    }

    @Override
    public boolean setLastModified(long time) throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (time < 0L) {
            throw new IllegalArgumentException("Negative time value");
        }
        if (!this.exists0(this.actualPath)) {
            return false;
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        if (!this.isWriteable0(this.handle)) {
            return false;
        }
        return this.setLastModified0(this.handle, time);
    }

    @Override
    public boolean renameTo(String destFileURL) throws IOException {
        boolean flag;
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (destFileURL == null) {
            throw new NullPointerException();
        }
        String toFile = URIUtils.resolveWithScheme("file", destFileURL);
        if (!(toFile = URIUtils.normalize(toFile)).startsWith(URLSCHEME)) {
            throw new IllegalArgumentException();
        }
        if (!URIUtils.isInAppNamespace(toFile)) {
            throw new SecurityException();
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
            AccessController.checkPermission(new ConnectorPermission(toFile, "write"));
        }
        if (!this.exists0(this.actualPath)) {
            return false;
        }
        if (!this.isWriteable()) {
            return false;
        }
        FileConnection currentParent = this.getParentFile();
        if (currentParent == null) {
            return false;
        }
        if (!currentParent.isWriteable()) {
            currentParent.close();
            return false;
        }
        currentParent.close();
        String appURI = JCSystem.getURI();
        String actualRoot = fileMap.get(appURI);
        String s = toFile.substring(5);
        s = s.substring(appURI.length());
        String newName = actualRoot + s;
        if (this.exists0(newName)) {
            return false;
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        if (!this.canRename(toFile)) {
            return false;
        }
        FileConnection newParent = this.getParentFile(toFile);
        if (!newParent.exists0(newParent.actualPath)) {
            newParent.handle = this.mkdirs0(newParent.actualPath, false, 3);
            if (newParent.handle == 0) {
                return false;
            }
            newParent.close();
        }
        if (flag = this.renameTo0(this.handle, newName)) {
            this.path = appURI + s;
            this.actualPath = newName;
            int ndx = this.path.lastIndexOf(47);
            this.name = ndx == -1 ? null : this.path.substring(ndx + 1);
        }
        return flag;
    }

    boolean canRename(String newPath) {
        FileConnection newParent = this.getParentFile(newPath);
        while (newParent != null) {
            if (newParent.exists0(newParent.actualPath)) {
                if (!newParent.isDirectory0(newParent.actualPath) || !newParent.isWriteable()) {
                    newParent.close();
                    return false;
                }
                newParent.close();
                return true;
            }
            FileConnection newGrandParent = newParent.getParentFile();
            newParent.close();
            newParent = newGrandParent;
        }
        return false;
    }

    @Override
    public boolean setReadOnly() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (!this.exists0(this.actualPath)) {
            return false;
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.setReadOnly0(this.handle);
    }

    @Override
    public boolean setReadable(boolean mode) throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (!this.exists0(this.actualPath)) {
            return false;
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.setReadable0(this.handle, mode);
    }

    @Override
    public boolean setWritable(boolean mode) throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "write"));
        }
        if (!this.exists0(this.actualPath)) {
            return false;
        }
        if (this.handle == 0) {
            this.handle = this.open0(this.actualPath, false);
        }
        return this.setWriteable0(this.handle, mode);
    }

    @Override
    public long getFreeSpace() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "read"));
        }
        return this.getFreeSpace0();
    }

    @Override
    public long getTotalSpace() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (this.accessCheck) {
            AccessController.checkPermission(new ConnectorPermission(URIUtils.resolveWithScheme(URLSCHEME, this.path), "read"));
        }
        return this.getTotalSpace0();
    }

    @Override
    public long getLength() throws IOException {
        if (this.closed) {
            throw new IOException("FileConnection has been closed");
        }
        if (!this.exists()) {
            return 0L;
        }
        if (this.isDirectory()) {
            return -1L;
        }
        if (!this.isReadable()) {
            return 0L;
        }
        return this.length0(this.actualPath);
    }

    int getAvailable(int pos) {
        return this.getAvailable0(this.handle, pos);
    }

    int readByte(int index) {
        return this.read0(this.handle, index);
    }

    void writeByte(int index, int data) {
        this.write0(this.handle, index, (byte)(data & 0xFF));
    }

    private native int read0(int var1, int var2);

    private native boolean exists0(String var1);

    native boolean isDirectory0(String var1);

    private native boolean isFile0(String var1);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native int create0(String var1, boolean var2, int var3);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native int mkdirs0(String var1, boolean var2, int var3);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native boolean delete0(String var1, boolean var2);

    private native int length0(String var1);

    private native int childCount0(String var1);

    private native String childName0(String var1, int var2);

    private native void write0(int var1, int var2, byte var3);

    native int open0(String var1, boolean var2);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native boolean renameTo0(int var1, String var2);

    private native long getLastModified0(int var1);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    native boolean setLastModified0(int var1, long var2);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native boolean setReadOnly0(int var1);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native boolean setReadable0(int var1, boolean var2);

    @TransactionType(value=TransactionTypeValue.REQUIRED)
    private native boolean setWriteable0(int var1, boolean var2);

    private native long getFreeSpace0();

    private native long getTotalSpace0();

    native boolean isWriteable0(int var1);

    native boolean isReadable0(int var1);

    private native int getAvailable0(int var1, int var2);

    static {
        NativeMethods.setJCREentry(fileMap, false);
        NativeMethods.setJCREentry(inputStreams, false);
        NativeMethods.setJCREentry(outputStreams, false);
        NativeMethods.setJCREentry(openConnections, false);
        NativeMethods.setJCREentry(fsHelper, false);
    }

    static class NativeOutputStream
    extends OutputStream {
        private FileConnection fileConnection;
        int pos = 0;
        boolean open = true;
        boolean append = false;

        public NativeOutputStream(FileConnection fileConnection) {
            this.fileConnection = fileConnection;
            this.append = false;
        }

        private NativeOutputStream(FileConnection fileConnection, boolean append) {
            this.fileConnection = fileConnection;
            this.append = append;
            if (this.append) {
                this.pos += this.fileConnection.length();
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.open) {
                throw new IOException();
            }
            this.fileConnection.writeByte(this.pos++, b);
            this.fileConnection.setLastModified0(this.fileConnection.handle, System.currentTimeMillis());
        }

        @Override
        public void close() throws IOException {
            this.open = false;
            Vector<FileConnection> osv = outputStreams.get(this.fileConnection.actualPath);
            if (osv != null && osv.size() > 0) {
                osv.removeElement(this.fileConnection);
                if (osv.size() == 0) {
                    outputStreams.remove(this.fileConnection.actualPath);
                }
            }
            this.fileConnection.os = null;
        }
    }

    static class NativeInputStream
    extends InputStream {
        private FileConnection fileConnection;
        int pos = 0;
        boolean open = true;

        public NativeInputStream(FileConnection fileConnection) {
            this.fileConnection = fileConnection;
        }

        @Override
        public int read() throws IOException {
            if (!this.open) {
                throw new IOException();
            }
            int x = this.fileConnection.readByte(this.pos);
            if (x == -1) {
                return -1;
            }
            ++this.pos;
            return x;
        }

        @Override
        public int available() {
            return this.fileConnection.getAvailable(this.pos);
        }

        @Override
        public void close() throws IOException {
            this.open = false;
            short currentContext = NativeMethods.getCurrentContext();
            byte currentApp = NativeMethods.getCurrentAppId();
            NativeMethods.switchContext(0, 0);
            Vector<FileConnection> isv = inputStreams.get(this.fileConnection.actualPath);
            NativeMethods.transferOwnershiptoContext(isv, currentContext, currentApp);
            NativeMethods.switchContext(currentContext, currentApp);
            if (isv != null && isv.size() > 0) {
                isv.removeElement(this.fileConnection);
                if (isv.size() == 0) {
                    inputStreams.remove(this.fileConnection.actualPath);
                }
            }
            this.fileConnection.is = null;
        }
    }
}

