/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.security;

import javacard.framework.Shareable;
import javacardx.biometry.BioBuilder;
import javacardx.biometry.BioException;
import javacardx.biometry.OwnerBioTemplate;
import javacardx.facilities.ServiceFactory;
import javacardx.framework.SharedPINAuth;
import javacardx.framework.SharedPasswordAuth;
import javacardx.framework.TransactionType;
import javacardx.framework.TransactionTypeValue;
import javacardx.framework.TransientReference;
import javacardx.servlet.http.HttpDigestAuthentication;

@TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
public class PasswordSessionAuthenticatorFactory
implements ServiceFactory {
    private final OwnerBioTemplate ownerPassword;

    public PasswordSessionAuthenticatorFactory(String password, int tryLimit) {
        this.ownerPassword = BioBuilder.buildBioTemplate((byte)31, (byte)tryLimit);
        byte[] pwdBytes = password.getBytes();
        this.ownerPassword.init(pwdBytes, (short)0, (byte)pwdBytes.length);
        this.ownerPassword.doFinal();
    }

    @Override
    public Shareable create(String serviceURI, Object parameter) throws SecurityException {
        if ((serviceURI.startsWith("sio:///standard/auth/holder/session") || serviceURI.startsWith("sio:///standard/auth/user/session")) && (serviceURI.endsWith("/password") || serviceURI.endsWith("/pin"))) {
            return new SessionPasswordAuth();
        }
        return null;
    }

    public OwnerBioTemplate getOwnerPassword() {
        return this.ownerPassword;
    }

    @TransactionType(value=TransactionTypeValue.SUPPORTS)
    private class SessionPasswordAuth
    implements SharedPasswordAuth,
    SharedPINAuth,
    HttpDigestAuthentication {
        private final TransientReference<Boolean> validated = new TransientReference<Boolean>(false);

        private SessionPasswordAuth() {
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(String password) {
            byte[] pwdBytes = password.getBytes();
            return this.check(pwdBytes, (short)0, (byte)pwdBytes.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(String username, String realm, String method, String uri, String nonce, String nc, String cnonce, String qop, String response) {
            this.validated.set(false);
            OwnerBioTemplate ownerBioTemplate = PasswordSessionAuthenticatorFactory.this.ownerPassword;
            synchronized (ownerBioTemplate) {
                try {
                    try {
                        if (PasswordSessionAuthenticatorFactory.this.ownerPassword instanceof HttpDigestAuthentication) {
                            ((HttpDigestAuthentication)((Object)PasswordSessionAuthenticatorFactory.this.ownerPassword)).check(username, realm, method, uri, nonce, nc, cnonce, qop, response);
                        }
                        this.validated.set(PasswordSessionAuthenticatorFactory.this.ownerPassword.isValidated());
                    }
                    finally {
                        PasswordSessionAuthenticatorFactory.this.ownerPassword.reset();
                    }
                }
                catch (BioException be) {
                    // empty catch block
                }
            }
            return this.validated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public boolean check(byte[] pin, short offset, byte length) throws ArrayIndexOutOfBoundsException, NullPointerException {
            this.validated.set(false);
            OwnerBioTemplate ownerBioTemplate = PasswordSessionAuthenticatorFactory.this.ownerPassword;
            synchronized (ownerBioTemplate) {
                try {
                    PasswordSessionAuthenticatorFactory.this.ownerPassword.initMatch(pin, offset, length);
                    this.validated.set(PasswordSessionAuthenticatorFactory.this.ownerPassword.isValidated());
                }
                catch (BioException be) {
                }
                finally {
                    PasswordSessionAuthenticatorFactory.this.ownerPassword.reset();
                }
            }
            return this.validated.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte getTriesRemaining() {
            OwnerBioTemplate ownerBioTemplate = PasswordSessionAuthenticatorFactory.this.ownerPassword;
            synchronized (ownerBioTemplate) {
                return PasswordSessionAuthenticatorFactory.this.ownerPassword.getTriesRemaining();
            }
        }

        @Override
        public boolean isValidated() {
            return this.validated.get() != null && this.validated.get() != false;
        }

        @Override
        @TransactionType(value=TransactionTypeValue.NOT_SUPPORTED)
        public void reset() {
            if (this.validated.get() != null && this.validated.get().booleanValue()) {
                this.validated.set(false);
            }
        }
    }
}

